/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;

public class Throbber
extends JComponent
implements ActionListener {
    protected int fTicksNumber = 15;
    protected Area[] fTickAreas;
    protected Color[] fTickColors;
    protected int fTickColorOffset = 0;
    public static final int STYLE_BARS = 1;
    public static final int STYLE_DOTS = 2;
    protected int fStyle = 1;
    protected double fScale = 1.0;
    protected Timer fTimer = new Timer(100, this);
    protected Rectangle fRelativeTicksBounds;
    protected Rectangle fTicksBounds;
    protected AffineTransform fTransform;
    protected double fFillBoundsScale = 1.0;
    protected boolean fFillBounds = false;
    protected int fRadius = 48;
    protected static final int BAR_WIDTH = 32;
    protected static final int BAR_HEIGHT = 16;

    public Throbber() {
        this.buildTicks();
    }

    public int getStyle() {
        return this.fStyle;
    }

    public void setStyle(int aStyle) {
        if (this.fStyle != aStyle) {
            this.fStyle = aStyle;
            this.buildTicks();
        }
    }

    public int getTicksNumber() {
        return this.fTicksNumber;
    }

    public void setTicksNumber(int aTicksNumber) {
        if (aTicksNumber < 5) {
            throw new IllegalArgumentException("Invalid tick number: " + aTicksNumber);
        }
        if (this.fTicksNumber != aTicksNumber) {
            this.fTicksNumber = aTicksNumber;
            this.buildTicks();
            this.repaint();
        }
    }

    public double getScale() {
        return this.fScale;
    }

    public void setScale(double aScale) {
        if (aScale <= 0.0) {
            throw new IllegalArgumentException("Invalid scale:" + aScale);
        }
        if (this.fScale != aScale) {
            this.fScale = aScale;
            this.calcRelativeTicksBounds();
            this.repaint();
        }
    }

    protected double getScaleInt() {
        return this.isFillBounds() ? this.fFillBoundsScale : this.fScale;
    }

    public boolean isFillBounds() {
        return this.fFillBounds;
    }

    public void setFillBounds(boolean aFillBounds) {
        if (this.fFillBounds != aFillBounds) {
            this.fFillBounds = aFillBounds;
            this.updateFillBoundsScale();
            this.calcRelativeTicksBounds();
            this.repaint();
        }
    }

    private void updateFillBoundsScale() {
        if (this.fTicksBounds != null) {
            int gap = 1;
            Insets insets = this.getInsets();
            int w = this.getWidth() - insets.left - insets.right;
            int h = this.getHeight() - insets.top - insets.bottom;
            this.fFillBoundsScale = Math.min((double)(w - 2 * gap) / (double)this.fTicksBounds.width, (double)(h - 2 * gap) / (double)this.fTicksBounds.height);
        }
    }

    public int getRadius() {
        return this.fRadius;
    }

    public void setRadius(int aRadius) {
        if (this.fRadius != aRadius) {
            this.fRadius = aRadius;
            this.buildTicks();
            this.repaint();
        }
    }

    public boolean isOpaque() {
        return false;
    }

    protected void buildTicks() {
        this.fTickColorOffset = 0;
        this.buildTickAreas();
        this.buildTickColors();
        this.calcTicksBounds();
        this.updateFillBoundsScale();
        this.calcRelativeTicksBounds();
    }

    protected void calcTicksBounds() {
        this.fTicksBounds = new Rectangle();
        for (int i = 0; i < this.fTickAreas.length; ++i) {
            this.fTicksBounds = this.fTicksBounds.union(this.fTickAreas[i].getBounds());
        }
    }

    protected void buildTickColors() {
        this.fTickColors = new Color[this.fTicksNumber];
        Color fc = this.getForeground();
        if (fc == null) {
            fc = Color.BLACK;
        }
        float rs = fc.getRed();
        float gs = fc.getGreen();
        float bs = fc.getBlue();
        float as = fc.getAlpha();
        Color bc = this.getBackground();
        if (bc == null) {
            bc = Color.LIGHT_GRAY;
        }
        float re = bc.getRed();
        float ge = bc.getGreen();
        float be = bc.getBlue();
        float ae = bc.getAlpha();
        double rf = ((double)rs - (double)re) / (double)this.fTicksNumber;
        double gf = ((double)gs - (double)ge) / (double)this.fTicksNumber;
        double bf = ((double)bs - (double)be) / (double)this.fTicksNumber;
        double af = ((double)as - (double)ae) / (double)this.fTicksNumber;
        for (int i = 0; i < this.fTickAreas.length; ++i) {
            int r = (int)Math.round((double)re + (double)(this.fTicksNumber - i) * rf);
            int g = (int)Math.round((double)ge + (double)(this.fTicksNumber - i) * gf);
            int b = (int)Math.round((double)be + (double)(this.fTicksNumber - i) * bf);
            int a = (int)Math.round((double)ae + (double)(this.fTicksNumber - i) * af);
            this.fTickColors[i] = new Color(r, g, b, a);
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.buildTickColors();
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.buildTickColors();
    }

    protected void buildTickAreas() {
        this.fTickAreas = new Area[this.fTicksNumber];
        double angleInc = Math.PI * 2 / (double)this.fTicksNumber;
        for (int i = 0; i < this.fTicksNumber; ++i) {
            Area tick;
            switch (this.fStyle) {
                case 2: {
                    tick = this.buildDot();
                    break;
                }
                default: {
                    tick = this.buildBar();
                }
            }
            AffineTransform transform = new AffineTransform();
            transform.concatenate(AffineTransform.getTranslateInstance(this.fRadius, -8.0));
            tick.transform(transform);
            tick.transform(AffineTransform.getRotateInstance(angleInc * (double)(-i), 0.0, 0.0));
            this.fTickAreas[i] = tick;
        }
    }

    protected Area buildBar() {
        Area result = new Area(new Rectangle2D.Double(8.0, 0.0, 32.0, 16.0));
        result.add(new Area(new Ellipse2D.Double(0.0, 0.0, 16.0, 16.0)));
        result.add(new Area(new Ellipse2D.Double(32.0, 0.0, 16.0, 16.0)));
        return result;
    }

    protected Area buildDot() {
        return new Area(new Ellipse2D.Double(0.0, 0.0, 16.0, 16.0));
    }

    public void actionPerformed(ActionEvent e) {
        this.fTickColorOffset = this.fTickColorOffset == this.fTicksNumber - 1 ? 0 : ++this.fTickColorOffset;
        if (this.fRelativeTicksBounds != null) {
            this.repaint(this.fRelativeTicksBounds);
        } else {
            this.repaint();
        }
    }

    public void start() {
        this.fTimer.start();
    }

    public boolean isRunning() {
        return this.fTimer.isRunning();
    }

    public void setRunning(boolean isRunning) {
        if (isRunning) {
            this.fTimer.start();
        } else {
            this.fTimer.stop();
        }
    }

    public void stop() {
        this.fTimer.stop();
    }

    public void setVisible(boolean aVisible) {
        super.setVisible(aVisible);
        if (!aVisible && this.isRunning()) {
            this.stop();
        }
    }

    public void removeNotify() {
        if (this.isRunning()) {
            this.stop();
        }
        super.removeNotify();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.updateFillBoundsScale();
        this.calcRelativeTicksBounds();
    }

    protected void calcRelativeTicksBounds() {
        this.fTransform = new AffineTransform();
        this.fTransform.translate((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        double scale = this.getScaleInt();
        this.fTransform.scale(scale, scale);
        if (this.fTicksBounds != null) {
            Area bounds = new Area(this.fTicksBounds);
            bounds.transform(this.fTransform);
            this.fRelativeTicksBounds = bounds.getBounds();
        }
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.transform(this.fTransform);
        if (this.isRunning()) {
            int i = 0;
            int index = this.fTickColorOffset;
            while (i < this.fTickAreas.length) {
                if (index >= this.fTickColors.length) {
                    index = 0;
                }
                g2d.setColor(this.fTickColors[index]);
                g2d.fill(this.fTickAreas[i]);
                ++i;
                ++index;
            }
        } else {
            g2d.setColor(this.fTickColors[this.fTickColors.length / 2]);
            for (int i = 0; i < this.fTickAreas.length; ++i) {
                g2d.fill(this.fTickAreas[i]);
            }
        }
    }
}

