/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.BasicComponentPainter;
import dev.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;

public class TextComponentPainter
extends BasicComponentPainter {
    protected String fText;
    protected Color fColor;

    public String getText() {
        return this.fText;
    }

    public void setText(String aText) {
        this.fText = aText;
    }

    public TextComponentPainter() {
    }

    public TextComponentPainter(String aText) {
        this(aText, 16);
    }

    public TextComponentPainter(String aText, int aAlignment) {
        super(0, 0, aAlignment, true);
        this.fText = aText;
    }

    public int getHeight(Graphics g, Component c) {
        int result = 0;
        String text = this.getText();
        if (!StringUtils.noValue(text)) {
            result = g.getFontMetrics(this.getFont(c)).getHeight();
        }
        return result;
    }

    protected Font getFont(Component c) {
        return c.getFont();
    }

    public int getWidth(Graphics g, Component c) {
        int result = 0;
        String text = this.getText();
        if (!StringUtils.noValue(text)) {
            result = g.getFontMetrics(this.getFont(c)).charsWidth(text.toCharArray(), 0, text.length());
        }
        return result;
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setColor(Color aColor) {
        this.fColor = aColor;
    }

    protected void paintImpl(Graphics g, Component c) {
        if (this.fColor != null) {
            g.setColor(this.fColor);
        }
        if (!StringUtils.noValue(this.getText())) {
            g.drawString(this.getText(), 0, g.getFontMetrics(g.getFont()).getAscent());
        }
    }
}

