/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.UIUtils;
import java.awt.Color;
import javax.swing.UIManager;

public class LafColor
extends Color {
    protected String fColorKey;
    protected Color fDefaultColor;
    protected float fKoefficient = 0.0f;
    protected Color fCachedLafColor;
    protected Color fCachedColor;

    public LafColor() {
        super(0);
    }

    public LafColor(String aColorKey, float aKoefficient, Color aDefaultColor) {
        this();
        this.fColorKey = aColorKey;
        this.fKoefficient = aKoefficient;
        this.fDefaultColor = aDefaultColor;
    }

    public LafColor(String aColorKey, float aKoefficient) {
        this(aColorKey, aKoefficient, null);
    }

    public LafColor(String aColorKey) {
        this(aColorKey, 0.0f);
    }

    public int getRGB() {
        Color c = UIManager.getColor(this.fColorKey);
        if (c == null) {
            c = this.fDefaultColor;
        }
        if (!(c == null || this.fCachedLafColor != null && this.fCachedLafColor.equals(c))) {
            this.fCachedLafColor = this.fCachedColor = c;
            if (this.fKoefficient > 0.0f) {
                this.fCachedColor = UIUtils.getBrighter(this.fCachedLafColor, this.fKoefficient);
            } else if (this.fKoefficient < 0.0f) {
                this.fCachedColor = UIUtils.getDarker(this.fCachedLafColor, Math.abs(this.fKoefficient));
            }
        }
        return this.fCachedColor != null ? this.fCachedColor.getRGB() : 0;
    }
}

