/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.ComponentFontSupport;
import dev.gui.ComponentPainter;
import dev.gui.ComponentPainterHolder;
import dev.gui.ComponentPainterSupport;
import dev.gui.FixedCharsDocument;
import dev.gui.IndicatorHolder;
import dev.gui.InitializableComponentPainter;
import dev.gui.TooltipProvider;
import dev.gui.border.IndicatorBorder;
import dev.gui.insight.TextInsightDelegateSupport;
import dev.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class JTextFieldEx
extends JTextField
implements IndicatorHolder,
FocusListener,
ComponentPainterHolder {
    protected boolean fSelectAllOnFocusGain = true;
    protected boolean fIgnoreOnceSelectAllOnFocusGain = false;
    protected boolean fReturnEmptyText = true;
    protected int fPreferredHeight = -1;
    protected int fPreferredWidth = -1;
    protected IndicatorBorder fIndicatorBorder;
    protected Border fOriginalBorder;
    protected int fMinimumHeight = -1;
    protected int fMinimumWidth = -1;
    protected ComponentPainterSupport fComponentPainterSupport;
    protected TextInsightDelegateSupport fTextInsightDelegateSupport = new TextInsightDelegateSupport(this){

        protected String[] doPrimaryAction() {
            JTextFieldEx.this.fIgnoreOnceSelectAllOnFocusGain = true;
            return super.doPrimaryAction();
        }
    };
    protected PromptTextComponentPainter fPromptTextComponentPainter;
    protected ComponentFontSupport fComponentFontSupport = new ComponentFontSupport(this);

    public JTextFieldEx() {
        this.init();
    }

    public JTextFieldEx(String text) {
        super(text);
        this.init();
    }

    public JTextFieldEx(int columns) {
        super(columns);
        this.init();
    }

    public JTextFieldEx(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public JTextFieldEx(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.init();
    }

    protected void init() {
        this.addFocusListener(this);
        this.setDocument(new FixedCharsDocument());
    }

    public int getMaxChars() {
        return this.getDocument() instanceof FixedCharsDocument ? ((FixedCharsDocument)this.getDocument()).getMaxChars() : -1;
    }

    public void setMaxChars(int aMaxChars) {
        if (this.getDocument() instanceof FixedCharsDocument) {
            ((FixedCharsDocument)this.getDocument()).setMaxChars(aMaxChars);
        }
    }

    public boolean isSelectAllOnFocusGain() {
        return this.fSelectAllOnFocusGain;
    }

    public void setSelectAllOnFocusGain(boolean aSelectAllOnFocusGain) {
        this.fSelectAllOnFocusGain = aSelectAllOnFocusGain;
    }

    protected void onFocusGained() {
        if (this.isSelectAllOnFocusGain() && !this.fIgnoreOnceSelectAllOnFocusGain) {
            this.selectAllOnFocusGain();
        }
        this.fIgnoreOnceSelectAllOnFocusGain = false;
    }

    protected void selectAllOnFocusGain() {
        this.selectAll();
    }

    public void setText(String t) {
        if (t != null) {
            int index = t.indexOf(10);
            if (index == -1) {
                index = t.indexOf(13);
            }
            if (index == -1) {
                index = t.indexOf(12);
            }
            if (index != -1) {
                t = t.substring(0, index);
            }
        }
        String oldValue = this.getText();
        super.setText(t);
        if (!StringUtils.equals(oldValue, t)) {
            this.firePropertyChange("text", oldValue, t);
        }
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        Insets insets = this.getInsets();
        result.height = this.getFontMetrics(this.getFont()).getHeight() + insets.top + insets.bottom;
        if (this.fPreferredWidth != -1) {
            result.width = this.fPreferredWidth;
        }
        if (this.fPreferredHeight != -1) {
            result.height = this.fPreferredHeight;
        }
        return result;
    }

    public boolean isReturnEmptyText() {
        return this.fReturnEmptyText;
    }

    public void setReturnEmptyText(boolean aReturnEmptyText) {
        this.fReturnEmptyText = aReturnEmptyText;
    }

    public String getText() {
        String result = super.getText();
        return this.isReturnEmptyText() ? result : (StringUtils.noValue(result) ? null : result);
    }

    public int getPreferredHeight() {
        return this.fPreferredHeight;
    }

    public void setPreferredHeight(int aPreferredHeight) {
        this.fPreferredHeight = aPreferredHeight;
    }

    public int getPreferredWidth() {
        return this.fPreferredWidth;
    }

    public void setPreferredWidth(int aPreferredWidth) {
        this.fPreferredWidth = aPreferredWidth;
    }

    public void updateUI() {
        super.updateUI();
        if (!(this.getBorder() instanceof IndicatorBorder.CompoundBorder)) {
            this.fOriginalBorder = this.getBorder();
        }
        this.updateBorder();
    }

    private void updateBorder() {
        if (!StringUtils.noValue(this.getIndicator())) {
            this.setBorder(new IndicatorBorder.CompoundBorder(this.fIndicatorBorder, this.fOriginalBorder));
        } else {
            this.setBorder(this.fOriginalBorder);
        }
    }

    public String getIndicator() {
        return this.getIndicatorBorder().getIndicator();
    }

    public void setIndicator(String aIndicator) {
        if (aIndicator != this.getIndicator()) {
            this.getIndicatorBorder().setIndicator(aIndicator);
            this.updateBorder();
        }
    }

    protected IndicatorBorder getIndicatorBorder() {
        if (this.fIndicatorBorder == null) {
            this.fIndicatorBorder = new IndicatorBorder(null);
        }
        return this.fIndicatorBorder;
    }

    public Dimension getMinimumSize() {
        Dimension result = super.getMinimumSize();
        Insets insets = this.getInsets();
        result.height = this.getFontMetrics(this.getFont()).getHeight() + insets.top + insets.bottom;
        if (this.fMinimumWidth != -1) {
            result.width = this.fMinimumWidth;
        }
        if (this.fMinimumHeight != -1) {
            result.height = this.fMinimumHeight;
        }
        return result;
    }

    public int getMinimumHeight() {
        return this.fMinimumHeight;
    }

    public void setMinimumHeight(int aMinimumHeight) {
        this.fMinimumHeight = aMinimumHeight;
    }

    public int getMinimumWidth() {
        return this.fMinimumWidth;
    }

    public void setMinimumWidth(int aMinimumWidth) {
        this.fMinimumWidth = aMinimumWidth;
    }

    protected ComponentPainterSupport getComponentPainterSupport() {
        if (this.fComponentPainterSupport == null) {
            this.fComponentPainterSupport = new ComponentPainterSupport(this);
        }
        return this.fComponentPainterSupport;
    }

    public void addComponentPainter(ComponentPainter aComponentPainter) {
        this.getComponentPainterSupport().addComponentPainter(aComponentPainter);
    }

    public void removeComponentPainter(ComponentPainter aComponentPainter) {
        this.getComponentPainterSupport().removeComponentPainter(aComponentPainter);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.fComponentPainterSupport != null) {
            this.fComponentPainterSupport.paintComponent(g);
        }
    }

    public boolean isInsightEnabled() {
        return this.fTextInsightDelegateSupport.isEnabled();
    }

    public void setInsightEnabled(boolean aValue) {
        this.fTextInsightDelegateSupport.setEnabled(aValue);
    }

    public Class getInsightDelegateClass() {
        return this.fTextInsightDelegateSupport.getInsightDelegateClass();
    }

    public void setInsightDelegateClass(Class aInsightDelegateClass) {
        this.fTextInsightDelegateSupport.setInsightDelegateClass(aInsightDelegateClass);
    }

    public void addNotify() {
        super.addNotify();
        this.fTextInsightDelegateSupport.onAddNotify();
    }

    public void removeNotify() {
        this.fTextInsightDelegateSupport.onRemoveNotify();
        super.removeNotify();
    }

    public String getPromptText() {
        return this.fPromptTextComponentPainter != null ? this.fPromptTextComponentPainter.getText() : null;
    }

    public void setPromptText(String aText) {
        if (!StringUtils.noValue(aText)) {
            if (this.fPromptTextComponentPainter == null) {
                this.fPromptTextComponentPainter = new PromptTextComponentPainter(this, aText, false, 2);
                this.addComponentPainter(this.fPromptTextComponentPainter);
            } else {
                this.fPromptTextComponentPainter.setText(aText);
                if (this.isShowing()) {
                    this.fPromptTextComponentPainter.updateTextVisibility();
                }
            }
        } else if (this.fPromptTextComponentPainter != null) {
            this.removeComponentPainter(this.fPromptTextComponentPainter);
            this.fPromptTextComponentPainter = null;
        }
    }

    public void focusGained(FocusEvent e) {
        this.onFocusGained();
    }

    public void focusLost(FocusEvent e) {
    }

    public String getToolTipText(MouseEvent event) {
        String result = null;
        if (this.fComponentPainterSupport instanceof TooltipProvider) {
            result = this.fComponentPainterSupport.getToolTipText(event);
        }
        result = result != null ? result : super.getToolTipText(event);
        return StringUtils.noValue(result) ? null : result;
    }

    public void setFont(Font font) {
        super.setFont(this.fComponentFontSupport != null ? this.fComponentFontSupport.getFont(font) : font);
    }

    public int getFontStyle() {
        return this.fComponentFontSupport.getFontStyle();
    }

    public void setFontStyle(int aFontStyle) {
        this.fComponentFontSupport.setFontStyle(aFontStyle);
    }

    public int getFontIncrement() {
        return this.fComponentFontSupport.getFontIncrement();
    }

    public void setFontIncrement(int aFontIncrement) {
        this.fComponentFontSupport.setFontIncrement(aFontIncrement);
    }

    public float getFontSize() {
        return this.fComponentFontSupport.getFontSize();
    }

    public void setFontSize(float aFontSize) {
        this.fComponentFontSupport.setFontSize(aFontSize);
    }

    public static class PromptTextComponentPainter
    extends dev.gui.TextComponentPainter
    implements InitializableComponentPainter,
    FocusListener,
    PropertyChangeListener,
    DocumentListener {
        protected boolean fHideOnFocusGain = true;
        protected JTextComponent fComponent;
        protected boolean fShowPromptText = false;
        protected Font fLabelFont;
        protected Font fFont;
        protected Document fDocument;

        public PromptTextComponentPainter(JTextComponent aComponent, String aText, boolean aHideOnFocusGain, int anAlign) {
            super(aText, anAlign);
            this.fComponent = aComponent;
            this.fHideOnFocusGain = aHideOnFocusGain;
        }

        protected Font getFont(Component c) {
            Font labelFont = UIManager.getFont("Label.font");
            if (this.fFont == null || labelFont != null && !labelFont.equals(this.fLabelFont)) {
                this.fLabelFont = labelFont;
                this.fFont = this.fLabelFont.deriveFont(0);
            }
            return this.fFont;
        }

        protected void paintImpl(Graphics g, Component c) {
            if (this.fShowPromptText) {
                Font savFont = g.getFont();
                Color savColor = g.getColor();
                g.setFont(this.getFont(c));
                g.setColor(this.getTextColor());
                super.paintImpl(g, c);
                g.setColor(savColor);
                g.setFont(savFont);
            }
        }

        public Color getTextColor() {
            return UIManager.getColor("Label.disabledForeground");
        }

        public void init(Component aComponent) {
            this.setDocument(this.fComponent.getDocument());
            this.fComponent.addFocusListener(this);
            this.fComponent.addPropertyChangeListener(this);
            this.updateTextVisibility();
        }

        public void release(Component aComponent) {
            this.fComponent.removePropertyChangeListener(this);
            this.fComponent.removeFocusListener(this);
            this.setDocument(null);
            this.fComponent = null;
        }

        public void focusGained(FocusEvent e) {
            this.updateTextVisibility();
        }

        public void focusLost(FocusEvent e) {
            this.updateTextVisibility();
        }

        protected Document getDocument() {
            return this.fDocument;
        }

        protected void setDocument(Document aDocument) {
            if (this.fDocument != null) {
                this.fDocument.removeDocumentListener(this);
            }
            this.fDocument = aDocument;
            if (this.fDocument != null) {
                this.fDocument.addDocumentListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("document".equals(evt.getPropertyName())) {
                this.setDocument((Document)evt.getNewValue());
            }
        }

        protected void setShowText(boolean aValue) {
            if (this.fShowPromptText != aValue) {
                this.fShowPromptText = aValue;
                this.fComponent.repaint();
            }
        }

        public void updateTextVisibility() {
            boolean showPromptText = false;
            showPromptText = this.fDocument.getLength() > 0 ? false : !this.fComponent.hasFocus() || !this.fHideOnFocusGain;
            this.setShowText(showPromptText);
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateTextVisibility();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateTextVisibility();
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    public static class TextComponentPainter
    extends dev.gui.TextComponentPainter
    implements InitializableComponentPainter,
    FocusListener {
        public TextComponentPainter() {
            this(null);
        }

        public TextComponentPainter(String aText) {
            this(aText, 2);
        }

        public TextComponentPainter(String aText, int anAlignment) {
            super(aText, anAlignment);
        }

        protected void paintImpl(Graphics g, Component c) {
            if (!c.hasFocus() && this.needPaint(c)) {
                Color savColor = g.getColor();
                g.setColor(UIManager.getColor("Label.disabledForeground"));
                super.paintImpl(g, c);
                g.setColor(savColor);
            }
        }

        protected boolean needPaint(Component c) {
            return StringUtils.noValue(((JTextComponent)c).getText()) && !StringUtils.noValue(this.getText());
        }

        public void init(Component aComponent) {
            aComponent.addFocusListener(this);
        }

        public void release(Component aComponent) {
            aComponent.removeFocusListener(this);
        }

        public void focusGained(FocusEvent e) {
            Component c = e.getComponent();
            if (this.needPaint(c)) {
                c.repaint();
            }
        }

        public void focusLost(FocusEvent e) {
            Component c = e.getComponent();
            if (this.needPaint(c)) {
                c.repaint();
            }
        }
    }
}

