/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.ComponentFontSupport;
import dev.gui.ComponentPainter;
import dev.gui.CompoundComponentPainter;
import dev.gui.DelayedInvoker;
import dev.gui.FixedCharsDocument;
import dev.gui.IconComponentPainter;
import dev.gui.IndicatorHolder;
import dev.gui.TooltipProvider;
import dev.gui.border.IndicatorBorder;
import dev.gui.res.Images;
import dev.util.StringUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JPasswordField;
import javax.swing.border.Border;

public class JPasswordFieldEx
extends JPasswordField
implements FocusListener,
IndicatorHolder {
    protected boolean fReturnEmptyValue = true;
    protected int fPreferredHeight = -1;
    protected int fPreferredWidth = -1;
    protected int fMinimumHeight = -1;
    protected int fMinimumWidth = -1;
    protected IndicatorBorder fIndicatorBorder;
    protected Border fOriginalBorder;
    protected ComponentPainter fComponentPainter;
    protected boolean fCapsLockOn = false;
    protected boolean fTrackCapsLock = false;
    protected IconComponentPainter fCapsLockComponentPainter;
    protected DelayedInvoker fCapsLockDelayedInvoker;
    protected ComponentFontSupport fComponentFontSupport = new ComponentFontSupport(this);

    public JPasswordFieldEx() {
        this.addFocusListener(this);
        this.setDocument(new FixedCharsDocument());
    }

    public int getMaxChars() {
        return this.getDocument() instanceof FixedCharsDocument ? ((FixedCharsDocument)this.getDocument()).getMaxChars() : -1;
    }

    public void setMaxChars(int aMaxChars) {
        if (this.getDocument() instanceof FixedCharsDocument) {
            ((FixedCharsDocument)this.getDocument()).setMaxChars(aMaxChars);
        }
    }

    public void focusGained(FocusEvent e) {
        this.selectAll();
    }

    public void focusLost(FocusEvent e) {
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (this.fPreferredWidth != -1) {
            result.width = this.fPreferredWidth;
        }
        if (this.fPreferredHeight != -1) {
            result.height = this.fPreferredHeight;
        }
        return result;
    }

    public int getPreferredHeight() {
        return this.fPreferredHeight;
    }

    public void setPreferredHeight(int aPreferredHeight) {
        this.fPreferredHeight = aPreferredHeight;
    }

    public int getPreferredWidth() {
        return this.fPreferredWidth;
    }

    public void setPreferredWidth(int aPreferredWidth) {
        this.fPreferredWidth = aPreferredWidth;
    }

    public Dimension getMinimumSize() {
        Dimension result = super.getMinimumSize();
        Insets insets = this.getInsets();
        result.height = this.getFontMetrics(this.getFont()).getHeight() + insets.top + insets.bottom;
        if (this.fMinimumWidth != -1) {
            result.width = this.fMinimumWidth;
        }
        if (this.fMinimumHeight != -1) {
            result.height = this.fMinimumHeight;
        }
        return result;
    }

    public int getMinimumHeight() {
        return this.fMinimumHeight;
    }

    public void setMinimumHeight(int aMinimumHeight) {
        this.fMinimumHeight = aMinimumHeight;
    }

    public int getMinimumWidth() {
        return this.fMinimumWidth;
    }

    public void setMinimumWidth(int aMinimumWidth) {
        this.fMinimumWidth = aMinimumWidth;
    }

    public char[] getPassword() {
        char[] pwd = super.getPassword();
        return pwd.length == 0 ? (Object)(this.fReturnEmptyValue ? pwd : null) : pwd;
    }

    public String getPasswordAsString() {
        char[] pwd = this.getPassword();
        return pwd == null ? null : String.valueOf(pwd);
    }

    public boolean isReturnEmptyValue() {
        return this.fReturnEmptyValue;
    }

    public void setReturnEmptyValue(boolean aReturnEmptyValue) {
        this.fReturnEmptyValue = aReturnEmptyValue;
    }

    public void updateUI() {
        super.updateUI();
        if (!(this.getBorder() instanceof IndicatorBorder.CompoundBorder)) {
            this.fOriginalBorder = this.getBorder();
        }
        this.updateBorder();
    }

    private void updateBorder() {
        if (!StringUtils.noValue(this.getIndicator())) {
            this.setBorder(new IndicatorBorder.CompoundBorder(this.fIndicatorBorder, this.fOriginalBorder));
        } else {
            this.setBorder(this.fOriginalBorder);
        }
    }

    public String getIndicator() {
        return this.getIndicatorBorder().getIndicator();
    }

    public void setIndicator(String aIndicator) {
        if (aIndicator != this.getIndicator()) {
            this.getIndicatorBorder().setIndicator(aIndicator);
            this.updateBorder();
        }
    }

    protected IndicatorBorder getIndicatorBorder() {
        if (this.fIndicatorBorder == null) {
            this.fIndicatorBorder = new IndicatorBorder(null);
        }
        return this.fIndicatorBorder;
    }

    public ComponentPainter getComponentPainter() {
        return this.fComponentPainter;
    }

    public void setComponentPainter(ComponentPainter aComponentPainter) {
        if (this.fComponentPainter != aComponentPainter) {
            this.fComponentPainter = aComponentPainter;
            this.repaint();
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.fComponentPainter != null) {
            this.fComponentPainter.paint(g, this);
        }
    }

    public String getToolTipText(MouseEvent event) {
        String result = null;
        if (this.fComponentPainter instanceof TooltipProvider) {
            result = ((TooltipProvider)((Object)this.fComponentPainter)).getToolTipText(event);
        }
        result = result != null ? result : super.getToolTipText(event);
        return StringUtils.noValue(result) ? null : result;
    }

    public boolean testCapsLockOn() {
        boolean result = false;
        try {
            result = Toolkit.getDefaultToolkit().getLockingKeyState(20);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected boolean isCapsLockOn() {
        return this.fCapsLockOn;
    }

    protected void setCapsLockOn(boolean aValue) {
        if (this.fCapsLockOn != aValue) {
            this.fCapsLockOn = aValue;
            if (this.fCapsLockOn) {
                if (this.getComponentPainter() instanceof CompoundComponentPainter) {
                    ((CompoundComponentPainter)this.getComponentPainter()).addComponentPainter(this.fCapsLockComponentPainter);
                } else {
                    this.setComponentPainter(this.fCapsLockComponentPainter);
                }
            } else if (this.getComponentPainter() instanceof CompoundComponentPainter) {
                ((CompoundComponentPainter)this.getComponentPainter()).removeComponentPainter(this.fCapsLockComponentPainter);
            } else {
                this.setComponentPainter(null);
            }
        }
    }

    public boolean isTrackCapsLock() {
        return this.fTrackCapsLock;
    }

    public void removeNotify() {
        if (this.fCapsLockDelayedInvoker != null) {
            this.fCapsLockDelayedInvoker.stop();
            this.fCapsLockDelayedInvoker = null;
        }
        super.removeNotify();
    }

    public void setTrackCapsLock(boolean aTrackCapsLock) {
        if (this.fTrackCapsLock != aTrackCapsLock) {
            this.fTrackCapsLock = aTrackCapsLock;
            if (this.fTrackCapsLock) {
                this.fCapsLockComponentPainter = new IconComponentPainter(Images.CAPS_LOCK, 24);
                this.fCapsLockComponentPainter.setTooltipText("Caps Lock is ON");
                this.setCapsLockOn(this.testCapsLockOn());
                this.fCapsLockDelayedInvoker = new DelayedInvoker(250, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JPasswordFieldEx.this.setCapsLockOn(JPasswordFieldEx.this.testCapsLockOn());
                    }
                });
                this.fCapsLockDelayedInvoker.setCoalesce(true);
                this.fCapsLockDelayedInvoker.setRepeats(true);
                this.fCapsLockDelayedInvoker.start();
            } else {
                this.fCapsLockDelayedInvoker.stop();
                this.fCapsLockDelayedInvoker = null;
                this.setCapsLockOn(false);
                this.fCapsLockComponentPainter = null;
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(this.fComponentFontSupport != null ? this.fComponentFontSupport.getFont(font) : font);
    }

    public int getFontStyle() {
        return this.fComponentFontSupport.getFontStyle();
    }

    public void setFontStyle(int aFontStyle) {
        this.fComponentFontSupport.setFontStyle(aFontStyle);
    }

    public int getFontIncrement() {
        return this.fComponentFontSupport.getFontIncrement();
    }

    public void setFontIncrement(int aFontIncrement) {
        this.fComponentFontSupport.setFontIncrement(aFontIncrement);
    }

    public float getFontSize() {
        return this.fComponentFontSupport.getFontSize();
    }

    public void setFontSize(float aFontSize) {
        this.fComponentFontSupport.setFontSize(aFontSize);
    }
}

