/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.ComponentPainter;
import dev.gui.IndicatorHolder;
import dev.gui.border.IndicatorBorder;
import dev.util.StringUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.Format;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.MaskFormatter;

public class JFormattedTextFieldEx
extends JFormattedTextField
implements FocusListener,
IndicatorHolder {
    protected int fPreferredHeight = -1;
    protected int fPreferredWidth = -1;
    protected int fMinimumHeight = -1;
    protected int fMinimumWidth = -1;
    protected IndicatorBorder fIndicatorBorder;
    protected Border fOriginalBorder;
    protected boolean fReturnEmptyText = true;
    protected ComponentPainter fComponentPainter;

    public JFormattedTextFieldEx(String aMask) {
        this(aMask, ' ');
    }

    public JFormattedTextFieldEx(String aMask, char aPlaceholderCharacter) {
        super(JFormattedTextFieldEx.createFormatter(aMask, aPlaceholderCharacter));
        this.init();
    }

    private static JFormattedTextField.AbstractFormatter createFormatter(String aMask, char aPlaceholderCharacter) {
        try {
            MaskFormatter result = new MaskFormatter(aMask);
            result.setPlaceholderCharacter(aPlaceholderCharacter);
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Mask is invalid: " + aMask);
        }
    }

    public JFormattedTextFieldEx(Object value) {
        super(value);
        this.init();
    }

    public JFormattedTextFieldEx(Format format) {
        super(format);
        this.init();
    }

    public JFormattedTextFieldEx(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        this.init();
    }

    public JFormattedTextFieldEx(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
        this.init();
    }

    public JFormattedTextFieldEx(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
        this.init();
    }

    public JFormattedTextFieldEx() {
        this.init();
    }

    private void init() {
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFormattedTextFieldEx.this.selectAll();
            }
        });
    }

    public void focusLost(FocusEvent e) {
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (this.fPreferredWidth != -1) {
            result.width = this.fPreferredWidth;
        }
        if (this.fPreferredHeight != -1) {
            result.height = this.fPreferredHeight;
        }
        return result;
    }

    public int getPreferredHeight() {
        return this.fPreferredHeight;
    }

    public void setPreferredHeight(int aPreferredHeight) {
        this.fPreferredHeight = aPreferredHeight;
    }

    public int getPreferredWidth() {
        return this.fPreferredWidth;
    }

    public void setPreferredWidth(int aPreferredWidth) {
        this.fPreferredWidth = aPreferredWidth;
    }

    public Dimension getMinimumSize() {
        Dimension result = super.getMinimumSize();
        Insets insets = this.getInsets();
        result.height = this.getFontMetrics(this.getFont()).getHeight() + insets.top + insets.bottom;
        if (this.fMinimumWidth != -1) {
            result.width = this.fMinimumWidth;
        }
        if (this.fMinimumHeight != -1) {
            result.height = this.fMinimumHeight;
        }
        return result;
    }

    public int getMinimumHeight() {
        return this.fMinimumHeight;
    }

    public void setMinimumHeight(int aMinimumHeight) {
        this.fMinimumHeight = aMinimumHeight;
    }

    public int getMinimumWidth() {
        return this.fMinimumWidth;
    }

    public void setMinimumWidth(int aMinimumWidth) {
        this.fMinimumWidth = aMinimumWidth;
    }

    public void updateUI() {
        super.updateUI();
        if (!(this.getBorder() instanceof IndicatorBorder.CompoundBorder)) {
            this.fOriginalBorder = this.getBorder();
        }
        this.updateBorder();
    }

    private void updateBorder() {
        if (!StringUtils.noValue(this.getIndicator())) {
            this.setBorder(new IndicatorBorder.CompoundBorder(this.fIndicatorBorder, this.fOriginalBorder));
        } else {
            this.setBorder(this.fOriginalBorder);
        }
    }

    public String getIndicator() {
        return this.getIndicatorBorder().getIndicator();
    }

    public void setIndicator(String aIndicator) {
        if (aIndicator != this.getIndicator()) {
            this.getIndicatorBorder().setIndicator(aIndicator);
            this.updateBorder();
        }
    }

    protected IndicatorBorder getIndicatorBorder() {
        if (this.fIndicatorBorder == null) {
            this.fIndicatorBorder = new IndicatorBorder(null);
        }
        return this.fIndicatorBorder;
    }

    public boolean isReturnEmptyText() {
        return this.fReturnEmptyText;
    }

    public void setReturnEmptyText(boolean aReturnEmptyText) {
        this.fReturnEmptyText = aReturnEmptyText;
    }

    public String getText() {
        String result = super.getText();
        return this.isReturnEmptyText() ? result : (StringUtils.noValue(result) ? null : result);
    }

    public ComponentPainter getComponentPainter() {
        return this.fComponentPainter;
    }

    public void setComponentPainter(ComponentPainter aComponentPainter) {
        if (this.fComponentPainter != aComponentPainter) {
            this.fComponentPainter = aComponentPainter;
            this.repaint();
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.fComponentPainter != null) {
            this.fComponentPainter.paint(g, this);
        }
    }
}

