/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.ComponentFontSupport;
import dev.gui.ComponentPainter;
import dev.gui.ComponentPainterHolder;
import dev.gui.ComponentPainterSupport;
import dev.gui.DelegateListCellRenderer;
import dev.gui.IndicatorHolder;
import dev.gui.JTextFieldEx;
import dev.gui.border.IndicatorBorder;
import dev.util.StringUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class JComboBoxEx
extends JComboBox
implements FocusListener,
IndicatorHolder,
ComponentPainterHolder {
    protected boolean fSelectAllOnFocusGain = true;
    protected IndicatorBorder fIndicatorBorder;
    protected Border fOriginalBorder;
    protected int fMinimumHeight = -1;
    protected int fMinimumWidth = -1;
    protected int fPreferredHeight = -1;
    protected int fPreferredWidth = -1;
    protected ComponentPainterSupport fComponentPainterSupport;
    protected JTextFieldEx.PromptTextComponentPainter fPromptTextComponentPainter;
    protected String fPromptText;
    protected ComponentFontSupport fComponentFontSupport = new ComponentFontSupport(this);
    protected DelegateListCellRenderer fDelegateRenderer;

    public JComboBoxEx(ComboBoxModel aModel) {
        super(aModel);
    }

    public JComboBoxEx(Object[] items) {
        super(items);
    }

    public JComboBoxEx(Vector items) {
        super(items);
    }

    public JComboBoxEx() {
    }

    public void setEditor(ComboBoxEditor anEditor) {
        String promptText = this.getPromptText();
        if (this.getEditor() != null) {
            this.getEditor().getEditorComponent().removeFocusListener(this);
            this.setPromptText(null);
        }
        super.setEditor(anEditor);
        if (this.getEditor() != null) {
            this.getEditor().getEditorComponent().addFocusListener(this);
            if (promptText != null) {
                this.setPromptText(promptText);
            }
        }
    }

    public boolean isSelectAllOnFocusGain() {
        return this.fSelectAllOnFocusGain;
    }

    public void setSelectAllOnFocusGain(boolean aSelectAllOnFocusGain) {
        this.fSelectAllOnFocusGain = aSelectAllOnFocusGain;
    }

    public void focusGained(FocusEvent e) {
        if (this.isSelectAllOnFocusGain()) {
            this.getEditor().selectAll();
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void updateUI() {
        super.updateUI();
        if (!(this.getBorder() instanceof IndicatorBorder.CompoundBorder)) {
            this.fOriginalBorder = this.getBorder();
        }
        this.updateBorder();
        if (this.fDelegateRenderer != null) {
            this.fDelegateRenderer.setDelegate(this.getRenderer());
            this.setRenderer(this.fDelegateRenderer);
        }
    }

    private void updateBorder() {
        if (!StringUtils.noValue(this.getIndicator())) {
            this.setBorder(new IndicatorBorder.CompoundBorder(this.fIndicatorBorder, this.fOriginalBorder));
        } else {
            this.setBorder(this.fOriginalBorder);
        }
    }

    public String getIndicator() {
        return this.getIndicatorBorder().getIndicator();
    }

    public void setIndicator(String aIndicator) {
        if (aIndicator != this.getIndicator()) {
            this.getIndicatorBorder().setIndicator(aIndicator);
            this.updateBorder();
        }
    }

    protected IndicatorBorder getIndicatorBorder() {
        if (this.fIndicatorBorder == null) {
            this.fIndicatorBorder = new IndicatorBorder(null);
        }
        return this.fIndicatorBorder;
    }

    public Dimension getMinimumSize() {
        Dimension result = super.getMinimumSize();
        if (this.fMinimumWidth != -1) {
            result.width = this.fMinimumWidth;
        }
        if (this.fMinimumHeight != -1) {
            result.height = this.fMinimumHeight;
        }
        return result;
    }

    public int getMinimumHeight() {
        return this.fMinimumHeight;
    }

    public void setMinimumHeight(int aMinimumHeight) {
        this.fMinimumHeight = aMinimumHeight;
    }

    public int getMinimumWidth() {
        return this.fMinimumWidth;
    }

    public void setMinimumWidth(int aMinimumWidth) {
        this.fMinimumWidth = aMinimumWidth;
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (this.fPreferredWidth != -1) {
            result.width = this.fPreferredWidth;
        }
        if (this.fPreferredHeight != -1) {
            result.height = this.fPreferredHeight;
        }
        return result;
    }

    public int getPreferredHeight() {
        return this.fPreferredHeight;
    }

    public void setPreferredHeight(int aPreferredHeight) {
        this.fPreferredHeight = aPreferredHeight;
    }

    public int getPreferredWidth() {
        return this.fPreferredWidth;
    }

    public void setPreferredWidth(int aPreferredWidth) {
        this.fPreferredWidth = aPreferredWidth;
    }

    protected ComponentPainterSupport getComponentPainterSupport() {
        if (this.fComponentPainterSupport == null) {
            this.fComponentPainterSupport = new ComponentPainterSupport(this);
        }
        return this.fComponentPainterSupport;
    }

    public void addComponentPainter(ComponentPainter aComponentPainter) {
        this.getComponentPainterSupport().addComponentPainter(aComponentPainter);
    }

    public void removeComponentPainter(ComponentPainter aComponentPainter) {
        this.getComponentPainterSupport().removeComponentPainter(aComponentPainter);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.fComponentPainterSupport != null) {
            this.fComponentPainterSupport.paintComponent(g);
        }
    }

    public String getPromptText() {
        return this.fPromptText;
    }

    public void setPromptText(String aText) {
        if (!StringUtils.noValue(aText)) {
            this.fPromptText = aText;
            if (this.fPromptTextComponentPainter == null) {
                this.fPromptTextComponentPainter = new JTextFieldEx.PromptTextComponentPainter((JTextComponent)this.getEditor().getEditorComponent(), aText, false, 2);
                this.addComponentPainter(this.fPromptTextComponentPainter);
            } else {
                this.fPromptTextComponentPainter.setText(aText);
                if (this.isShowing()) {
                    this.fPromptTextComponentPainter.updateTextVisibility();
                }
            }
        } else if (this.fPromptTextComponentPainter != null) {
            this.removeComponentPainter(this.fPromptTextComponentPainter);
            this.fPromptTextComponentPainter = null;
        }
    }

    public void setFont(Font font) {
        super.setFont(this.fComponentFontSupport != null ? this.fComponentFontSupport.getFont(font) : font);
    }

    public int getFontStyle() {
        return this.fComponentFontSupport.getFontStyle();
    }

    public void setFontStyle(int aFontStyle) {
        this.fComponentFontSupport.setFontStyle(aFontStyle);
    }

    public int getFontIncrement() {
        return this.fComponentFontSupport.getFontIncrement();
    }

    public void setFontIncrement(int aFontIncrement) {
        this.fComponentFontSupport.setFontIncrement(aFontIncrement);
    }

    public float getFontSize() {
        return this.fComponentFontSupport.getFontSize();
    }

    public void setFontSize(float aFontSize) {
        this.fComponentFontSupport.setFontSize(aFontSize);
    }

    public DelegateListCellRenderer getDelegateRenderer() {
        return this.fDelegateRenderer;
    }

    public void setDelegateRenderer(DelegateListCellRenderer aDelegate) {
        if (this.fDelegateRenderer != aDelegate) {
            this.fDelegateRenderer = aDelegate;
            this.fDelegateRenderer.setDelegate(this.getRenderer());
            this.setRenderer(this.fDelegateRenderer);
        }
    }

    public static class DummyKeySelectionManager
    implements JComboBox.KeySelectionManager {
        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            return -1;
        }
    }
}

