/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.beans.beancontext.CustomBeanContextServicesSupport;
import dev.gui.DelayedInvoker;
import dev.gui.FocusHelper;
import dev.gui.OkCancelHelpDialog;
import dev.gui.WaitStateSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextProxy;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.util.Hashtable;
import java.util.TooManyListenersException;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class JCDialog
extends JDialog
implements WindowListener,
BeanContextServiceRevokedListener,
BeanContextProxy {
    public static final int RESULT_NONE = 0;
    public static final int RESULT_OK = 1;
    public static final int RESULT_CANCEL = 2;
    public static final int RESULT_HELP = 3;
    public static final int RESULT_YES = 4;
    public static final int RESULT_NO = 5;
    protected int fModalResult = 0;
    private Dimension fDialogMinimumSize;
    private Dimension fDialogMaximumSize;
    protected boolean fCloseOnEscape = true;
    private ComponentListener fComponentListener = new ComponentAdapter(){

        public void componentResized(ComponentEvent e) {
            JCDialog.this.componentResized(e);
        }

        public void componentShown(ComponentEvent e) {
            if (JCDialog.this.getDefaultFocusOwner() != null) {
                JCDialog.this.getDefaultFocusOwner().requestFocus();
            }
        }
    };
    protected Component fDefaultFocusOwner;
    protected static boolean fInsetContentPane = false;
    protected JComponent fWatermarkComponent;
    protected KeyEventDispatcher fKeyEventDispatcher = new KeyEventDispatcher(){

        public boolean dispatchKeyEvent(KeyEvent e) {
            if (SwingUtilities.getWindowAncestor((Component)e.getSource()) == JCDialog.this) {
                JCDialog.this.onAnyComponentKeyPressed(e);
            }
            return false;
        }
    };
    private boolean fUpdatingSize = false;
    private static Hashtable fUsageHashtable = new Hashtable();
    protected boolean fNeedSoftResizable = "Linux".equalsIgnoreCase(System.getProperty("os.name"));
    protected boolean fSoftResizable = false;
    protected BeanContextServices fBeanContextChild = new CustomBeanContextServicesSupport();
    protected WaitStateSupport fWaitStateSupport = new WaitStateSupport(this);
    private ComponentListener fContentPaneListener = new ComponentAdapter(){

        public void componentResized(ComponentEvent e) {
            if (JCDialog.this.fWatermarkComponent != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Rectangle bounds = JCDialog.this.getContentPane().getBounds();
                        Dimension prefSize = JCDialog.this.fWatermarkComponent.getPreferredSize();
                        JCDialog.this.fWatermarkComponent.setBounds(bounds.x + bounds.width - prefSize.width, bounds.y, prefSize.width, prefSize.height);
                    }
                });
            }
        }
    };

    public JCDialog() {
        this.init();
    }

    public JCDialog(Frame owner) {
        this(owner, null, true);
    }

    public JCDialog(Frame owner, boolean modal) {
        this(owner, null, modal);
    }

    public JCDialog(Frame owner, String title) {
        this(owner, title, true);
    }

    public JCDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public JCDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public JCDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public JCDialog(Dialog owner, String title) {
        super(owner, title);
        this.init();
    }

    public JCDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public Component getDefaultFocusOwner() {
        return this.fDefaultFocusOwner;
    }

    public void setDefaultFocusOwner(Component aDefaultFocusOwner) {
        this.fDefaultFocusOwner = aDefaultFocusOwner;
    }

    public static boolean isInsetContentPane() {
        return fInsetContentPane;
    }

    public static void setInsetContentPane(boolean aValue) {
        fInsetContentPane = aValue;
    }

    private void init() {
        if (fInsetContentPane && this.getContentPane() instanceof JComponent) {
            ((JComponent)this.getContentPane()).setBorder(new EmptyBorder(10, 10, 10, 10));
        }
        this.addWindowListener(this);
        this.getContentPane().addComponentListener(this.fContentPaneListener);
    }

    private void deInit() {
        this.removeWindowListener(this);
    }

    public JComponent getWatermarkComponent() {
        return this.fWatermarkComponent;
    }

    public void setWatermarkComponent(JComponent aComponent) {
        if (this.fWatermarkComponent != null) {
            this.getLayeredPane().remove(this.fWatermarkComponent);
        }
        this.fWatermarkComponent = aComponent;
        if (this.fWatermarkComponent != null) {
            this.getLayeredPane().add((Component)this.fWatermarkComponent, JLayeredPane.DRAG_LAYER);
        }
    }

    public void setVisible(boolean aVisible) {
        if (aVisible) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.fKeyEventDispatcher);
        } else {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.fKeyEventDispatcher);
        }
        if (aVisible) {
            this.addComponentListener(this.fComponentListener);
        } else {
            this.removeComponentListener(this.fComponentListener);
        }
        super.setVisible(aVisible);
    }

    protected boolean hasVisiblePopups() {
        boolean result = false;
        Component[] components = this.getLayeredPane().getComponentsInLayer(JLayeredPane.POPUP_LAYER);
        for (int i = 0; !result && i < components.length; ++i) {
            result = components[i].isVisible();
        }
        return result;
    }

    public boolean isCloseOnEscape(Component aComponent) {
        boolean result = this.isCloseOnEscape();
        if (result) {
            boolean bl = result = !this.hasVisiblePopups();
        }
        if (result && this.getOwnedWindows().length > 0) {
            Window[] windows = this.getOwnedWindows();
            for (int i = 0; i < windows.length; ++i) {
                Window window = windows[i];
                if (!window.isShowing()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean isCloseOnEscape() {
        return this.fCloseOnEscape;
    }

    public void setCloseOnEscape(boolean aCloseOnEscape) {
        this.fCloseOnEscape = aCloseOnEscape;
    }

    public void componentResized(ComponentEvent anEvent) {
        if (anEvent.getSource() != this) {
            return;
        }
        this.updateSizeToFitRange();
    }

    protected void updateSizeToFitRange() {
        Dimension size = this.getSize();
        int newWidth = size.width;
        int newHeight = size.height;
        Dimension minimumSize = this.getDialogMinimumSize();
        Dimension maximumSize = this.getDialogMaximumSize();
        if (minimumSize != null) {
            if (newWidth < minimumSize.width) {
                newWidth = minimumSize.width;
            }
            if (newHeight < minimumSize.height) {
                newHeight = minimumSize.height;
            }
        }
        if (maximumSize != null) {
            if (newWidth > maximumSize.width) {
                newWidth = maximumSize.width;
            }
            if (newHeight > maximumSize.height) {
                newHeight = maximumSize.height;
            }
        }
        if (size.width != newWidth || size.height != newHeight) {
            Dimension newSize = new Dimension(newWidth, newHeight);
            this.setSize(newSize);
        }
    }

    protected Dimension getAdjustedSize(Dimension aSize) {
        int newWidth = aSize.width;
        int newHeight = aSize.height;
        Dimension minimumSize = this.getMinimumSize();
        Dimension maximumSize = this.getMaximumSize();
        if (minimumSize != null) {
            if (newWidth < minimumSize.width) {
                newWidth = minimumSize.width;
            }
            if (newHeight < minimumSize.height) {
                newHeight = minimumSize.height;
            }
        }
        if (maximumSize != null) {
            if (newWidth > maximumSize.width) {
                newWidth = maximumSize.width;
            }
            if (newHeight > maximumSize.height) {
                newHeight = maximumSize.height;
            }
        }
        return new Dimension(newWidth, newHeight);
    }

    public void setDialogMinimumSize(Dimension aValue) {
        this.fDialogMinimumSize = this.getAdjustedSize(aValue);
        this.updateSizeToFitRange();
    }

    public Dimension getDialogMinimumSize() {
        return this.fDialogMinimumSize;
    }

    public void setDialogMaximumSize(Dimension aValue) {
        this.fDialogMaximumSize = this.getAdjustedSize(aValue);
        this.updateSizeToFitRange();
    }

    public Dimension getDialogMaximumSize() {
        return this.fDialogMaximumSize;
    }

    public int getModalResult() {
        return this.fModalResult;
    }

    public void setModalResult(int aModalResult) {
        this.fModalResult = aModalResult;
    }

    public boolean canClose() {
        Component component;
        boolean result = true;
        Container contentPane = this.getContentPane();
        for (int i = 0; i < contentPane.getComponentCount() && (!((component = contentPane.getComponent(i)) instanceof CloseController) || (result = ((CloseController)((Object)component)).canClose())); ++i) {
        }
        return result;
    }

    public void windowOpened(WindowEvent e) {
        this.setModalResult(0);
    }

    public void windowClosing(WindowEvent e) {
        this.doCancel();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void dispose() {
        this.deInit();
        super.dispose();
    }

    public static boolean isInUse(String aClassName) {
        return !JCDialog.canUse(aClassName);
    }

    public static boolean canUse(String aClassName) {
        boolean result = true;
        if (fUsageHashtable.containsKey(aClassName)) {
            result = (Boolean)fUsageHashtable.get(aClassName) == false;
        }
        return result;
    }

    public static void useBegin(String aClassName) {
        fUsageHashtable.put(aClassName, new Boolean(true));
    }

    public static void useEnd(String aClassName) {
        fUsageHashtable.put(aClassName, new Boolean(false));
    }

    public void centerOnScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        Dimension size = this.getSize();
        this.setLocation((screenSize.width - size.width - screenInsets.left - screenInsets.right) / 2, (screenSize.height - size.height - screenInsets.top - screenInsets.bottom) / 2);
    }

    public void centerOnOwner() {
        if (this.getOwner() != null && this.getOwner().isShowing()) {
            Rectangle parentBounds = this.getOwner().getBounds();
            Dimension size = this.getSize();
            GraphicsConfiguration gc = this.getGraphicsConfiguration();
            Rectangle screenBounds = gc == null ? new Rectangle(new Point(), Toolkit.getDefaultToolkit().getScreenSize()) : gc.getBounds();
            Insets screenInsets = gc == null ? new Insets(0, 0, 0, 0) : Toolkit.getDefaultToolkit().getScreenInsets(gc);
            screenBounds.x += screenInsets.left;
            screenBounds.y += screenInsets.top;
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
            int posX = parentBounds.x + parentBounds.width / 2 - size.width / 2;
            if (posX < screenBounds.x) {
                posX = screenBounds.x;
            } else if (posX + size.width > screenBounds.x + screenBounds.width) {
                posX = screenBounds.x + screenBounds.width - size.width;
            }
            int posY = parentBounds.y + parentBounds.height / 2 - size.height / 2;
            if (posY < screenBounds.y) {
                posY = screenBounds.y;
            } else if (posY + size.height > screenBounds.y + screenBounds.height) {
                posY = screenBounds.y + screenBounds.height - size.height;
            }
            this.setLocation(posX, posY);
        } else {
            this.centerOnScreen();
        }
    }

    public boolean isSoftResizable() {
        return this.fSoftResizable && this.fNeedSoftResizable;
    }

    public void setResizable(boolean aResizable) {
        boolean bl = this.fSoftResizable = !aResizable;
        if (aResizable || !this.isSoftResizable()) {
            super.setResizable(aResizable);
        }
    }

    protected void onAnyComponentKeyPressed(KeyEvent e) {
        boolean canCloseOnEscape;
        if (!e.isConsumed() && e.getID() == 401 && e.getKeyCode() == 27 && (canCloseOnEscape = this.isCloseOnEscape((Component)e.getSource()))) {
            this.doCancel();
        }
    }

    public void pack() {
        super.pack();
        if (this.isSoftResizable()) {
            this.fDialogMinimumSize = this.fDialogMaximumSize = this.getAdjustedSize(this.getPreferredSize());
        }
    }

    public static Dialog getParentDialog(Component aComponent) {
        Dialog result = null;
        for (Component parent = aComponent; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Dialog)) continue;
            result = (Dialog)parent;
            break;
        }
        return result;
    }

    public static Frame getParentFrame(Component aComponent) {
        Frame result = null;
        for (Component parent = aComponent; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Frame)) continue;
            result = (Frame)parent;
            break;
        }
        return result;
    }

    public void setDefaultButton(JButton aButton) {
        if (aButton != null) {
            aButton.setDefaultCapable(true);
            this.getRootPane().setDefaultButton(aButton);
            new JTextField().getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            for (InputMap inputMap = new JFormattedTextField().getInputMap(0); inputMap != null; inputMap = inputMap.getParent()) {
                inputMap.remove(keyStroke);
                if (inputMap.get(keyStroke) == null) break;
            }
        }
    }

    public static int executeModal(Component owner, String title, JComponent aContentPane) {
        return JCDialog.executeModal(JOptionPane.getFrameForComponent(owner), title, aContentPane);
    }

    public static int executeModal(Frame owner, String title, JComponent aContentPane) {
        return JCDialog.executeModal(new JCDialog(owner, title, true), aContentPane);
    }

    public static int executeModal(JCDialog dialog, JComponent aContentPane) {
        int result = 0;
        try {
            FocusHelper fl = null;
            if (aContentPane != null) {
                dialog.getContentPane().add((Component)aContentPane, "Center");
                fl = new FocusHelper(aContentPane);
                dialog.addComponentListener(fl);
            } else {
                fl = new FocusHelper(dialog.getContentPane());
                dialog.addComponentListener(fl);
            }
            dialog.pack();
            dialog.centerOnOwner();
            dialog.setVisible(true);
            result = dialog.getModalResult();
            if (aContentPane != null) {
                dialog.getContentPane().remove(aContentPane);
            }
            dialog.removeComponentListener(fl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void initBeanContext(Component anOwner) {
        try {
            BeanContextChild child;
            if (anOwner instanceof BeanContextProxy && (child = ((BeanContextProxy)((Object)anOwner)).getBeanContextProxy()) instanceof BeanContext) {
                this.setBeanContext((BeanContext)child);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BeanContext getBeanContext() {
        return this.fBeanContextChild.getBeanContext();
    }

    public void setBeanContext(BeanContext bc) throws PropertyVetoException {
        this.fBeanContextChild.setBeanContext(bc);
    }

    public BeanContextChild getBeanContextProxy() {
        return this.fBeanContextChild;
    }

    public Object getService(Class aServiceClass, Object aServiceSelector) {
        try {
            return this.fBeanContextChild.getService(this.fBeanContextChild, this, aServiceClass, aServiceSelector, this);
        }
        catch (TooManyListenersException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Object getService(Class aServiceClass) {
        return this.getService(aServiceClass, null);
    }

    public void releaseService(Object aService) {
        this.fBeanContextChild.releaseService(this.fBeanContextChild, this, aService);
    }

    public void serviceRevoked(BeanContextServiceRevokedEvent bcsre) {
        System.err.println("Service revoked: " + bcsre.getServiceClass());
    }

    public boolean isWaitState() {
        return this.fWaitStateSupport.isWaitState();
    }

    public void setWaitState(boolean aWaitState) {
        this.fWaitStateSupport.setWaitState(aWaitState);
    }

    public static int prompt(Component aComponent, String aMessage) {
        String messageTitle = JCDialog.getMessageTitle(aComponent);
        return JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(aComponent), aMessage, messageTitle != null ? messageTitle : "Question", 0, 3);
    }

    public static void error(Component aComponent, String aMessage) {
        String messageTitle = JCDialog.getMessageTitle(aComponent);
        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(aComponent), aMessage, messageTitle != null ? messageTitle : "Error", 0);
    }

    public static void warning(Component aComponent, String aMessage) {
        String messageTitle = JCDialog.getMessageTitle(aComponent);
        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(aComponent), aMessage, messageTitle != null ? messageTitle : "Warning", 2);
    }

    public static void message(Component aComponent, String aMessage) {
        String messageTitle = JCDialog.getMessageTitle(aComponent);
        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(aComponent), aMessage, messageTitle != null ? messageTitle : "Message", 1);
    }

    private static String getMessageTitleInt(Component aComponent) {
        if (aComponent instanceof Dialog) {
            return ((Dialog)aComponent).getTitle();
        }
        if (aComponent instanceof Frame) {
            return ((Frame)aComponent).getTitle();
        }
        return null;
    }

    public static String getMessageTitle(Component aComponent) {
        String result = JCDialog.getMessageTitleInt(aComponent);
        if (result == null && aComponent != null) {
            result = JCDialog.getMessageTitleInt(SwingUtilities.getWindowAncestor(aComponent));
        }
        return result;
    }

    protected void doCancel() {
        if (this.canCancel()) {
            this.setModalResult(2);
            this.setVisible(false);
        }
    }

    public boolean canCancel() {
        return true;
    }

    public static void main(String[] args) {
        OkCancelHelpDialog dialog = new OkCancelHelpDialog();
        WatermarkComponent w = new WatermarkComponent();
        w.setForeground(Color.WHITE);
        w.setBackground(Color.RED);
        w.setText("Not for\ndeployment");
        dialog.setWatermarkComponent(w);
        dialog.setModal(true);
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(300, 300));
        dialog.setDialogMinimumSize(new Dimension(200, 200));
        JCDialog.executeModal(dialog, panel);
        System.exit(0);
    }

    public static class TemporaryComponentHighlighter
    extends JComponent
    implements ActionListener {
        protected JComponent[] fHighlightComponents;
        protected DelayedInvoker fDelayedInvoker = new DelayedInvoker(250, this);
        protected boolean fStarted = false;
        protected int fCurrentIndex = 0;

        public TemporaryComponentHighlighter(JComponent aHighlightComponent) {
            this(new JComponent[]{aHighlightComponent});
        }

        public TemporaryComponentHighlighter(JComponent[] aHighlightComponents) {
            this.fHighlightComponents = aHighlightComponents;
            this.setBorder(new LineBorder(Color.YELLOW));
            this.setFocusable(false);
            this.setEnabled(false);
        }

        public boolean isOpaque() {
            return false;
        }

        public Rectangle getHighlightComponentsBounds() {
            Rectangle result = new Rectangle(this.fHighlightComponents[0].getBounds());
            for (int i = 1; i < this.fHighlightComponents.length; ++i) {
                result.add(this.fHighlightComponents[i].getBounds());
            }
            if (this.fHighlightComponents.length > 1) {
                result.grow(2, 2);
            }
            return result;
        }

        public void highlight() {
            this.start();
        }

        public boolean isStarted() {
            return this.fStarted;
        }

        public void start() {
            if (!this.fStarted) {
                this.fStarted = true;
                RootPaneContainer root = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this.fHighlightComponents[0]));
                if (root != null) {
                    this.setBounds(SwingUtilities.convertRectangle(this.fHighlightComponents[0].getParent(), this.getHighlightComponentsBounds(), root.getLayeredPane()));
                    root.getLayeredPane().add((Component)this, JLayeredPane.POPUP_LAYER);
                    this.fDelayedInvoker.start();
                }
            }
        }

        public void stop() {
            if (this.fStarted) {
                this.fDelayedInvoker.stop();
                RootPaneContainer root = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this.fHighlightComponents[0]));
                root.getLayeredPane().remove(this);
                root.getLayeredPane().repaint(this.getBounds());
                this.fCurrentIndex = 0;
                this.fStarted = false;
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.fCurrentIndex < 10) {
                if (this.fCurrentIndex++ % 2 == 0) {
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                }
                this.fDelayedInvoker.start();
            } else {
                this.stop();
            }
        }
    }

    public static class WatermarkComponent
    extends JComponent {
        public static final Dimension PREF_SIZE = new Dimension(96, 96);
        Dimension fBoundingSize;
        public static final int GAP_X = 4;
        public static final int GAP_Y = 4;
        protected String[] fTextLines;
        protected String fText;

        public WatermarkComponent() {
            this.setForeground(Color.WHITE);
            this.setBackground(Color.RED);
        }

        public WatermarkComponent(String aText) {
            this();
            this.setText(aText);
        }

        public Dimension getPreferredSize() {
            this.fBoundingSize = new Dimension();
            if (this.fTextLines != null) {
                Font f = this.getFont();
                FontRenderContext fontCtx = ((Graphics2D)this.getGraphics()).getFontRenderContext();
                for (int i = 0; i < this.fTextLines.length; ++i) {
                    Rectangle2D r = f.getStringBounds(this.fTextLines[i], fontCtx);
                    this.fBoundingSize.height = (int)((double)this.fBoundingSize.height + r.getHeight());
                    this.fBoundingSize.width = Math.max(this.fBoundingSize.width, (int)r.getWidth());
                    if (i <= 0) continue;
                    this.fBoundingSize.height += 4;
                }
                this.fBoundingSize.height += 8;
                this.fBoundingSize.width += 8;
            }
            int size = this.fTextLines != null ? (int)Math.sqrt(this.fBoundingSize.width * this.fBoundingSize.width / 2) + (int)Math.sqrt(2 * this.fBoundingSize.height * this.fBoundingSize.height) : 0;
            return new Dimension(size, size);
        }

        public String getText() {
            return this.fText;
        }

        public void setText(String aText) {
            this.fText = aText;
            this.fTextLines = this.fText != null ? this.fText.split("\n") : null;
        }

        protected void paintComponent(Graphics g) {
            if (this.fTextLines != null) {
                int w = this.getWidth();
                int h = this.getHeight();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                AffineTransform transform = g2d.getTransform();
                int shift = (int)Math.sqrt(2 * this.fBoundingSize.height * this.fBoundingSize.height);
                g.setColor(this.getForeground());
                g2d.translate(shift, 0);
                g2d.transform(AffineTransform.getRotateInstance(Math.toRadians(45.0)));
                Font f = this.getFont();
                FontRenderContext fontCtx = ((Graphics2D)this.getGraphics()).getFontRenderContext();
                Color backColor = this.getBackground();
                g2d.setPaint(new GradientPaint(-this.fBoundingSize.height, 0.0f, new Color(backColor.getRed(), backColor.getGreen(), backColor.getBlue(), 16), w / 2, 0.0f, new Color(backColor.getRed(), backColor.getGreen(), backColor.getBlue(), 92), true));
                g2d.fillRect(-this.fBoundingSize.height, 0, w + this.fBoundingSize.height + 10, this.fBoundingSize.height);
                g.setColor(this.getForeground());
                int y = 4;
                for (int i = 0; i < this.fTextLines.length; ++i) {
                    Rectangle2D r = f.getStringBounds(this.fTextLines[i], fontCtx);
                    LineMetrics m = f.getLineMetrics(this.fTextLines[i], fontCtx);
                    g.drawString(this.fTextLines[i], (int)(((double)this.fBoundingSize.width - r.getWidth()) / 2.0), y + (int)m.getAscent());
                    y = (int)((double)y + (4.0 + r.getHeight()));
                }
            }
        }
    }

    public static interface CloseController {
        public boolean canClose();
    }
}

