/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.util.StringUtils;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.HTML;

public class HyperlinkSupport
extends MouseAdapter
implements MouseMotionListener {
    protected String fCurrentHref;
    protected Cursor fSavedCursor;
    private static Position.Bias[] fSharedBiasReturn = new Position.Bias[]{Position.Bias.Forward};
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    protected String fHREFDescription;
    private transient Vector fHyperlinkListeners;

    public HyperlinkSupport() {
        this(null, null);
    }

    public HyperlinkSupport(JComponent aComponent) {
        this(aComponent, null);
    }

    public HyperlinkSupport(JComponent aComponent, HyperlinkListener aHyperlinkListener) {
        if (aComponent != null) {
            aComponent.addMouseListener(this);
            aComponent.addMouseMotionListener(this);
        }
        if (aHyperlinkListener != null) {
            this.addHyperlinkListener(aHyperlinkListener);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.setCurrentHref((JComponent)e.getSource(), this.getHref(e));
    }

    protected boolean isHandCursor(JComponent aComponent) {
        return aComponent.getCursor() == Cursor.getPredefinedCursor(12);
    }

    public void mouseClicked(MouseEvent e) {
        if (this.fCurrentHref != null && ((JComponent)e.getSource()).isEnabled()) {
            this.activateHref((JComponent)e.getSource());
        }
    }

    public void mouseExited(MouseEvent e) {
        this.setCurrentHref((JComponent)e.getSource(), null);
    }

    public String getCurrentHref() {
        return this.fCurrentHref;
    }

    public void setCurrentHref(JComponent aComponent, String aCurrentHref) {
        if (!StringUtils.equals(this.fCurrentHref, aCurrentHref)) {
            if (this.fCurrentHref != null) {
                this.leaveHref(aComponent);
            }
            this.fCurrentHref = aCurrentHref;
            if (this.fCurrentHref != null) {
                this.enterHref(aComponent);
            }
            this.setHandCursor(aComponent, this.fCurrentHref != null);
        }
    }

    protected HyperlinkEvent createHyperlinkEvent(JComponent aComponent, HyperlinkEvent.EventType anEventType) {
        URL url = null;
        try {
            url = new URL(this.fCurrentHref);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return new HyperlinkEvent(aComponent, anEventType, url, this.fHREFDescription != null ? this.fHREFDescription : this.fCurrentHref);
    }

    protected void enterHref(JComponent aComponent) {
        this.fireHyperlinkUpdate(this.createHyperlinkEvent(aComponent, HyperlinkEvent.EventType.ENTERED));
    }

    protected void leaveHref(JComponent aComponent) {
        this.fireHyperlinkUpdate(this.createHyperlinkEvent(aComponent, HyperlinkEvent.EventType.EXITED));
    }

    protected void activateHref(JComponent aComponent) {
        this.fireHyperlinkUpdate(this.createHyperlinkEvent(aComponent, HyperlinkEvent.EventType.ACTIVATED));
        this.setCurrentHref(aComponent, null);
    }

    protected void setHandCursor(JComponent aComponent, boolean isSet) {
        if (this.isHandCursor(aComponent) != isSet) {
            if (isSet) {
                this.fSavedCursor = aComponent.getCursor();
                aComponent.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                aComponent.setCursor(this.fSavedCursor);
            }
        }
    }

    protected Rectangle getPaintTextRect(JComponent aComponent) {
        if (aComponent instanceof JLabel) {
            JLabel label = (JLabel)aComponent;
            FontMetrics fm = label.getGraphics().getFontMetrics();
            Insets insets = label.getInsets(paintViewInsets);
            HyperlinkSupport.paintViewR.x = insets.left;
            HyperlinkSupport.paintViewR.y = insets.top;
            HyperlinkSupport.paintViewR.width = label.getWidth() - (insets.left + insets.right);
            HyperlinkSupport.paintViewR.height = label.getHeight() - (insets.top + insets.bottom);
            HyperlinkSupport.paintIconR.height = 0;
            HyperlinkSupport.paintIconR.width = 0;
            HyperlinkSupport.paintIconR.y = 0;
            HyperlinkSupport.paintIconR.x = 0;
            HyperlinkSupport.paintTextR.height = 0;
            HyperlinkSupport.paintTextR.width = 0;
            HyperlinkSupport.paintTextR.y = 0;
            HyperlinkSupport.paintTextR.x = 0;
            this.layoutCL(label, fm, label.getText(), label.getIcon(), paintViewR, paintIconR, paintTextR);
            return paintTextR;
        }
        Insets insets = aComponent.getInsets();
        Rectangle bounds = aComponent.getBounds();
        Rectangle result = new Rectangle(bounds.x + insets.left, bounds.y + insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
        return result;
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
    }

    protected String getHref(MouseEvent event) {
        Document d;
        String result = null;
        View view = (View)((JLabel)event.getSource()).getClientProperty("html");
        if (view != null && (d = view.getDocument()) != null) {
            Element element;
            JComponent component = (JComponent)event.getSource();
            int index = view.viewToModel(event.getX(), event.getY(), this.getPaintTextRect(component), fSharedBiasReturn);
            ElementIterator elements = new ElementIterator(d);
            while ((element = elements.next()) != null) {
                if (element == null || !element.isLeaf() || element.getStartOffset() > index || index >= element.getEndOffset()) continue;
                AttributeSet as = element.getAttributes();
                AttributeSet anchor = (AttributeSet)as.getAttribute(HTML.Tag.A);
                if (anchor != null) {
                    result = (String)anchor.getAttribute(HTML.Attribute.HREF);
                    if (result != null) {
                        this.fHREFDescription = (String)anchor.getAttribute(HTML.Attribute.ALT);
                        break;
                    }
                    this.fHREFDescription = null;
                    break;
                }
                result = null;
                break;
            }
        }
        return result;
    }

    public synchronized void removeHyperlinkListener(HyperlinkListener l) {
        if (this.fHyperlinkListeners != null && this.fHyperlinkListeners.contains(l)) {
            Vector v = (Vector)this.fHyperlinkListeners.clone();
            v.removeElement(l);
            this.fHyperlinkListeners = v;
        }
    }

    public synchronized void addHyperlinkListener(HyperlinkListener l) {
        Vector v;
        Vector vector = v = this.fHyperlinkListeners == null ? new Vector(2) : (Vector)this.fHyperlinkListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fHyperlinkListeners = v;
        }
    }

    protected void fireHyperlinkUpdate(HyperlinkEvent e) {
        if (this.fHyperlinkListeners != null) {
            Vector listeners = this.fHyperlinkListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((HyperlinkListener)listeners.elementAt(i)).hyperlinkUpdate(e);
            }
        }
    }
}

