/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.DelayedInvoker;
import dev.gui.ExternalBrowser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicLabelUI;

public class HyperlinkLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    public static int HIDE_TIMEOUT = 7000;
    private DelayedInvoker fDelayedInvoker = new DelayedInvoker(HIDE_TIMEOUT, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            HyperlinkLabel.this.onMouseExited();
        }
    });
    private boolean fMouseIn = false;
    private Cursor fSavedCursor = null;
    private Color fSavedForeground = null;
    protected boolean fCallBrowser = true;
    private static HyperlinkLabelUI fHyperlinkLabelUI = new HyperlinkLabelUI();
    private String fHyperlinkURL = null;
    private Color fHyperlinkColor = null;
    protected boolean fExpireRollover = true;
    private transient Vector fHyperlinkListeners;

    public HyperlinkLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.initListeners();
    }

    public HyperlinkLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.initListeners();
    }

    public HyperlinkLabel(String text) {
        super(text);
        this.initListeners();
    }

    public HyperlinkLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.initListeners();
    }

    public HyperlinkLabel(Icon image) {
        super(image);
        this.initListeners();
    }

    public HyperlinkLabel() {
        this.initListeners();
    }

    private void initListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.fMouseIn = false;
    }

    public boolean isMouseIn() {
        return this.fMouseIn;
    }

    public void setMouseIn(boolean aMouseIn) {
        if (this.fMouseIn != aMouseIn) {
            this.fMouseIn = aMouseIn;
            if (this.fHyperlinkColor != null) {
                if (this.fMouseIn) {
                    this.fSavedForeground = this.getForeground();
                    this.setForeground(this.fHyperlinkColor);
                } else {
                    this.setForeground(this.fSavedForeground);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.onMouseEntered();
    }

    public void onMouseEntered() {
        if (!this.fMouseIn) {
            if (this.isExpireRollover()) {
                this.fDelayedInvoker.takeUp();
            }
            this.fMouseIn = true;
            this.fSavedCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(12));
            if (this.fHyperlinkColor != null) {
                this.fSavedForeground = this.getForeground();
                this.setForeground(this.fHyperlinkColor);
            }
            this.repaint();
            this.fireHyperlinkUpdate(HyperlinkEvent.EventType.ENTERED);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.onMouseExited();
    }

    public void onMouseExited() {
        if (this.fMouseIn) {
            if (this.isExpireRollover()) {
                this.fDelayedInvoker.stop();
            }
            this.fMouseIn = false;
            this.setCursor(this.fSavedCursor);
            if (this.fHyperlinkColor != null) {
                this.setForeground(this.fSavedForeground);
            }
            this.repaint();
            this.fireHyperlinkUpdate(HyperlinkEvent.EventType.EXITED);
        }
    }

    public boolean isCallBrowser() {
        return this.fCallBrowser;
    }

    public void setCallBrowser(boolean aCallBrowser) {
        this.fCallBrowser = aCallBrowser;
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.onMouseExited();
        if (this.fHyperlinkURL != null && this.fCallBrowser) {
            ExternalBrowser.callBrowser(this.fHyperlinkURL, (Component)this);
        }
        this.fireHyperlinkUpdate(HyperlinkEvent.EventType.ACTIVATED);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void updateUI() {
        this.setUI(fHyperlinkLabelUI);
    }

    public Color getHyperlinkColor() {
        return this.fHyperlinkColor != null ? this.fHyperlinkColor : this.getForeground();
    }

    public void setHyperlinkColor(Color hyperlinkColor) {
        this.fHyperlinkColor = hyperlinkColor;
    }

    public String getHyperlinkURL() {
        return this.fHyperlinkURL;
    }

    public void setHyperlinkURL(String aHyperlinkURL) {
        this.fHyperlinkURL = aHyperlinkURL;
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.fMouseIn) {
            this.onMouseEntered();
        } else if (this.isExpireRollover()) {
            this.fDelayedInvoker.takeUp();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.onMouseExited();
        }
    }

    public boolean isExpireRollover() {
        return this.fExpireRollover;
    }

    public void setExpireRollover(boolean aExpireRollover) {
        this.fExpireRollover = aExpireRollover;
    }

    public synchronized void removeHyperlinkListener(HyperlinkListener l) {
        if (this.fHyperlinkListeners != null && this.fHyperlinkListeners.contains(l)) {
            Vector v = (Vector)this.fHyperlinkListeners.clone();
            v.removeElement(l);
            this.fHyperlinkListeners = v;
        }
    }

    public synchronized void addHyperlinkListener(HyperlinkListener l) {
        Vector v;
        Vector vector = v = this.fHyperlinkListeners == null ? new Vector(2) : (Vector)this.fHyperlinkListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fHyperlinkListeners = v;
        }
    }

    protected void fireHyperlinkUpdate(HyperlinkEvent.EventType anEventType) {
        try {
            HyperlinkEvent e = new HyperlinkEvent(this, anEventType, new URL(this.fHyperlinkURL == null ? "http://" : this.fHyperlinkURL), this.getToolTipText());
            if (this.fHyperlinkListeners != null) {
                Vector listeners = this.fHyperlinkListeners;
                int count = listeners.size();
                for (int i = 0; i < count; ++i) {
                    ((HyperlinkListener)listeners.elementAt(i)).hyperlinkUpdate(e);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static class HyperlinkLabelUI
    extends BasicLabelUI {
        public static final int UNDERLINE_OFFSET = 2;
        private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
        private static Rectangle paintViewR = new Rectangle();
        private static Rectangle paintIconR = new Rectangle();
        private static Rectangle paintTextR = new Rectangle();

        HyperlinkLabelUI() {
        }

        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            HyperlinkLabel label = (HyperlinkLabel)c;
            String text = label.getText();
            if (!label.isMouseIn() || text == null || c.getClientProperty("html") != null) {
                return;
            }
            Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            FontMetrics fm = g.getFontMetrics();
            paintViewInsets = c.getInsets(paintViewInsets);
            HyperlinkLabelUI.paintViewR.x = HyperlinkLabelUI.paintViewInsets.left;
            HyperlinkLabelUI.paintViewR.y = HyperlinkLabelUI.paintViewInsets.top;
            HyperlinkLabelUI.paintViewR.width = c.getWidth() - (HyperlinkLabelUI.paintViewInsets.left + HyperlinkLabelUI.paintViewInsets.right);
            HyperlinkLabelUI.paintViewR.height = c.getHeight() - (HyperlinkLabelUI.paintViewInsets.top + HyperlinkLabelUI.paintViewInsets.bottom);
            HyperlinkLabelUI.paintIconR.height = 0;
            HyperlinkLabelUI.paintIconR.width = 0;
            HyperlinkLabelUI.paintIconR.y = 0;
            HyperlinkLabelUI.paintIconR.x = 0;
            HyperlinkLabelUI.paintTextR.height = 0;
            HyperlinkLabelUI.paintTextR.width = 0;
            HyperlinkLabelUI.paintTextR.y = 0;
            HyperlinkLabelUI.paintTextR.x = 0;
            this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
            int textX = HyperlinkLabelUI.paintTextR.x;
            int textY = HyperlinkLabelUI.paintTextR.y + fm.getAscent();
            g.setColor(label.getHyperlinkColor());
            g.drawLine(textX, textY + 2, textX + HyperlinkLabelUI.paintTextR.width, textY + 2);
        }
    }
}

