/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.UIUtils;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    protected Color fStartColor;

    public GradientPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public GradientPanel(LayoutManager layout) {
        super(layout);
    }

    public GradientPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public GradientPanel() {
    }

    public Color getStartColor() {
        return this.fStartColor;
    }

    public void setStartColor(Color aStartColor) {
        this.fStartColor = aStartColor;
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Paint paint = g2d.getPaint();
        Rectangle r = this.getBounds();
        Color endColor = this.getBackground();
        Color startColor = this.fStartColor != null ? this.fStartColor : UIUtils.getDarker(endColor, 0.9f);
        g2d.setPaint(new GradientPaint(0.0f, r.height / 2, this.getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT ? startColor : endColor, r.width, r.height / 2, this.getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT ? endColor : startColor));
        g2d.fill(new Rectangle(0, 1, r.width - 2, r.height - 2));
        g2d.setPaint(paint);
        super.paint(g);
    }
}

