/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;

public class GenericFileFilter
extends FileFilter
implements Cloneable,
Serializable,
FilenameFilter {
    public static final long serialVersionUID = 1L;
    public static final String FILE_EXTENSIONS_DELIMITER = ";";
    public static final String FILE_DESCRIPTION_START_BRACKET = "(";
    protected HashSet fAcceptableExtensions = new HashSet();
    protected String fDescription;
    public static final FileFilter FILE_FILTER_IMAGES = new GenericFileFilter("Image files", new String[]{"jpeg, jpg, gif, png"});
    public static final FileFilter FILE_FILTER_AUDIO = new GenericFileFilter("Audio files", new String[]{"wav", "au", "aiff", "rmf", "mid"});
    public static final FileFilter FILE_FILTER_HTML = new GenericFileFilter("HTML files", new String[]{"html", "htm"});
    public static final FileFilter FILE_FILTER_XML = new GenericFileFilter("XML files", new String[]{"xml"});
    public static final FileFilter FILE_FILTER_TEXT = new GenericFileFilter("Text files", new String[]{"txt"});

    public GenericFileFilter(String aDescription, String[] aExtensions) {
        this.setAcceptableExtensions(aExtensions);
        this.setDescription(aDescription);
    }

    public GenericFileFilter(String aDescription, String aExtensions) {
        this.setAcceptableExtensions(aExtensions);
        this.setDescription(aDescription);
    }

    public String getDescription() {
        return this.fDescription;
    }

    protected void setDescription(String aDescription) {
        if (aDescription != null) {
            StringBuffer sBuffer = new StringBuffer(aDescription);
            if (!this.fAcceptableExtensions.isEmpty()) {
                sBuffer.append(" (");
                Iterator extIterator = this.fAcceptableExtensions.iterator();
                while (extIterator.hasNext()) {
                    sBuffer.append("*.").append(extIterator.next());
                    if (!extIterator.hasNext()) continue;
                    sBuffer.append("; ");
                }
                sBuffer.append(")");
            }
            this.fDescription = sBuffer.toString();
        }
    }

    public String[] getAcceptableExtensions() {
        int cnt = 0;
        String[] result = new String[this.fAcceptableExtensions.size()];
        Iterator iter = this.fAcceptableExtensions.iterator();
        while (iter.hasNext()) {
            result[cnt++] = (String)iter.next();
        }
        return result;
    }

    protected void setAcceptableExtensions(String[] aAcceptableExtensions) {
        if (aAcceptableExtensions != null) {
            for (int i = 0; i < aAcceptableExtensions.length; ++i) {
                this.fAcceptableExtensions.add(aAcceptableExtensions[i].toLowerCase().trim());
            }
        }
    }

    protected void setAcceptableExtensions(String aAcceptableExtensions) {
        if (aAcceptableExtensions != null) {
            this.setAcceptableExtensions(aAcceptableExtensions.split(FILE_EXTENSIONS_DELIMITER));
        }
    }

    protected static final String getFileExtension(File aFile) {
        String fileName = aFile.getName();
        int ind = fileName.lastIndexOf(46);
        if (ind >= 0) {
            return fileName.substring(ind + 1, fileName.length()).toLowerCase();
        }
        return null;
    }

    public boolean accept(File aFile) {
        if (aFile.isDirectory()) {
            return true;
        }
        String fileExt = GenericFileFilter.getFileExtension(aFile);
        if (fileExt != null) {
            return this.fAcceptableExtensions.contains(fileExt);
        }
        return false;
    }

    public boolean accept(File dir, String name) {
        return this.accept(new File(dir, name));
    }

    public Object clone() {
        try {
            GenericFileFilter result = (GenericFileFilter)super.clone();
            result.fAcceptableExtensions = new HashSet(this.fAcceptableExtensions);
            return result;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }
}

