/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class FlowLayoutEx
extends FlowLayout {
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    protected boolean fRetainComponentsWidth = false;
    protected boolean fCountContainerWidth = false;
    public static final int VALIGN_TOP = 0;
    public static final int VALIGN_CENTER = 1;
    public static final int VALIGN_BOTTOM = 2;
    int fOrientation = 0;
    int fVerticalAlign = 1;

    public FlowLayoutEx() {
    }

    public FlowLayoutEx(int align) {
        super(align);
    }

    public FlowLayoutEx(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            if (this.getOrientation() == 0) {
                this.layoutHorizontally(container);
            } else {
                this.layoutVertically(container);
            }
        }
    }

    private void layoutHorizontally(Container container) {
        Insets insets = container.getInsets();
        int hg = this.getHgap();
        int vg = this.getVgap();
        int maxwidth = container.getWidth() - (insets.left + insets.right + hg * 2);
        int nmembers = container.getComponentCount();
        int x = 0;
        int y = insets.top + vg;
        int rowh = 0;
        int start = 0;
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        for (int i = 0; i < nmembers; ++i) {
            Component m = container.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            m.setSize(d.width, d.height);
            if (x == 0 || x + d.width <= maxwidth) {
                if (x > 0) {
                    x += hg;
                }
                x += d.width;
                rowh = Math.max(rowh, d.height);
                continue;
            }
            this.moveComponentsHorizontally(container, insets.left + hg, y, maxwidth - x, rowh, start, i, ltr);
            x = d.width;
            y += vg + rowh;
            rowh = d.height;
            start = i;
        }
        this.moveComponentsHorizontally(container, insets.left + hg, y, maxwidth - x, rowh, start, nmembers, ltr);
    }

    private void moveComponentsHorizontally(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        switch (this.getAlignment()) {
            case 0: {
                x += ltr ? 0 : width;
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += ltr ? width : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                x += width;
            }
        }
        int hg = this.getHgap();
        for (int i = rowStart; i < rowEnd; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            int yOffs = 0;
            switch (this.fVerticalAlign) {
                case 0: {
                    yOffs = y;
                    break;
                }
                case 2: {
                    yOffs = y + (height - m.getHeight());
                    break;
                }
                default: {
                    yOffs = y + (height - m.getHeight()) / 2;
                }
            }
            if (ltr) {
                m.setLocation(x, yOffs);
            } else {
                m.setLocation(target.getWidth() - x - m.getWidth(), yOffs);
            }
            x += m.getWidth() + hg;
        }
    }

    public boolean isRetainComponentsWidth() {
        return this.fRetainComponentsWidth;
    }

    public void setRetainComponentsWidth(boolean aValue) {
        this.fRetainComponentsWidth = aValue;
    }

    protected void layoutVertically(Container container) {
        Insets insets = container.getInsets();
        Dimension size = container.getSize();
        int w = container.getWidth() - insets.left - insets.right;
        int vg = this.getVgap();
        int hg = this.getHgap();
        int currentH = 0;
        int currentW = 0;
        int h = size.height - (insets.top + insets.bottom + vg * 2);
        int x = insets.left + hg;
        int current = 0;
        int count = container.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension prefSize = component.getPreferredSize();
            component.setSize(this.isRetainComponentsWidth() ? w : prefSize.width, prefSize.height);
            if (currentH == 0 || currentH + prefSize.height <= h) {
                if (currentH > 0) {
                    currentH += vg;
                }
                currentH += prefSize.height;
                currentW = Math.max(currentW, prefSize.width);
                continue;
            }
            this.moveComponentsVertically(container, x, insets.top + vg, currentW, h - currentH, current, i);
            x += hg + currentW;
            currentH = prefSize.width;
            currentW = prefSize.width;
            current = i;
        }
        this.moveComponentsVertically(container, x, insets.top + vg, currentW, h - currentH, current, count);
        this.layoutHorizontally(container, insets.left + this.getHgap(), currentW);
    }

    private void layoutHorizontally(Container container, int x, int width) {
        int count = container.getComponentCount();
        block4: for (int i = 0; i < count; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension size = component.getSize();
            switch (this.getAlignment()) {
                case 0: {
                    component.setLocation(x, component.getY());
                    continue block4;
                }
                case 2: {
                    component.setLocation(width - this.getHgap(), component.getY());
                }
            }
        }
    }

    private void moveComponentsVertically(Container container, int i, int j, int k, int l, int i1, int j1) {
        switch (this.fVerticalAlign) {
            case 1: {
                j += l / 2;
                break;
            }
            case 2: {
                j += l;
            }
        }
        int vg = this.getVgap();
        for (int k1 = i1; k1 < j1; ++k1) {
            Component component = container.getComponent(k1);
            Dimension dimension = component.getSize();
            if (!component.isVisible()) continue;
            component.setLocation(i + (k - dimension.width) / 2, j);
            j += vg + dimension.height;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension result;
        if (this.getOrientation() == 0) {
            result = super.minimumLayoutSize(container);
        } else {
            int vg = this.getVgap();
            int hg = this.getHgap();
            result = new Dimension(0, 0);
            Insets insets = container.getInsets();
            int count = container.getComponentCount();
            for (int j = 0; j < count; ++j) {
                Component component = container.getComponent(j);
                if (!component.isVisible()) continue;
                Dimension minSize = component.getMinimumSize();
                result.width = Math.max(result.width, minSize.width);
                if (j > 0) {
                    result.height += vg;
                }
                result.height += minSize.height;
            }
            result.width += insets.left + insets.right + hg * 2;
            result.height += insets.top + insets.bottom + vg * 2;
        }
        return result;
    }

    public boolean isCountContainerWidth() {
        return this.fCountContainerWidth;
    }

    public void setCountContainerWidth(boolean aValue) {
        this.fCountContainerWidth = aValue;
    }

    protected int preferredLayoutHeight(Container container) {
        Insets insets = container.getInsets();
        int hg = this.getHgap();
        int vg = this.getVgap();
        int maxwidth = container.getWidth() - (insets.left + insets.right + hg * 2);
        int nmembers = container.getComponentCount();
        int x = 0;
        int y = insets.top + vg;
        int rowh = 0;
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        for (int i = 0; i < nmembers; ++i) {
            Component m = container.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            m.setSize(d.width, d.height);
            if (x == 0 || x + d.width <= maxwidth) {
                if (x > 0) {
                    x += hg;
                }
                x += d.width;
                rowh = Math.max(rowh, d.height);
                continue;
            }
            x = d.width;
            y += vg + rowh;
            rowh = d.height;
        }
        return y + rowh + vg + insets.bottom;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension result;
        if (this.getOrientation() == 0) {
            result = this.fCountContainerWidth ? new Dimension(container.getWidth(), this.preferredLayoutHeight(container)) : super.preferredLayoutSize(container);
        } else {
            int vg = this.getVgap();
            int hg = this.getHgap();
            result = new Dimension(0, 0);
            Insets insets = container.getInsets();
            int i = container.getComponentCount();
            for (int j = 0; j < i; ++j) {
                Component component = container.getComponent(j);
                if (!component.isVisible()) continue;
                Dimension prefSize = component.getPreferredSize();
                result.width = Math.max(result.width, prefSize.width);
                if (j > 0) {
                    result.height += vg;
                }
                result.height += prefSize.height;
            }
            result.width += insets.left + insets.right + hg * 2;
            result.height += insets.top + insets.bottom + vg * 2;
        }
        return result;
    }

    public int getOrientation() {
        return this.fOrientation;
    }

    public void setOrientation(int anOrientation) {
        this.fOrientation = anOrientation;
    }

    public int getVerticalAlign() {
        return this.fVerticalAlign;
    }

    public void setVerticalAlign(int aVerticalAlign) {
        this.fVerticalAlign = aVerticalAlign;
    }
}

