/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import java.awt.Toolkit;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FixedCharsDocument
extends PlainDocument {
    protected int fMaxChars = -1;
    protected boolean fTrancate = false;

    public FixedCharsDocument() {
    }

    public FixedCharsDocument(int aMaxChars) {
        this(aMaxChars, false);
    }

    public FixedCharsDocument(int aMaxChars, boolean isTrancate) {
        this.setMaxChars(aMaxChars);
        this.setTrancate(isTrancate);
    }

    public FixedCharsDocument(AbstractDocument.Content c) {
        super(c);
    }

    public FixedCharsDocument(AbstractDocument.Content c, int aMaxChars) {
        super(c);
        this.setMaxChars(aMaxChars);
    }

    public int getMaxChars() {
        return this.fMaxChars;
    }

    public void setMaxChars(int aMaxChars) {
        this.fMaxChars = aMaxChars;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.fMaxChars > 0) {
            String text = str;
            if (str.length() > this.fMaxChars) {
                text = str.substring(0, this.fMaxChars);
            }
            if (this.getLength() + text.length() <= this.fMaxChars) {
                super.insertString(offs, text, a);
            } else {
                int l;
                if (this.isTrancate() && (l = this.fMaxChars - this.getLength()) > 0) {
                    super.insertString(offs, text.substring(0, l), a);
                }
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            super.insertString(offs, str, a);
        }
    }

    public boolean isTrancate() {
        return this.fTrancate;
    }

    public void setTrancate(boolean trancate) {
        this.fTrancate = trancate;
    }
}

