/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.util.BrowserLauncher;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import javax.swing.SwingUtilities;

public class ExternalBrowser {
    protected static Impl fImpl = new DefaultImpl();

    public static void callBrowser(String aURL) {
        ExternalBrowser.callBrowser(aURL, null);
    }

    public static void callBrowser(String aURL, Component anOwner) {
        try {
            if (aURL != null) {
                Applet applet;
                Applet applet2 = applet = anOwner != null ? (Applet)SwingUtilities.getAncestorOfClass(Applet.class, anOwner) : null;
                if (applet == null) {
                    Window w;
                    Window window = w = anOwner != null ? (Window)SwingUtilities.getAncestorOfClass(Window.class, anOwner) : null;
                    if (w != null && w.getOwner() != null && (w.getOwner().getClass().getName().equals("sun.plugin.viewer.frame.WNetscapeEmbeddedFrame") || w.getOwner().getClass().getName().equals("sun.plugin.viewer.frame.IExplorerEmbeddedFrame"))) {
                        applet = ExternalBrowser.findApplet(w.getOwner());
                    }
                }
                if (applet != null) {
                    applet.getAppletContext().showDocument(new URL(aURL));
                } else {
                    fImpl.openURL(aURL);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setImpl(Impl anImpl) {
        if (anImpl == null) {
            throw new IllegalArgumentException("Null impl");
        }
        fImpl = anImpl;
    }

    public static Applet findApplet(Container w) {
        Applet result = null;
        for (int i = 0; result == null && i < w.getComponentCount(); ++i) {
            Component c = w.getComponent(i);
            if (c instanceof Applet) {
                result = (Applet)c;
                continue;
            }
            if (!(c instanceof Container)) continue;
            result = ExternalBrowser.findApplet((Container)c);
        }
        return result;
    }

    public static void callBrowser(URL aURL) {
        ExternalBrowser.callBrowser(aURL, null);
    }

    public static void callBrowser(URL aURL, Component anOwner) {
        if (aURL != null) {
            ExternalBrowser.callBrowser(aURL.toString(), anOwner);
        }
    }

    static class DefaultImpl
    implements Impl {
        DefaultImpl() {
        }

        public void openURL(String aURL) throws IOException {
            BrowserLauncher.openURL(aURL);
        }
    }

    public static interface Impl {
        public void openURL(String var1) throws IOException;
    }
}

