/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.LafColor;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicLabelUI;

public class DividerLabel
extends JLabel {
    private static DividerLabelUI fDividerLabelUI = new DividerLabelUI();
    protected Color fDividerColor;
    protected int fFontStyle = -1;
    protected int fFontIncrement = 0;
    public static final int FONT_STYLE_CURRENT = -1;
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int STYLE_CENTERED_3D = 0;
    public static final int STYLE_CENTERED_PLAIN = 1;
    public static final int STYLE_UNDERLINE_PLAIN = 2;
    public static final int STYLE_UNDERLINE = 2;
    public static final int STYLE_UNDERLINE_3D = 3;
    public static final int STYLE_UNDERLINE_3D_SOFT = 4;
    protected int fStyle = 0;

    public DividerLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.init();
    }

    public DividerLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.init();
    }

    public DividerLabel(String text) {
        super(text);
        this.init();
    }

    public DividerLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.init();
    }

    public DividerLabel(Icon image) {
        super(image);
        this.init();
    }

    public DividerLabel() {
        this.init();
    }

    private void init() {
        this.setFontStyle(1);
        this.setForeground(new LafColor("control", -0.3f));
    }

    public void setFont(Font fnt) {
        if (this.fFontStyle != -1 || this.fFontIncrement != 0) {
            super.setFont(new FontUIResource(fnt.deriveFont(this.fFontStyle != -1 ? this.fFontStyle : fnt.getStyle(), fnt.getSize() + this.fFontIncrement)));
        } else {
            super.setFont(fnt);
        }
    }

    public Color getDividerColor() {
        return this.fDividerColor;
    }

    public void setDividerColor(Color aDividerColor) {
        this.fDividerColor = aDividerColor;
        this.repaint();
    }

    public void updateUI() {
        this.setUI(fDividerLabelUI);
    }

    public int getFontStyle() {
        return this.fFontStyle;
    }

    public void setFontStyle(int aFontStyle) {
        if (this.fFontStyle != aFontStyle) {
            this.fFontStyle = aFontStyle;
            this.updateUI();
        }
    }

    public int getFontIncrement() {
        return this.fFontIncrement;
    }

    public void setFontIncrement(int aFontIncrement) {
        if (this.fFontIncrement != aFontIncrement) {
            this.fFontIncrement = aFontIncrement;
            this.updateUI();
        }
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (result.height == 0) {
            result.height = 4;
        }
        if (this.fStyle == 2 || this.fStyle == 3 || this.fStyle == 3 || this.fStyle == 4) {
            result.height += 4;
        }
        return result;
    }

    public Dimension getMinimumSize() {
        Dimension result = super.getMinimumSize();
        if (result.height == 0) {
            result.height = 4;
        }
        return result;
    }

    public int getStyle() {
        return this.fStyle;
    }

    public void setStyle(int aStyle) {
        if (this.fStyle != aStyle) {
            this.fStyle = aStyle;
            this.revalidate();
            this.repaint();
        }
    }

    static class DividerLabelUI
    extends BasicLabelUI {
        public static final int UNDERLINE_OFFSET = 2;
        private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
        private static Rectangle paintViewR = new Rectangle();
        private static Rectangle paintIconR = new Rectangle();
        private static Rectangle paintTextR = new Rectangle();
        static final Color COLOR_SHADOW = new LafColor("control", -0.9f);
        static final Color COLOR_HIGHLIGHT = new LafColor("control", 0.9f);
        static final Color COLOR_CONTROL = new LafColor("control", 1.0f);

        DividerLabelUI() {
        }

        public void paint(Graphics g, JComponent c) {
            DividerLabel label = (DividerLabel)c;
            int style = label.getStyle();
            if (style == 2 || style == 3 || style == 3 || style == 4) {
                g.translate(0, -2);
            }
            super.paint(g, c);
            String text = label.getText();
            Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            FontMetrics fm = g.getFontMetrics();
            paintViewInsets = c.getInsets(paintViewInsets);
            DividerLabelUI.paintViewR.x = DividerLabelUI.paintViewInsets.left;
            DividerLabelUI.paintViewR.y = DividerLabelUI.paintViewInsets.top;
            DividerLabelUI.paintViewR.width = c.getWidth() - (DividerLabelUI.paintViewInsets.left + DividerLabelUI.paintViewInsets.right);
            DividerLabelUI.paintViewR.height = c.getHeight() - (DividerLabelUI.paintViewInsets.top + DividerLabelUI.paintViewInsets.bottom);
            DividerLabelUI.paintIconR.height = 0;
            DividerLabelUI.paintIconR.width = 0;
            DividerLabelUI.paintIconR.y = 0;
            DividerLabelUI.paintIconR.x = 0;
            DividerLabelUI.paintTextR.height = 0;
            DividerLabelUI.paintTextR.width = 0;
            DividerLabelUI.paintTextR.y = 0;
            DividerLabelUI.paintTextR.x = 0;
            this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
            int gap = text != null && !"".equals(text) ? 4 : 0;
            int lineX1 = DividerLabelUI.paintTextR.x + DividerLabelUI.paintTextR.width + gap;
            int lineX2 = DividerLabelUI.paintViewR.x + DividerLabelUI.paintViewR.width;
            if (c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                lineX1 = DividerLabelUI.paintViewInsets.left;
                lineX2 = DividerLabelUI.paintTextR.x - gap;
            }
            int lineY = DividerLabelUI.paintViewR.height / 2;
            if (label.getStyle() == 0) {
                g.setColor(COLOR_SHADOW);
                g.drawLine(lineX1, lineY, lineX2, lineY);
                g.setColor(COLOR_HIGHLIGHT);
                g.drawLine(lineX1, lineY + 1, lineX2, lineY + 1);
            } else if (label.getStyle() == 1) {
                g.setColor(label.getDividerColor() == null ? COLOR_SHADOW : label.getDividerColor());
                g.drawLine(lineX1, lineY, lineX2, lineY);
            } else if (label.getStyle() == 2) {
                g.setColor(label.getDividerColor() == null ? COLOR_SHADOW : label.getDividerColor());
                int offsY = DividerLabelUI.paintViewR.y + DividerLabelUI.paintViewR.height - 1;
                g.drawLine(DividerLabelUI.paintViewR.x, offsY, DividerLabelUI.paintViewR.x + DividerLabelUI.paintViewR.width, offsY);
            } else if (label.getStyle() == 3) {
                g.setColor(COLOR_SHADOW);
                int offsY = DividerLabelUI.paintViewR.y + DividerLabelUI.paintViewR.height - 1;
                g.drawLine(DividerLabelUI.paintViewR.x, offsY, DividerLabelUI.paintViewR.x + DividerLabelUI.paintViewR.width, offsY);
                g.setColor(COLOR_HIGHLIGHT);
                g.drawLine(DividerLabelUI.paintViewR.x, ++offsY, DividerLabelUI.paintViewR.x + DividerLabelUI.paintViewR.width, offsY);
            } else if (label.getStyle() == 4) {
                g.setColor(COLOR_SHADOW);
                int offsY = DividerLabelUI.paintViewR.y + DividerLabelUI.paintViewR.height - 1;
                g.drawLine(DividerLabelUI.paintViewR.x, offsY, DividerLabelUI.paintViewR.x + DividerLabelUI.paintViewR.width, offsY);
                g.setColor(COLOR_HIGHLIGHT);
                g.drawLine(DividerLabelUI.paintViewR.x, ++offsY, DividerLabelUI.paintViewR.x + DividerLabelUI.paintViewR.width, offsY);
                ((Graphics2D)g).setPaint(new GradientPaint(DividerLabelUI.paintViewR.x, offsY - 1, COLOR_CONTROL, DividerLabelUI.paintViewR.x + DividerLabelUI.paintViewR.width / 2, offsY - 1, new Color(255, 255, 255, 0), true));
                g.fillRect(DividerLabelUI.paintViewR.x, offsY - 1, DividerLabelUI.paintViewR.width, 2);
            }
        }
    }
}

