/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.ComponentPainter;
import dev.gui.InitializableComponentPainter;
import dev.gui.TooltipProvider;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class ComponentPainterSupport
implements TooltipProvider {
    protected Component fOwner;
    protected List fComponentPainters;

    public ComponentPainterSupport(Component aOwner) {
        this.fOwner = aOwner;
    }

    public void addComponentPainter(ComponentPainter aComponentPainter) {
        if (this.fComponentPainters == null) {
            this.fComponentPainters = new ArrayList();
        }
        this.fComponentPainters.add(aComponentPainter);
        if (aComponentPainter instanceof InitializableComponentPainter) {
            ((InitializableComponentPainter)((Object)aComponentPainter)).init(this.fOwner);
        }
        if (this.fOwner.isShowing()) {
            this.fOwner.repaint();
        }
    }

    public void removeComponentPainter(ComponentPainter aComponentPainter) {
        if (aComponentPainter instanceof InitializableComponentPainter) {
            ((InitializableComponentPainter)((Object)aComponentPainter)).release(this.fOwner);
        }
        if (this.fComponentPainters != null && this.fComponentPainters.remove(aComponentPainter) && this.fOwner.isShowing()) {
            this.fOwner.repaint();
        }
    }

    public void paintComponent(Graphics g) {
        if (this.fComponentPainters != null) {
            int count = this.fComponentPainters.size();
            for (int i = 0; i < count; ++i) {
                ((ComponentPainter)this.fComponentPainters.get(i)).paint(g, this.fOwner);
            }
        }
    }

    public String getToolTipText(MouseEvent event) {
        String result = null;
        if (this.fComponentPainters != null) {
            int count = this.fComponentPainters.size();
            for (int i = 0; result == null && i < count; ++i) {
                if (!(this.fComponentPainters.get(i) instanceof TooltipProvider)) continue;
                result = ((TooltipProvider)this.fComponentPainters.get(i)).getToolTipText(event);
            }
        }
        return result;
    }
}

