/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;

public class ComponentFontSupport {
    protected JComponent fComponent;
    protected float fFontSize = 0.0f;
    protected int fFontStyle = -1;
    protected int fFontIncrement = 0;
    public static final int CURRENT = -1;

    public ComponentFontSupport(JComponent aComponent) {
        this.fComponent = aComponent;
    }

    public Font getFont(Font aFont) {
        Font result = aFont;
        if (this.fFontStyle != -1 || this.fFontSize != 0.0f || this.fFontIncrement != 0) {
            int style = this.fFontStyle != -1 ? this.fFontStyle : result.getStyle();
            float size = result.getSize();
            if (this.fFontIncrement != 0) {
                size += (float)this.fFontIncrement;
            } else if (this.fFontSize != 0.0f) {
                size = this.fFontSize;
            }
            result = new FontUIResource(result.deriveFont(style, size));
        }
        return result;
    }

    public int getFontStyle() {
        return this.fFontStyle;
    }

    public void setFontStyle(int aFontStyle) {
        if (this.fFontStyle != aFontStyle) {
            this.fFontStyle = aFontStyle;
            this.fComponent.updateUI();
        }
    }

    public int getFontIncrement() {
        return this.fFontIncrement;
    }

    public void setFontIncrement(int aFontIncrement) {
        if (this.fFontIncrement != aFontIncrement) {
            this.fFontIncrement = aFontIncrement;
            this.fComponent.updateUI();
        }
    }

    public float getFontSize() {
        return this.fFontSize;
    }

    public void setFontSize(float aFontSize) {
        if (this.fFontSize != aFontSize) {
            this.fFontSize = aFontSize;
            this.fComponent.updateUI();
        }
    }
}

