/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.ComponentPainter;
import dev.gui.IconComponentPainter;
import dev.gui.JCDialog;
import dev.gui.JTextFieldEx;
import dev.gui.ResourceUtils;
import dev.gui.TooltipProvider;
import dev.lang.BitTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class BasicComponentPainter
implements ComponentPainter,
TooltipProvider {
    protected int fWidth;
    protected int fHeight;
    protected int fAlignment = 16;
    protected boolean fRespectInsets = true;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 4;
    public static final int RIGHT = 8;
    public static final int CENTER = 16;
    private static Insets NO_INSETS = new Insets(0, 0, 0, 0);
    protected String fTooltipText;

    public BasicComponentPainter() {
    }

    public BasicComponentPainter(int aWidth, int aHeight) {
        this(aWidth, aHeight, 16, true);
    }

    public BasicComponentPainter(int aWidth, int aHeight, int aAlignment) {
        this(aWidth, aHeight, aAlignment, true);
    }

    public BasicComponentPainter(int aWidth, int aHeight, int aAlignment, boolean aRespectInsets) {
        this.fWidth = aWidth;
        this.fHeight = aHeight;
        this.fAlignment = aAlignment;
        this.fRespectInsets = aRespectInsets;
    }

    public int getHeight(Graphics g, Component c) {
        return this.fHeight;
    }

    public int getWidth(Graphics g, Component c) {
        return this.fWidth;
    }

    public int getAlignment() {
        return this.fAlignment;
    }

    public boolean isRespectInsets() {
        return this.fRespectInsets;
    }

    public Rectangle getBounds(Graphics g, Component c) {
        Point origin = this.getOrigin(g, c);
        return new Rectangle(origin.x, origin.y, this.getWidth(g, c), this.getHeight(g, c));
    }

    public Point getOrigin(Graphics g, Component c) {
        Point result = new Point(0, 0);
        Insets insets = this.isRespectInsets() && c instanceof JComponent ? ((JComponent)c).getInsets() : NO_INSETS;
        int alignment = this.getAlignment();
        int w = this.getWidth(g, c);
        int h = this.getHeight(g, c);
        int cW = c.getWidth() - insets.left - insets.right;
        int cH = c.getHeight() - insets.top - insets.bottom;
        result.x = BitTools.checkBit(alignment, 2) ? insets.left : (BitTools.checkBit(alignment, 8) ? insets.left + cW - w - 1 : insets.left + (cW - w) / 2);
        result.y = BitTools.checkBit(alignment, 1) ? insets.top : (BitTools.checkBit(alignment, 4) ? insets.top + cH - h - 1 : insets.top + (cH - h) / 2);
        return result;
    }

    public void paint(Graphics g, Component c) {
        Point origin = this.getOrigin(g, c);
        g.translate(origin.x, origin.y);
        this.paintImpl(g, c);
        g.translate(-origin.x, -origin.y);
    }

    protected void paintImpl(Graphics g, Component c) {
        g.setColor(Color.red);
        g.drawRect(0, 0, this.getWidth(g, c), this.getHeight(g, c));
    }

    public static void main(String[] args) {
        JTextFieldEx jTextFieldEx = new JTextFieldEx();
        jTextFieldEx.setPreferredWidth(150);
        jTextFieldEx.addComponentPainter(new IconComponentPainter(ResourceUtils.loadImageIcon("/dev/gui/wizard/res/throbber.gif"), 2));
        JCDialog.executeModal(null, "", (JComponent)jTextFieldEx);
        System.exit(0);
    }

    public String getTooltipText() {
        return this.fTooltipText;
    }

    public void setTooltipText(String aTooltipText) {
        this.fTooltipText = aTooltipText;
    }

    public String getToolTipText(MouseEvent event) {
        String result = null;
        if (this.fTooltipText != null && this.getBounds(event.getComponent().getGraphics(), event.getComponent()).contains(event.getPoint())) {
            result = this.fTooltipText;
        }
        return result;
    }
}

