/*
 * Decompiled with CFR 0.152.
 */
package dev.crypto;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PasswordCipher {
    private static final byte[] SALT = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
    protected Cipher fCipher;
    protected PBEParameterSpec fPBEParameterSpec;
    protected SecretKey fSecretKey;

    public PasswordCipher(String aPassword) {
        try {
            this.fPBEParameterSpec = new PBEParameterSpec(SALT, 20);
            PBEKeySpec keySpec = new PBEKeySpec(aPassword.toCharArray());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            this.fSecretKey = keyFactory.generateSecret(keySpec);
            this.fCipher = Cipher.getInstance("PBEWithMD5AndDES");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    protected void init(boolean isEncrypt) {
        try {
            this.fCipher.init(isEncrypt ? 1 : 2, (Key)this.fSecretKey, this.fPBEParameterSpec);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public synchronized byte[] encrypt(byte[] aBytes) {
        try {
            this.init(true);
            return this.fCipher.doFinal(aBytes);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public synchronized byte[] decrypt(byte[] aBytes) {
        try {
            this.init(false);
            return this.fCipher.doFinal(aBytes);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getCause());
        }
    }
}

