/*
 * Decompiled with CFR 0.152.
 */
package dev.beans.presentation;

import dev.beans.presentation.BeanPresentation;
import dev.beans.presentation.BeanPresentationDelegate;
import dev.beans.presentation.ParameterizedPropertyPresentation;
import dev.beans.presentation.PropertyNameHolder;
import dev.beans.presentation.PropertyPresentation;
import dev.entities.PrimaryInterfaceHolder;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanPresentationService {
    protected static BeanPresentationService fInstance = new BeanPresentationService();
    protected HashMap fBeanClassMap = new HashMap();
    protected static final Object[] EMPTY_PARAMS = new Object[0];

    public static BeanPresentationService getInstance() {
        return fInstance;
    }

    public BeanPresentation getBeanPresentation(Class aBeanClass, Object aSelector) {
        return this.getBeanPresentation(aBeanClass, aSelector, null);
    }

    public BeanPresentation getBeanPresentation(Class aBeanClass, Object aSelector, Object aParams) {
        BeanPresentationImpl result = new BeanPresentationImpl(aBeanClass, aSelector, aParams);
        result.init();
        return result;
    }

    public void registerPropertyPresentation(Class aBeanClass, String aPropertyName, Class aPropertyPresentationClass) {
        this.registerPropertyPresentation(aBeanClass, aPropertyName, null, aPropertyPresentationClass);
    }

    public void registerPropertyPresentation(Class aBeanClass, String aPropertyName, Object aSelector, Class aPropertyPresentationClass) {
        HashMap<PropertyPresentationKey, Class> propertyPresentationMap = (HashMap<PropertyPresentationKey, Class>)this.fBeanClassMap.get(aBeanClass);
        if (propertyPresentationMap == null) {
            propertyPresentationMap = new HashMap<PropertyPresentationKey, Class>();
            this.fBeanClassMap.put(aBeanClass, propertyPresentationMap);
        }
        propertyPresentationMap.put(new PropertyPresentationKey(aPropertyName, aSelector), aPropertyPresentationClass);
    }

    public void unRegisterPropertyPresentation(Class aBeanClass, String aPropertyName) {
        this.unRegisterPropertyPresentation(aBeanClass, aPropertyName, null);
    }

    public void unRegisterPropertyPresentation(Class aBeanClass, String aPropertyName, String aSelector) {
        HashMap propertyPresentationMap = (HashMap)this.fBeanClassMap.get(aBeanClass);
        if (propertyPresentationMap != null) {
            propertyPresentationMap.remove(new PropertyPresentationKey(aPropertyName, aSelector));
            if (propertyPresentationMap.isEmpty()) {
                this.fBeanClassMap.remove(aBeanClass);
            }
        }
    }

    public static String[] splitPropertyName(String aPropertyName) {
        String[] result = new String[]{aPropertyName, null};
        int dotIndex = aPropertyName.indexOf(46);
        if (dotIndex == -1) {
            dotIndex = aPropertyName.indexOf(45);
        }
        if (dotIndex != -1) {
            result[0] = aPropertyName.substring(0, dotIndex);
            result[1] = aPropertyName.substring(dotIndex + 1, aPropertyName.length());
        }
        return result;
    }

    public static String getContainerPropertyName(String aPropertyName) {
        String result = aPropertyName;
        int index = result.indexOf("[");
        if (index != -1 && result.endsWith("]")) {
            result = result.substring(0, index);
        }
        return result;
    }

    public static int getContainerIndex(String aPropertyName) {
        int result = -1;
        int index = aPropertyName.indexOf("[");
        try {
            if (index != -1 && aPropertyName.endsWith("]")) {
                result = Integer.parseInt(BeanPresentationService.getContainerIndexText(aPropertyName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getContainerIndexText(String aPropertyName) {
        String result = null;
        int index = aPropertyName.indexOf("[");
        if (index != -1 && aPropertyName.endsWith("]")) {
            result = aPropertyName.substring(index + 1, aPropertyName.length() - 1);
        }
        return result;
    }

    public static Object getContainerValue(Object aContainer, String aKey) {
        Object result = null;
        if (aContainer instanceof Map) {
            result = ((Map)aContainer).get(aKey);
        }
        return result;
    }

    public static Object getContainerValue(Object aContainer, int anIndex) {
        Object result = null;
        if (aContainer.getClass().isArray()) {
            Class<?> componentType = aContainer.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                if (componentType == Byte.TYPE) {
                    result = new Byte(((byte[])aContainer)[anIndex]);
                } else if (componentType == Character.TYPE) {
                    result = new Character(((char[])aContainer)[anIndex]);
                } else if (componentType == Integer.TYPE) {
                    result = new Integer(((int[])aContainer)[anIndex]);
                } else if (componentType == Long.TYPE) {
                    result = new Long(((long[])aContainer)[anIndex]);
                } else if (componentType == Float.TYPE) {
                    result = new Float(((float[])aContainer)[anIndex]);
                } else if (componentType == Double.TYPE) {
                    result = new Double(((double[])aContainer)[anIndex]);
                } else if (componentType == Boolean.TYPE) {
                    result = new Boolean(((boolean[])aContainer)[anIndex]);
                } else if (componentType == Short.TYPE) {
                    result = new Short(((short[])aContainer)[anIndex]);
                }
            } else {
                result = ((Object[])aContainer)[anIndex];
            }
        } else if (aContainer instanceof List) {
            result = ((List)aContainer).get(anIndex);
        }
        return result;
    }

    protected class BeanPresentationImpl
    implements BeanPresentation {
        protected Class fBeanClass;
        protected Object fSelector;
        protected Object fParams;
        protected HashMap fPropertyMap = new HashMap();
        protected HashMap fBeanPresentationMap = new HashMap();

        public BeanPresentationImpl(Class aBeanClass, Object aSelector, Object aParams) {
            this.fBeanClass = aBeanClass;
            this.fSelector = aSelector;
            this.fParams = aParams;
        }

        protected void cachePropertyDescriptors(Class aBeanClass) throws IntrospectionException {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(aBeanClass).getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                this.fPropertyMap.put(propertyDescriptor.getName(), propertyDescriptor);
            }
        }

        protected void init() {
            try {
                HashMap propertyPresentationMap;
                this.cachePropertyDescriptors(this.fBeanClass);
                if (this.fBeanClass.isInterface()) {
                    Class<?>[] interfaces = this.fBeanClass.getInterfaces();
                    for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
                        this.cachePropertyDescriptors(interfaces[i]);
                    }
                }
                if ((propertyPresentationMap = (HashMap)BeanPresentationService.this.fBeanClassMap.get(this.fBeanClass)) != null) {
                    for (PropertyPresentationKey propertyPresentationKey : propertyPresentationMap.keySet()) {
                        if (!propertyPresentationKey.equalsSelector(this.fSelector) && (propertyPresentationKey.fSelector != null || this.fPropertyMap.containsKey(propertyPresentationKey.fPropertyName))) continue;
                        PropertyPresentation propertyPresentation = (PropertyPresentation)((Class)propertyPresentationMap.get(propertyPresentationKey)).newInstance();
                        propertyPresentation.init(this.fSelector, (PropertyDescriptor)this.fPropertyMap.get(propertyPresentationKey.fPropertyName));
                        if (propertyPresentation instanceof ParameterizedPropertyPresentation) {
                            ((ParameterizedPropertyPresentation)propertyPresentation).setParams(this.fParams);
                        }
                        if (propertyPresentation instanceof PropertyNameHolder) {
                            ((PropertyNameHolder)((Object)propertyPresentation)).setPropertyName(propertyPresentationKey.fPropertyName);
                        }
                        this.fPropertyMap.put(propertyPresentationKey.fPropertyName, propertyPresentation);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Unable to initialize bean presentation");
            }
        }

        public Collection getPropertyNames() {
            return this.fPropertyMap.keySet();
        }

        public Object getPropertyValue(Object aBean, String aPropertyName) {
            String[] splittedPropertyName = BeanPresentationService.splitPropertyName(aPropertyName);
            String propertyName = BeanPresentationService.getContainerPropertyName(splittedPropertyName[0]);
            int containerIndex = BeanPresentationService.getContainerIndex(splittedPropertyName[0]);
            String containerIndexText = BeanPresentationService.getContainerIndexText(splittedPropertyName[0]);
            Object result = null;
            if (aBean == null) {
                throw new IllegalArgumentException("Bean value shouldn't be null");
            }
            if (aPropertyName.startsWith("[") && aPropertyName.endsWith("]")) {
                int index = containerIndex;
                if (index > -1) {
                    if (aBean.getClass().isArray()) {
                        result = ((Object[])aBean)[index];
                    } else if (aBean instanceof List) {
                        result = ((List)aBean).get(index);
                    }
                } else if (aBean instanceof Map) {
                    String key = aPropertyName.substring(index + 1, aPropertyName.length() - 1);
                    result = ((Map)aBean).get(key);
                }
            } else {
                if (!this.isPropertyExists(propertyName) && !(aBean instanceof BeanPresentationDelegate)) {
                    throw new IllegalArgumentException("Property doesn't exist: " + propertyName);
                }
                Object propertyDescr = this.fPropertyMap.get(propertyName);
                if (propertyDescr instanceof PropertyDescriptor) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyDescr;
                    if (propertyDescriptor.getReadMethod() == null) {
                        throw new IllegalArgumentException("Unable to get property read method: " + propertyName);
                    }
                    try {
                        result = propertyDescriptor.getReadMethod().invoke(aBean, EMPTY_PARAMS);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new IllegalStateException("Unable to get property value: " + propertyName);
                    }
                } else if (propertyDescr instanceof PropertyPresentation) {
                    PropertyPresentation propertyPresentation = (PropertyPresentation)propertyDescr;
                    result = propertyPresentation.getPropertyValue(aBean);
                } else if (aBean instanceof BeanPresentationDelegate) {
                    BeanPresentationDelegate beanPresentationDelegate = (BeanPresentationDelegate)aBean;
                    if (beanPresentationDelegate.isPropertyExists(aPropertyName)) {
                        result = beanPresentationDelegate.getPropertyValue(aPropertyName);
                    } else {
                        throw new IllegalArgumentException("Property is not exists: " + propertyName);
                    }
                }
                if (containerIndex != -1) {
                    result = BeanPresentationService.getContainerValue(result, containerIndex);
                } else if (containerIndexText != null) {
                    result = BeanPresentationService.getContainerValue(result, containerIndexText);
                }
                if (result != null && splittedPropertyName[1] != null) {
                    Class subPropertyBeanClass = result instanceof PrimaryInterfaceHolder ? ((PrimaryInterfaceHolder)result).getPrimaryInterface() : result.getClass();
                    BeanPresentation subBeanPresentation = (BeanPresentation)this.fBeanPresentationMap.get(subPropertyBeanClass);
                    if (subBeanPresentation == null) {
                        subBeanPresentation = BeanPresentationService.getInstance().getBeanPresentation(subPropertyBeanClass, this.fSelector);
                        this.fBeanPresentationMap.put(subPropertyBeanClass, subBeanPresentation);
                    }
                    result = subBeanPresentation.getPropertyValue(result, splittedPropertyName[1]);
                }
            }
            return result;
        }

        public boolean isPropertyExists(String aPropertyName) {
            return this.fPropertyMap.containsKey(aPropertyName);
        }

        public void setPropertyValue(Object aBean, String aPropertyName, Object aPropertyValue) {
            String[] splittedPropertyName = BeanPresentationService.splitPropertyName(aPropertyName);
            String propertyName = splittedPropertyName[0];
            if (!this.isPropertyExists(propertyName)) {
                throw new IllegalArgumentException("Property is not exists: " + propertyName);
            }
            if (aBean == null) {
                throw new IllegalArgumentException("Bean value shouldn't be null");
            }
            if (splittedPropertyName[1] == null) {
                Object propertyDescr = this.fPropertyMap.get(propertyName);
                if (propertyDescr instanceof PropertyDescriptor) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyDescr;
                    if (propertyDescriptor.getWriteMethod() == null) {
                        throw new IllegalArgumentException("Unable to get property write method: " + propertyName);
                    }
                    try {
                        this.setPropertyValue(aBean, aPropertyValue, propertyDescriptor);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new IllegalStateException("Unable to update property value: " + propertyName);
                    }
                } else if (propertyDescr instanceof PropertyPresentation) {
                    PropertyPresentation propertyPresentation = (PropertyPresentation)propertyDescr;
                    propertyPresentation.setPropertyValue(aBean, aPropertyValue);
                }
            } else {
                Object subPropertyValue = this.getPropertyValue(aBean, propertyName);
                if (subPropertyValue != null) {
                    Class subPropertyBeanClass = subPropertyValue instanceof PrimaryInterfaceHolder ? ((PrimaryInterfaceHolder)subPropertyValue).getPrimaryInterface() : subPropertyValue.getClass();
                    BeanPresentation subBeanPresentation = (BeanPresentation)this.fBeanPresentationMap.get(subPropertyBeanClass);
                    if (subBeanPresentation == null) {
                        subBeanPresentation = BeanPresentationService.getInstance().getBeanPresentation(subPropertyBeanClass, this.fSelector);
                        this.fBeanPresentationMap.put(subPropertyBeanClass, subBeanPresentation);
                    }
                    subBeanPresentation.setPropertyValue(subPropertyValue, splittedPropertyName[1], aPropertyValue);
                }
            }
        }

        protected Object setPropertyValue(Object aBean, Object aPropertyValue, PropertyDescriptor propertyDescriptor) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
            Object value = aPropertyValue;
            if (value instanceof String) {
                Class<?> type = propertyDescriptor.getPropertyType();
                if (type == Integer.TYPE || type == Integer.class) {
                    value = new Integer((String)value);
                } else if (type == Long.TYPE || type == Long.class) {
                    value = new Long((String)value);
                } else if (type == Float.TYPE || type == Float.class) {
                    value = new Float((String)value);
                } else if (type == Double.TYPE || type == Double.class) {
                    value = new Double((String)value);
                } else if (type == Boolean.TYPE || type == Boolean.class) {
                    value = new Boolean((String)value);
                }
            }
            return propertyDescriptor.getWriteMethod().invoke(aBean, value);
        }
    }

    static class PropertyPresentationKey {
        protected String fPropertyName;
        protected Object fSelector;

        public PropertyPresentationKey(String aPropertyName, Object aSelector) {
            this.fPropertyName = aPropertyName;
            this.fSelector = aSelector;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PropertyPresentationKey)) {
                return false;
            }
            boolean result = false;
            PropertyPresentationKey key = (PropertyPresentationKey)obj;
            result = this.fPropertyName.equals(key.fPropertyName) && this.equalsSelector(key.fSelector);
            return result;
        }

        public boolean equalsSelector(Object aSelector) {
            if (this.fSelector == aSelector) {
                return true;
            }
            boolean result = false;
            if (this.fSelector != null) {
                result = this.fSelector.equals(aSelector);
            } else if (aSelector != null) {
                result = aSelector.equals(this.fSelector);
            }
            return result;
        }

        public int hashCode() {
            return this.fPropertyName.hashCode() + (this.fSelector != null ? this.fSelector.hashCode() : 0);
        }
    }
}

