/*
 * Decompiled with CFR 0.152.
 */
package dev.beans.presentation;

import dev.beans.presentation.BeanPresentation;
import dev.beans.presentation.BeanPresentationService;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;

public class BeanPresentationPrinter {
    protected MessageFormat fMessageFormat = new MessageFormat("{0} - {1}\n");
    protected BeanPresentation fBeanPresentation;

    public void applyPattern(String newPattern) {
        this.fMessageFormat.applyPattern(newPattern);
    }

    public String toPattern() {
        return this.fMessageFormat.toPattern();
    }

    public BeanPresentationPrinter(Class aBeanClass) {
        this(aBeanClass, null);
    }

    public BeanPresentationPrinter(Class aBeanClass, Object aSelector) {
        this.fBeanPresentation = BeanPresentationService.getInstance().getBeanPresentation(aBeanClass, aSelector);
    }

    public String print(Object aBean) {
        return this.print(aBean, null);
    }

    public String print(Object aBean, HashSet anIncludeSet) {
        StringBuffer result = new StringBuffer();
        this.print(aBean, result, anIncludeSet);
        return result.toString();
    }

    public void print(Object aBean, StringBuffer aStringBuffer, HashSet anIncludeSet) {
        Iterator propertyNames;
        Object[] args = new Object[2];
        Iterator iterator = propertyNames = anIncludeSet == null ? this.fBeanPresentation.getPropertyNames().iterator() : anIncludeSet.iterator();
        while (propertyNames.hasNext()) {
            String propertyName = (String)propertyNames.next();
            args[0] = propertyName;
            args[1] = this.fBeanPresentation.getPropertyValue(aBean, propertyName);
            this.fMessageFormat.format(args, aStringBuffer, (FieldPosition)null);
        }
    }
}

