/*
 * Decompiled with CFR 0.152.
 */
package dev.beans.beancontext;

import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.beans.beancontext.BeanContextSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TooManyListenersException;
import java.util.Vector;

public class CustomBeanContextServicesSupport
extends BeanContextSupport
implements BeanContextServices {
    protected HashMap fServiceClass2ProviderMap = new HashMap();
    protected HashMap fServiceKey2ServiceRevokedListenerMap = new HashMap();
    protected Service2ServiceKeyMap fService2ServiceKeyMap = new Service2ServiceKeyMap();
    private transient Vector fBeanContextServicesListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addService(Class aServiceClass, BeanContextServiceProvider aServiceProvider) {
        boolean result = false;
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (!this.fServiceClass2ProviderMap.containsKey(aServiceClass)) {
                this.fServiceClass2ProviderMap.put(aServiceClass, aServiceProvider);
                this.fireServiceAvailable(new BeanContextServiceAvailableEvent(this, aServiceClass));
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeService(Class aServiceClass, BeanContextServiceProvider aServiceProvider, boolean aRevokeCurrentServicesNow) {
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (this.fServiceClass2ProviderMap.containsKey(aServiceClass)) {
                Object serviceProvider = this.fServiceClass2ProviderMap.get(aServiceClass);
                if (serviceProvider != aServiceProvider) {
                    throw new IllegalArgumentException("Service provider mismatch: " + serviceProvider + " != " + aServiceProvider);
                }
                this.fServiceClass2ProviderMap.remove(aServiceClass);
                this.fireServiceRevoked(new BeanContextServiceRevokedEvent(this, aServiceClass, aRevokeCurrentServicesNow));
                Iterator serviceKeys = this.fServiceKey2ServiceRevokedListenerMap.keySet().iterator();
                while (serviceKeys.hasNext()) {
                    ServiceKey serviceKey = (ServiceKey)serviceKeys.next();
                    if (!serviceKey.fServiceClass.equals(aServiceClass)) continue;
                    BeanContextServiceRevokedListener listener = (BeanContextServiceRevokedListener)this.fServiceKey2ServiceRevokedListenerMap.get(serviceKey);
                    if (listener != null) {
                        listener.serviceRevoked(new BeanContextServiceRevokedEvent(this, aServiceClass, true));
                    }
                    serviceKeys.remove();
                    if (!aRevokeCurrentServicesNow) continue;
                    Iterator services = this.fService2ServiceKeyMap.services();
                    while (services.hasNext()) {
                        Object service = services.next();
                        if (!serviceKey.equals(this.fService2ServiceKeyMap.getServiceKey(service, serviceKey.fRequestor))) continue;
                        services.remove();
                    }
                }
            } else {
                throw new IllegalArgumentException("Service is missing: " + aServiceClass);
            }
        }
    }

    public boolean hasService(Class aServiceClass) {
        return this.fServiceClass2ProviderMap.containsKey(aServiceClass);
    }

    protected BeanContextServices getParentBeanContextServices() {
        BeanContextServices result = null;
        for (BeanContext parent = this.getBeanContext(); parent != null; parent = parent.getBeanContext()) {
            if (!(parent instanceof BeanContextServices)) continue;
            result = (BeanContextServices)parent;
            break;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getService(BeanContextChild aChild, Object aRequestor, Class aServiceClass, Object aServiceSelector, BeanContextServiceRevokedListener aListener) throws TooManyListenersException {
        Object result = null;
        ServiceKey serviceKey = new ServiceKey(aRequestor, aServiceClass, aServiceSelector);
        if (this.fServiceKey2ServiceRevokedListenerMap.containsKey(serviceKey)) {
            throw new IllegalArgumentException("Service is already given for that requestor: " + aRequestor);
        }
        BeanContextServiceProvider serviceProvider = (BeanContextServiceProvider)this.fServiceClass2ProviderMap.get(aServiceClass);
        if (serviceProvider == null) {
            BeanContextServices beanContextServices = this.getParentBeanContextServices();
            if (beanContextServices == null) throw new IllegalArgumentException("Service is missing : " + aServiceClass);
            return beanContextServices.getService(aChild, aRequestor, aServiceClass, aServiceSelector, aListener);
        }
        BeanContextServices beanContextServices = aChild instanceof BeanContextServices ? (BeanContextServices)aChild : this;
        result = serviceProvider.getService(beanContextServices, aRequestor, aServiceClass, aServiceSelector);
        this.fServiceKey2ServiceRevokedListenerMap.put(serviceKey, aListener);
        this.fService2ServiceKeyMap.put(result, serviceKey);
        return result;
    }

    public void releaseService(BeanContextChild aChild, Object aRequestor, Object aService) {
        ServiceKey serviceKey = this.fService2ServiceKeyMap.getServiceKey(aService, aRequestor);
        if (serviceKey == null) {
            BeanContextServices parentBeanContextServices = this.getParentBeanContextServices();
            if (parentBeanContextServices == null) {
                throw new IllegalArgumentException("The service doesn't belong to any bean context: " + aService);
            }
            parentBeanContextServices.releaseService(aChild, aRequestor, aService);
        } else {
            BeanContextServiceProvider serviceProvider = (BeanContextServiceProvider)this.fServiceClass2ProviderMap.get(serviceKey.fServiceClass);
            BeanContextServices bcs = aChild instanceof BeanContextServices ? (BeanContextServices)aChild : this;
            serviceProvider.releaseService(bcs, aRequestor, aService);
            this.fServiceKey2ServiceRevokedListenerMap.remove(serviceKey);
            this.fService2ServiceKeyMap.remove(aService, serviceKey);
        }
    }

    public Iterator getCurrentServiceClasses() {
        return this.fServiceClass2ProviderMap.keySet().iterator();
    }

    public Iterator getCurrentServiceSelectors(Class aServiceClass) {
        BeanContextServiceProvider serviceProvider = (BeanContextServiceProvider)this.fServiceClass2ProviderMap.get(aServiceClass);
        if (serviceProvider == null) {
            throw new IllegalArgumentException("Service is missing : " + aServiceClass);
        }
        return serviceProvider.getCurrentServiceSelectors(this, aServiceClass);
    }

    public synchronized void removeBeanContextServicesListener(BeanContextServicesListener l) {
        if (this.fBeanContextServicesListeners != null && this.fBeanContextServicesListeners.contains(l)) {
            Vector v = (Vector)this.fBeanContextServicesListeners.clone();
            v.removeElement(l);
            this.fBeanContextServicesListeners = v;
        }
    }

    public synchronized void addBeanContextServicesListener(BeanContextServicesListener l) {
        Vector v;
        Vector vector = v = this.fBeanContextServicesListeners == null ? new Vector(2) : (Vector)this.fBeanContextServicesListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fBeanContextServicesListeners = v;
        }
    }

    protected void fireServiceAvailable(BeanContextServiceAvailableEvent e) {
        if (this.fBeanContextServicesListeners != null) {
            Vector listeners = this.fBeanContextServicesListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((BeanContextServicesListener)listeners.elementAt(i)).serviceAvailable(e);
            }
        }
    }

    protected void fireServiceRevoked(BeanContextServiceRevokedEvent e) {
        if (this.fBeanContextServicesListeners != null) {
            Vector listeners = this.fBeanContextServicesListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((BeanContextServicesListener)listeners.elementAt(i)).serviceRevoked(e);
            }
        }
    }

    protected void releaseBeanContextResources() {
        for (Class serviceClass : new ArrayList(this.fServiceClass2ProviderMap.keySet())) {
            this.revokeService(serviceClass, (BeanContextServiceProvider)this.fServiceClass2ProviderMap.get(serviceClass), true);
        }
    }

    protected static class ServiceKey {
        Object fRequestor;
        Class fServiceClass;
        Object fServiceSelector;

        public ServiceKey(Object aRequestor, Class aServiceClass, Object aServiceSelector) {
            this.fRequestor = aRequestor;
            this.fServiceClass = aServiceClass;
            this.fServiceSelector = aServiceSelector;
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ServiceKey)) {
                return false;
            }
            ServiceKey serviceKey = (ServiceKey)obj;
            boolean bl = result = this.fRequestor.equals(serviceKey.fRequestor) && this.fServiceClass.equals(serviceKey.fServiceClass);
            if (result) {
                result = this.fServiceSelector != null ? this.fServiceSelector.equals(serviceKey.fServiceSelector) : serviceKey.fServiceSelector == this.fServiceSelector;
            }
            return result;
        }

        public int hashCode() {
            int result = this.fServiceClass.hashCode() + this.fRequestor.hashCode();
            if (this.fServiceSelector != null) {
                result += this.fServiceSelector.hashCode();
            }
            return result;
        }
    }

    protected static class Service2ServiceKeyMap {
        protected HashMap fServiceMap = new HashMap();

        protected Service2ServiceKeyMap() {
        }

        public Iterator services() {
            return this.fServiceMap.keySet().iterator();
        }

        public void put(Object aService, ServiceKey aServiceKey) {
            HashMap<Object, ServiceKey> requestor2ServiceKeyMap = (HashMap<Object, ServiceKey>)this.fServiceMap.get(aService);
            if (requestor2ServiceKeyMap == null) {
                requestor2ServiceKeyMap = new HashMap<Object, ServiceKey>();
                this.fServiceMap.put(aService, requestor2ServiceKeyMap);
            }
            requestor2ServiceKeyMap.put(aServiceKey.fRequestor, aServiceKey);
        }

        public void remove(Object aService, ServiceKey aServiceKey) {
            HashMap requestor2ServiceKeyMap = (HashMap)this.fServiceMap.get(aService);
            if (requestor2ServiceKeyMap != null) {
                requestor2ServiceKeyMap.remove(aServiceKey.fRequestor);
                if (requestor2ServiceKeyMap.isEmpty()) {
                    this.fServiceMap.remove(aService);
                }
            }
        }

        public ServiceKey getServiceKey(Object aService, Object aRequestor) {
            ServiceKey result = null;
            HashMap requestor2ServiceKeyMap = (HashMap)this.fServiceMap.get(aService);
            if (requestor2ServiceKeyMap != null) {
                result = (ServiceKey)requestor2ServiceKeyMap.get(aRequestor);
            }
            return result;
        }
    }
}

