/*
 * Decompiled with CFR 0.152.
 */
package dev.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class BeanTools {
    public static void beanCopy(Object aSource, Object aDest, String[] aPropertyNames) {
        for (int i = 0; i < aPropertyNames.length; ++i) {
            String propertyName = aPropertyNames[i];
            Object value = BeanTools.getPropertyValue(aSource, propertyName);
            BeanTools.setPropertyValue(aDest, propertyName, value);
        }
    }

    public static List getPropertyDescriptors(Class aClass) {
        try {
            return aClass.isInterface() ? BeanTools.getPropertyDescriptorsForInterface(aClass, null) : new ArrayList<PropertyDescriptor>(Arrays.asList(Introspector.getBeanInfo(aClass).getPropertyDescriptors()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static List getPropertyDescriptorsForInterface(Class anInterfaceClass) {
        return BeanTools.getPropertyDescriptorsForInterface(anInterfaceClass, null);
    }

    public static PropertyDescriptor[] getPropertyDescriptorsForInterfaceAsArray(Class anInterfaceClass) {
        List propertyDescriptors = BeanTools.getPropertyDescriptorsForInterface(anInterfaceClass);
        PropertyDescriptor[] propertyDescriptorArray = new PropertyDescriptor[propertyDescriptors.size()];
        return propertyDescriptors.toArray(propertyDescriptorArray);
    }

    private static List getPropertyDescriptorsForInterface(Class anInterfaceClass, HashSet anInterfaceCache) {
        ArrayList<PropertyDescriptor> result = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(anInterfaceClass);
            result = new ArrayList<PropertyDescriptor>(Arrays.asList(beanInfo.getPropertyDescriptors()));
            Class<?>[] interfaces = anInterfaceClass.getInterfaces();
            if (interfaces.length > 0) {
                if (anInterfaceCache == null) {
                    anInterfaceCache = new HashSet<String>();
                }
                for (int i = 0; i < interfaces.length; ++i) {
                    if (anInterfaceCache.contains(interfaces[i].getName())) continue;
                    anInterfaceCache.add(interfaces[i].getName());
                    result.addAll(BeanTools.getPropertyDescriptorsForInterface(interfaces[i], anInterfaceCache));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static Object getPropertyValue(Object anObject, String aPropertyName) {
        BeanInfo info = BeanTools.getBeanInfo(anObject);
        Method method = BeanTools.getReadMethod(info, aPropertyName);
        if (method == null) {
            throw new IllegalStateException("Read method not found: " + anObject.getClass().getName() + "." + aPropertyName);
        }
        return BeanTools.invokeReadMethod(method, anObject);
    }

    public static void setPropertyValue(Object anObject, String aPropertyName, Object aPropertyValue) {
        BeanTools.setPropertyValue(anObject, new String[]{aPropertyName}, new Object[]{aPropertyValue});
    }

    public static BeanInfo getBeanInfo(Object anObject) {
        BeanInfo result = null;
        try {
            result = Introspector.getBeanInfo(anObject.getClass());
            return result;
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new IllegalStateException("Can't obtain bean information");
        }
    }

    public static Method getWriteMethod(BeanInfo info, String aPropertyName) {
        Method result = null;
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        boolean propertyExists = false;
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptor = descriptors[i];
            if (!descriptor.getName().equals(aPropertyName)) continue;
            result = descriptor.getWriteMethod();
            propertyExists = true;
            break;
        }
        if (!propertyExists) {
            throw new IllegalArgumentException("Property not found: " + info.getBeanDescriptor().getDisplayName() + "." + aPropertyName);
        }
        return result;
    }

    public static Method getReadMethod(BeanInfo info, String aPropertyName) {
        Method result = null;
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        boolean propertyExists = false;
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptor = descriptors[i];
            if (!descriptor.getName().equals(aPropertyName)) continue;
            propertyExists = true;
            result = descriptor.getReadMethod();
            break;
        }
        if (!propertyExists) {
            throw new IllegalArgumentException("Property not found: " + info.getBeanDescriptor().getDisplayName() + "." + aPropertyName);
        }
        return result;
    }

    public static Object invokeReadMethod(Method aMethod, Object anObject) {
        try {
            return aMethod.invoke(anObject, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Error while method invocation: " + aMethod.getName());
        }
    }

    public static void invokeWriteMethod(Method aMethod, Object anObject, Object aValue) {
        try {
            aMethod.invoke(anObject, aValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Error while method invocation: " + aMethod.getName());
        }
    }

    public static void setPropertyValue(Object anObject, String[] aPropertyNames, Object[] aPropertyValues) {
        if (aPropertyNames.length != aPropertyValues.length) {
            throw new IllegalArgumentException("Property names and values sizes mismatch");
        }
        BeanInfo info = BeanTools.getBeanInfo(anObject);
        for (int j = 0; j < aPropertyNames.length; ++j) {
            Method method = BeanTools.getWriteMethod(info, aPropertyNames[j]);
            if (method == null) {
                throw new IllegalStateException("Write method not found: " + anObject.getClass().getName() + "." + aPropertyNames[j]);
            }
            BeanTools.invokeWriteMethod(method, anObject, aPropertyValues[j]);
        }
    }

    public static Method getMethod(Class aClass, String aMethodName, Object[] aParams) {
        Method result = null;
        try {
            if (aParams == null) {
                aParams = new Class[]{};
            }
            Class[] paramTypes = new Class[aParams.length];
            for (int i = 0; i < aParams.length; ++i) {
                if (aParams[i] != null) {
                    if (aParams[i].getClass() == Integer.class) {
                        paramTypes[i] = Integer.TYPE;
                        continue;
                    }
                    if (aParams[i].getClass() == Long.class) {
                        paramTypes[i] = Long.TYPE;
                        continue;
                    }
                    if (aParams[i].getClass() == Boolean.class) {
                        paramTypes[i] = Boolean.TYPE;
                        continue;
                    }
                    paramTypes[i] = aParams[i].getClass();
                    continue;
                }
                paramTypes[i] = Object.class;
            }
            Method[] methods = aClass.getMethods();
            block3: for (int i = 0; i < methods.length; ++i) {
                Class<?>[] methodParameterTypes;
                Method method = methods[i];
                if (!method.getName().equals(aMethodName) || (methodParameterTypes = method.getParameterTypes()).length != paramTypes.length) continue;
                for (int j = 0; j < methodParameterTypes.length; ++j) {
                    if (!methodParameterTypes[j].isAssignableFrom(paramTypes[j])) continue block3;
                }
                result = method;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static Object invokeMethod(Object anObject, String aMethodName, Object[] aParams) {
        Object result = null;
        try {
            Method method = BeanTools.getMethod(anObject.getClass(), aMethodName, aParams);
            if (method != null) {
                result = method.invoke(anObject, aParams);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    static boolean isAcceptableParameters(Class[] aParameterDescriptors, Object[] aParams) {
        if (aParameterDescriptors == aParams) {
            return true;
        }
        if (aParameterDescriptors != null && aParams != null) {
            return aParameterDescriptors.length == aParams.length;
        }
        return false;
    }
}

