/*
 * Decompiled with CFR 0.152.
 */
package com.jp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class IndexedPropertiesSupport
implements Cloneable {
    protected Properties fProperties;
    protected String fIndexName;
    protected String fItemCountPropertyName;
    protected int fIndex;
    protected int fItemCount = 0;

    public int getItemCount() {
        int result = -1;
        result = Integer.parseInt(this.fProperties.getProperty(this.fItemCountPropertyName, "-1"));
        return result;
    }

    public void setItemCount(int aItemCount) {
        this.putItemCount(aItemCount);
    }

    public int getIndex() {
        return this.fIndex;
    }

    public void setIndex(int aIndex) {
        this.fIndex = aIndex;
    }

    public String getIndexName() {
        return this.fIndexName;
    }

    public void setIndexName(String aIndexName) {
        if (this.fIndexName != aIndexName) {
            this.fIndexName = aIndexName;
            this.fItemCountPropertyName = this.fIndexName + ".count";
            this.setIndex(0);
        }
    }

    protected void putItemCount(int anItemCount) {
        this.fProperties.put(this.fItemCountPropertyName, String.valueOf(anItemCount));
    }

    public IndexedPropertiesSupport(Properties aProperties) {
        this.fProperties = aProperties;
    }

    public String getIndexedPropertyName(String aPropertyName) {
        return this.getIndexedPropertyPrefix() + aPropertyName;
    }

    public String getIndexedPropertyPrefix() {
        return this.fIndexName + "[" + this.fIndex + "]" + ".";
    }

    protected Collection getIndexedPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        String prefix = this.getIndexedPropertyPrefix();
        Iterator<Object> keys = this.fProperties.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith(prefix)) continue;
            result.add(key);
        }
        return result;
    }

    public String getProperty(String key) {
        return this.fProperties.getProperty(this.getIndexedPropertyName(key));
    }

    public String getProperty(String key, String defaultValue) {
        return this.fProperties.getProperty(this.getIndexedPropertyName(key), defaultValue);
    }

    public synchronized Object setProperty(String key, String value) {
        return this.fProperties.setProperty(this.getIndexedPropertyName(key), value);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

