/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.utils.obfuscation;

import com.jp.protection.utils.obfuscation.BasicObfuscationUtils;
import com.jp.protection.utils.obfuscation.ObfuscationUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ZKMObfuscationUtils
extends BasicObfuscationUtils {
    public static final String TAG_PACKAGE = "Package:";
    public static final String TAG_CLASS = "Class:";
    public static final String TAG_DELIMITER = "=>";
    public static final String TAG_NAME_NOT_CHANGED = "NameNotChanged";

    public ZKMObfuscationUtils(File aChangeLogFile) {
        super(aChangeLogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseImpl() {
        try {
            FileInputStream stream = new FileInputStream(this.fChangeLogFile);
            try {
                this.parse(stream);
            }
            finally {
                ((InputStream)stream).close();
            }
        }
        catch (Exception ex) {
            this.error(ex);
            throw new IllegalStateException("Unable to parse change log file: " + this.fChangeLogFile.getAbsolutePath());
        }
    }

    protected void parse(InputStream aStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(aStream));
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith(TAG_PACKAGE)) {
                this.parsePackage(line);
            } else if (line.startsWith(TAG_CLASS)) {
                this.parseClass(line);
            }
            line = reader.readLine();
        }
    }

    protected void parsePackage(String aLine) {
        String line = aLine.substring(TAG_PACKAGE.length(), aLine.length()).replace('\t', ' ').trim();
        String[] splitted = line.split(TAG_DELIMITER);
        if (splitted.length == 2) {
            this.fPackageMap.put(splitted[0].trim(), splitted[1].trim());
        } else if (splitted.length == 1 && line.endsWith(TAG_NAME_NOT_CHANGED)) {
            String name = line.substring(0, line.length() - TAG_NAME_NOT_CHANGED.length()).trim();
            this.fPackageMap.put(name, name);
        } else if (splitted.length == 1) {
            this.fPackageMap.put(splitted[0].trim(), "");
        } else {
            this.error("Unable to parse package line: " + aLine);
        }
    }

    protected void parseClass(String aLine) {
        String line = aLine.substring(TAG_CLASS.length(), aLine.length()).replace('\t', ' ').trim();
        String[] splitted = line.split(TAG_DELIMITER);
        if (splitted.length == 2) {
            this.fClassMap.put(this.parseClassName(splitted[0].trim()), splitted[1].trim());
        } else if (splitted.length == 1 && line.endsWith(TAG_NAME_NOT_CHANGED)) {
            String name = this.parseClassName(line.substring(0, line.length() - TAG_NAME_NOT_CHANGED.length()).trim());
            this.fClassMap.put(name, name);
        } else {
            this.error("Unable to parse class line: " + aLine);
        }
    }

    protected String parseClassName(String aName) {
        String[] splitted = aName.split(" ");
        return splitted[splitted.length - 1];
    }

    public static class Provider
    implements ObfuscationUtils.Provider {
        public static final String ID = "ZKM";

        public ObfuscationUtils create(File aChangeLogFile) {
            return new ZKMObfuscationUtils(aChangeLogFile);
        }

        public String getID() {
            return ID;
        }

        public String getName() {
            return "Zelix KlassMaster";
        }

        public String toString() {
            return this.getName();
        }

        public String getDescription() {
            return null;
        }
    }
}

