/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.utils.obfuscation;

import com.jp.protection.utils.obfuscation.BasicObfuscationUtils;
import com.jp.protection.utils.obfuscation.ObfuscationUtils;
import dev.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class RetroGuardObfuscationUtils
extends BasicObfuscationUtils {
    public static final String TAG_PACKAGE = ".repackage_map";
    public static final String TAG_CLASS = ".class_map";
    public static final String TAG_DELIMITER = " ";

    public RetroGuardObfuscationUtils(File aChangeLogFile) {
        super(aChangeLogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseImpl() {
        try {
            FileInputStream stream = new FileInputStream(this.fChangeLogFile);
            try {
                this.parse(stream);
            }
            finally {
                ((InputStream)stream).close();
            }
        }
        catch (Exception ex) {
            this.error(ex);
            throw new IllegalStateException("Unable to parse change log file: " + this.fChangeLogFile.getAbsolutePath());
        }
    }

    protected void parse(InputStream aStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(aStream));
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith(TAG_PACKAGE)) {
                this.parsePackage(line);
            } else if (line.startsWith(TAG_CLASS)) {
                this.parseClass(line);
            }
            line = reader.readLine();
        }
    }

    private void parseClass(String aLine) {
        String line = aLine.substring(TAG_CLASS.length(), aLine.length()).replace('\t', ' ').trim();
        String[] splitted = line.split(TAG_DELIMITER);
        if (splitted.length == 2) {
            String className = splitted[0].trim().replace('/', '.');
            String packageName = "";
            int index = className.lastIndexOf(".");
            if (index != -1) {
                packageName = className.substring(0, index);
            }
            String newPackageName = this.getPackageName(packageName);
            String newClassName = splitted[1].trim().replace('/', '.');
            if (!StringUtils.noValue(newPackageName)) {
                newClassName = newPackageName + '.' + newClassName;
            }
            this.fClassMap.put(className, newClassName);
        } else {
            this.error("Unable to parse class line: " + aLine);
        }
    }

    private void parsePackage(String aLine) {
        String line = aLine.substring(TAG_PACKAGE.length(), aLine.length()).replace('\t', ' ').trim();
        String[] splitted = line.split(TAG_DELIMITER);
        if (splitted.length == 2) {
            this.fPackageMap.put(splitted[0].trim().replace('/', '.'), splitted[1].trim().replace('/', '.'));
        } else {
            this.error("Unable to parse package line: " + aLine);
        }
    }

    public static void main(String[] args) {
        try {
            RetroGuardObfuscationUtils utils = new RetroGuardObfuscationUtils(new File("E:\\DevTools\\RetroGuard\\retroguard-v2.2.0\\retroguard.log"));
            System.out.println("com/jgoodies/plaf/plastic/PlasticXPIconFactory -> " + utils.getClassName("com/jgoodies/plaf/plastic/PlasticXPIconFactory"));
            System.out.println("com/jgoodies/plaf/plastic/theme/SkyBluer -> " + utils.getClassName("com.jgoodies.plaf.plastic.theme.SkyBluer"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class Provider
    implements ObfuscationUtils.Provider {
        public static final String ID = "RetroGuard";

        public ObfuscationUtils create(File aChangeLogFile) {
            return new RetroGuardObfuscationUtils(aChangeLogFile);
        }

        public String getID() {
            return ID;
        }

        public String getName() {
            return ID;
        }

        public String toString() {
            return this.getName();
        }

        public String getDescription() {
            return null;
        }
    }
}

