/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.utils.obfuscation;

import com.jp.protection.utils.obfuscation.ObfuscationUtils;
import dev.util.HashDualMap;
import java.io.File;
import java.util.HashMap;

public abstract class BasicObfuscationUtils
implements ObfuscationUtils {
    protected File fChangeLogFile;
    protected boolean fParsed = false;
    protected HashMap fPackageMap = new HashMap();
    protected HashDualMap fClassMap = new HashDualMap();

    public BasicObfuscationUtils(File aChangeLogFile) {
        this.fChangeLogFile = aChangeLogFile;
    }

    protected final void parse() {
        if (!this.fParsed) {
            this.fParsed = true;
            this.parseImpl();
        }
    }

    protected abstract void parseImpl();

    protected void error(String aMessage) {
        System.err.println(aMessage);
    }

    protected void error(Throwable aThrowable) {
        aThrowable.printStackTrace();
    }

    public String getOriginalClassName(String aName) {
        this.parse();
        return (String)this.fClassMap.getKey(aName);
    }

    public String getPackageName(String aName) {
        this.parse();
        String result = (String)this.fPackageMap.get(aName);
        return result != null ? result : aName;
    }

    public String getClassName(String aName) {
        String name = aName;
        if (name.indexOf(47) != -1) {
            name = name.replace('/', '.');
        }
        if (name.indexOf(92) != -1) {
            name = name.replace('\\', '.');
        }
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        this.parse();
        String result = (String)this.fClassMap.get(name);
        return result != null ? result : name;
    }

    public String getResourceName(String aName) {
        this.parse();
        String name = aName.replace('\\', '/');
        int index = name.lastIndexOf(47);
        String packageName = "";
        String resName = aName;
        if (index != -1) {
            packageName = name.substring(0, index);
            if (packageName.startsWith("/")) {
                packageName = packageName.substring(1, packageName.length());
            }
            resName = name.substring(index + 1, name.length());
        }
        if (!"".equals(packageName) && !"".equals(packageName = this.getPackageName(packageName.replace('/', '.')))) {
            packageName = "/" + packageName.replace('.', '/');
        }
        return !"".equals(packageName) ? packageName + "/" + resName : resName;
    }
}

