/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.utils;

import com.jp.protection.utils.ProtectionLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProtectionLoggerImpl
implements ProtectionLogger {
    protected Logger fLogger;

    public ProtectionLoggerImpl(Logger aLogger) {
        this.fLogger = aLogger;
    }

    public Logger getLogger() {
        return this.fLogger;
    }

    public ProtectionLoggerImpl(String aLoggerName, int aLevel) {
        this(Logger.getLogger(aLoggerName));
        this.setLevel(aLevel);
    }

    public int getLevel() {
        int result = 20000;
        Level level = this.fLogger.getLevel();
        if (level == Level.ALL) {
            result = Integer.MIN_VALUE;
        } else if (level == Level.OFF) {
            result = Integer.MAX_VALUE;
        } else if (level == Level.SEVERE) {
            result = 50000;
        } else if (level == Level.WARNING) {
            result = 30000;
        } else if (level == Level.INFO) {
            result = 20000;
        } else if (level == Level.FINE) {
            result = 10000;
        }
        return result;
    }

    public void setLevel(int aLevel) {
        Level level = Level.INFO;
        switch (aLevel) {
            case -2147483648: {
                level = Level.ALL;
                break;
            }
            case 0x7FFFFFFF: {
                level = Level.OFF;
                break;
            }
            case 50000: {
                level = Level.SEVERE;
                break;
            }
            case 40000: {
                level = Level.SEVERE;
                break;
            }
            case 30000: {
                level = Level.WARNING;
                break;
            }
            case 20000: {
                level = Level.INFO;
                break;
            }
            case 10000: {
                level = Level.FINE;
            }
        }
        this.fLogger.setLevel(level);
    }

    protected void log(Level aLevel, String aMessage, Throwable aThrowable) {
        this.getLogger().log(aLevel, aMessage, aThrowable);
    }

    protected void log(Level aLevel, String aMessage) {
        this.getLogger().log(aLevel, aMessage);
    }

    public void entering(String aClass, String aMethod) {
        this.getLogger().entering(aClass, aMethod);
    }

    public void exiting(String aClass, String aMethod) {
        this.getLogger().exiting(aClass, aMethod);
    }

    public void fatal(Object message, Throwable t) {
        this.error(message, t);
    }

    public void fatal(Object message) {
        this.error(message);
    }

    public void error(Object message, Throwable t) {
        this.log(Level.SEVERE, message != null ? message.toString() : null, t);
    }

    public void error(Object message) {
        this.log(Level.SEVERE, message != null ? message.toString() : null);
    }

    public void warning(Object message, Throwable t) {
        this.log(Level.WARNING, message != null ? message.toString() : null);
    }

    public void warning(Object message) {
        this.log(Level.WARNING, message != null ? message.toString() : null);
    }

    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message != null ? message.toString() : null);
    }

    public void info(Object message) {
        this.log(Level.INFO, message != null ? message.toString() : null);
    }

    public void debug(Object message, Throwable t) {
        this.log(Level.FINER, message != null ? message.toString() : null, t);
    }

    public void debug(Object message) {
        this.log(Level.FINER, message != null ? message.toString() : null);
    }
}

