/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.utils;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseImpl;
import com.jp.util.IndexedPropertiesSupport;
import dev.entities.Customer;
import dev.util.PropertiesUtil;
import dev.util.StringUtils;
import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.Preferences;

public class LicenseUtils {
    public static final String PROPERTY_LICENSE_NUMBER = "num";
    public static final String PROPERTY_LICENSE_TYPE = "typ";
    public static final String PROPERTY_LICENSE_OPTIONS = "opt";
    public static final String PROPERTY_LICENSE_EXPIRE_DATE = "exd";
    public static final String PROPERTY_LICENSE_ISSUE_DATE = "isd";
    public static final String PROPERTY_NUMBER_COPIES = "nuc";
    public static final String PROPERTY_GRACE_PERIOD = "gp";
    public static final String PROPERTY_PRODUCT = "pro";
    public static final String PROPERTY_PRODUCT_EDITION = "pre";
    public static final String PROPERTY_PRODUCT_MAJOR_VERSION = "maj";
    public static final String PROPERTY_PRODUCT_MINOR_VERSION = "min";
    public static final String PROPERTY_PRODUCT_FEATURE = "fea";
    public static final String PROPERTY_PRODUCT_FEATURE_COUNT = "fcnt";
    public static final String PROPERTY_USER_LICENSING_MODEL = "ulm";
    public static final String PROPERTY_LICENSE_PROP = "prop";
    public static final String PROPERTY_LICENSE_PROP_NAME = "n";
    public static final String PROPERTY_LICENSE_PROP_VALUE = "v";
    public static final String PROPERTY_LICENSE_TEXT = "txt";
    public static final String PATTERN_TRUE = "true";
    public static final String PATTERN_FALSE = "false";
    public static final String FEATURE_NAME_VALUE_DELIMITER = " - ";
    public static final String FEATURE_VALUE_DELIMITER = ",";
    private static final Set PROTECTION_LICENSE_PROPERIES = new HashSet();
    public static final String ARGUMENT_LICENSE_PROPERTY_FREFIX = "$licenseProperty$";
    public static final String ARGUMENT_LICENSE_FEATURE_PREFIX = "$licenseFeature$";
    public static final String ARGUMENT_LICENSE_EULA = "$licenseEULA$";
    public static final String ARGUMENT_LICENSE_USER_MODEL = "$licenseUserModel$";
    public static final String BYTE_DELIMITER = ",";
    public static final String LONG_DELIMITER = ",";

    public static void save(License aLicense, Properties aProperties) {
        if (aLicense.getLicenseNumber() != null) {
            aProperties.setProperty(PROPERTY_LICENSE_NUMBER, aLicense.getLicenseNumber());
        }
        aProperties.setProperty(PROPERTY_LICENSE_TYPE, String.valueOf(aLicense.getLicenseType()));
        aProperties.setProperty(PROPERTY_LICENSE_OPTIONS, String.valueOf(aLicense.getLicenseOptions()));
        if (aLicense.getLicenseIssueDate() != null) {
            aProperties.setProperty(PROPERTY_LICENSE_ISSUE_DATE, String.valueOf(aLicense.getLicenseIssueDate().getTime()));
        }
        if (aLicense.getLicenseExpireDate() != null) {
            aProperties.setProperty(PROPERTY_LICENSE_EXPIRE_DATE, String.valueOf(aLicense.getLicenseExpireDate().getTime()));
        }
        aProperties.setProperty(PROPERTY_NUMBER_COPIES, String.valueOf(aLicense.getNumberCopies()));
        aProperties.setProperty(PROPERTY_GRACE_PERIOD, String.valueOf(aLicense.getGracePeriod()));
        if (aLicense.getProduct() != null) {
            aProperties.setProperty(PROPERTY_PRODUCT, aLicense.getProduct());
        }
        if (aLicense.getProductEdition() != null) {
            aProperties.setProperty(PROPERTY_PRODUCT_EDITION, aLicense.getProductEdition());
        }
        aProperties.setProperty(PROPERTY_PRODUCT_MAJOR_VERSION, String.valueOf(aLicense.getProductMajorVersion()));
        aProperties.setProperty(PROPERTY_PRODUCT_MINOR_VERSION, String.valueOf(aLicense.getProductMinorVersion()));
        if (aLicense.getLicenseText() != null) {
            aProperties.setProperty(PROPERTY_LICENSE_TEXT, aLicense.getLicenseText());
        }
        aProperties.setProperty(PROPERTY_USER_LICENSING_MODEL, String.valueOf(aLicense.getUserLicensingModel()));
        LicenseUtils.saveLicenseFeatures(aLicense, aProperties);
        LicenseUtils.saveLicenseProperties(aLicense, aProperties);
    }

    private static void saveLicenseProperties(License aLicense, Properties aProperties) {
        IndexedPropertiesSupport indexedPropertiesSupport = new IndexedPropertiesSupport(aProperties);
        indexedPropertiesSupport.setIndexName(PROPERTY_LICENSE_PROP);
        indexedPropertiesSupport.setItemCount(aLicense.getPropertyNames().size());
        int index = 0;
        Iterator iterator = aLicense.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            indexedPropertiesSupport.setIndex(index++);
            indexedPropertiesSupport.setProperty(PROPERTY_LICENSE_PROP_NAME, name);
            indexedPropertiesSupport.setProperty(PROPERTY_LICENSE_PROP_VALUE, aLicense.getProperty(name, ""));
        }
    }

    private static void saveLicenseFeatures(License aLicense, Properties aProperties) {
        Collection productFeatureNames = aLicense.getProductFeatureNames();
        if (productFeatureNames.size() > 0) {
            aProperties.setProperty(PROPERTY_PRODUCT_FEATURE_COUNT, String.valueOf(productFeatureNames.size()));
            Iterator iterator = productFeatureNames.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                String productFeature = (String)iterator.next();
                StringBuffer enabledValues = new StringBuffer();
                for (int j = 0; j <= 4; ++j) {
                    if (j > 0) {
                        enabledValues.append(",");
                    }
                    enabledValues.append(aLicense.isProductFeatureSupported(productFeature, j) ? PATTERN_TRUE : PATTERN_FALSE);
                }
                enabledValues.insert(0, FEATURE_NAME_VALUE_DELIMITER);
                enabledValues.insert(0, productFeature);
                aProperties.setProperty("fea[" + i + "]", enabledValues.toString());
                ++i;
            }
        }
    }

    public static void load(License aLicense, Properties aProperties) {
        LicenseImpl license = (LicenseImpl)aLicense;
        license.setLicenseNumber(aProperties.getProperty(PROPERTY_LICENSE_NUMBER));
        license.setLicenseType(Integer.parseInt(aProperties.getProperty(PROPERTY_LICENSE_TYPE)));
        license.setLicenseOptions(Integer.parseInt(aProperties.getProperty(PROPERTY_LICENSE_OPTIONS, "0")));
        String property = aProperties.getProperty(PROPERTY_LICENSE_ISSUE_DATE);
        if (property != null) {
            license.setLicenseIssueDate(new Date(Long.parseLong(property)));
        }
        if ((property = aProperties.getProperty(PROPERTY_LICENSE_EXPIRE_DATE)) != null) {
            license.setLicenseExpireDate(new Date(Long.parseLong(property)));
        }
        license.setNumberCopies(Integer.parseInt(aProperties.getProperty(PROPERTY_NUMBER_COPIES)));
        license.setGracePeriod(Integer.parseInt(aProperties.getProperty(PROPERTY_GRACE_PERIOD)));
        license.setProduct(aProperties.getProperty(PROPERTY_PRODUCT));
        license.setProductEdition(aProperties.getProperty(PROPERTY_PRODUCT_EDITION));
        license.setProductMajorVersion(Integer.parseInt(aProperties.getProperty(PROPERTY_PRODUCT_MAJOR_VERSION)));
        license.setProductMinorVersion(Integer.parseInt(aProperties.getProperty(PROPERTY_PRODUCT_MINOR_VERSION)));
        license.setLicenseText(aProperties.getProperty(PROPERTY_LICENSE_TEXT));
        license.setUserLicensingModel(Integer.parseInt(aProperties.getProperty(PROPERTY_USER_LICENSING_MODEL, String.valueOf(0))));
        LicenseUtils.loadProductFeatures(license, aProperties);
        LicenseUtils.loadProductProperties(license, aProperties);
    }

    private static void loadProductProperties(LicenseImpl license, Properties aProperties) {
        IndexedPropertiesSupport indexedPropertiesSupport = new IndexedPropertiesSupport(aProperties);
        indexedPropertiesSupport.setIndexName(PROPERTY_LICENSE_PROP);
        int count = indexedPropertiesSupport.getItemCount();
        for (int i = 0; i < count; ++i) {
            indexedPropertiesSupport.setIndex(i);
            license.putProperty(indexedPropertiesSupport.getProperty(PROPERTY_LICENSE_PROP_NAME), indexedPropertiesSupport.getProperty(PROPERTY_LICENSE_PROP_VALUE));
        }
    }

    private static void loadProductFeatures(LicenseImpl license, Properties aProperties) throws NumberFormatException {
        int productFeaturesCount = Integer.parseInt(aProperties.getProperty(PROPERTY_PRODUCT_FEATURE_COUNT, "0"));
        for (int i = 0; i < productFeaturesCount; ++i) {
            String productFeature = aProperties.getProperty("fea[" + i + "]");
            int index = productFeature.indexOf(FEATURE_NAME_VALUE_DELIMITER);
            if (index == -1) continue;
            String productFeatureName = productFeature.substring(0, index);
            String[] productFeatureValues = productFeature.substring(index + FEATURE_NAME_VALUE_DELIMITER.length(), productFeature.length()).split(",");
            Boolean[] values = new Boolean[productFeatureValues.length];
            if (values.length == 1) {
                license.getProductFeaturesMap().put(productFeatureName, productFeatureValues[0].equals(PATTERN_TRUE) ? Boolean.TRUE : Boolean.FALSE);
                continue;
            }
            for (int j = 0; j < productFeatureValues.length; ++j) {
                values[j] = productFeatureValues[j].equals(PATTERN_TRUE) ? Boolean.TRUE : Boolean.FALSE;
            }
            license.getProductFeaturesMap().put(productFeatureName, values);
        }
    }

    public static Preferences getCustomerPreferences(String aProduct) {
        return Preferences.userRoot().node(aProduct + "/CustomerData");
    }

    public static int getTimeZoneOffset(Calendar aCalendar) {
        return (aCalendar.get(15) + aCalendar.get(16)) / 60000;
    }

    public static Date getLicenseIssueDate(Date aDate) {
        Calendar calendar = Calendar.getInstance();
        if (aDate != null) {
            calendar.setTime(aDate);
        }
        return LicenseUtils.getLicenseIssueDate(calendar);
    }

    public static Date getLicenseIssueDate(Calendar aCalendar) {
        aCalendar.set(11, 0);
        aCalendar.set(12, 1);
        aCalendar.set(13, 0);
        aCalendar.set(14, 0);
        return aCalendar.getTime();
    }

    public static Date getLicenseExpirationDate() {
        return LicenseUtils.getLicenseExpirationDate(Calendar.getInstance());
    }

    public static Date getLicenseExpirationDate(Date aDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(aDate);
        return LicenseUtils.getLicenseExpirationDate(calendar);
    }

    public static Date getLicenseExpirationDate(Calendar aCalendar) {
        aCalendar.set(11, 23);
        aCalendar.set(12, 59);
        aCalendar.set(13, 59);
        aCalendar.set(14, 0);
        return aCalendar.getTime();
    }

    public static boolean isProtectionLicenseProperty(String aName) {
        return PROTECTION_LICENSE_PROPERIES.contains(aName);
    }

    protected static String getPrefixedLicensePropertyName(String aName) {
        return ARGUMENT_LICENSE_PROPERTY_FREFIX + aName;
    }

    protected static boolean isPrefixedLicensePropertyName(String aName) {
        return aName.startsWith(ARGUMENT_LICENSE_PROPERTY_FREFIX);
    }

    protected static String getLicensePropertyName(String aPrefixedName) {
        return aPrefixedName.substring(ARGUMENT_LICENSE_PROPERTY_FREFIX.length(), aPrefixedName.length());
    }

    protected static String getPrefixedLicenseFeatureName(String aName) {
        return ARGUMENT_LICENSE_FEATURE_PREFIX + aName;
    }

    protected static boolean isPrefixedLicenseFeatureName(String aName) {
        return aName.startsWith(ARGUMENT_LICENSE_FEATURE_PREFIX);
    }

    protected static String getLicenseFeatureName(String aPrefixedName) {
        return aPrefixedName.substring(ARGUMENT_LICENSE_FEATURE_PREFIX.length(), aPrefixedName.length());
    }

    public static void properties2Arguments(Map anArguments, Map aLicenseProperties) {
        Iterator iterator = aLicenseProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            anArguments.put(LicenseUtils.getPrefixedLicensePropertyName(name), aLicenseProperties.get(name));
        }
    }

    public static void arguments2Properties(Map anArguments, Map aLicenseProperties) {
        Iterator iterator = anArguments.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!LicenseUtils.isPrefixedLicensePropertyName(name)) continue;
            aLicenseProperties.put(LicenseUtils.getLicensePropertyName(name), anArguments.get(name));
        }
    }

    public static void features2Arguments(Map anArguments, Map aLicenseFeatures) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = aLicenseFeatures.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.setLength(0);
            String name = (String)iterator.next();
            Object values = aLicenseFeatures.get(name);
            if (values instanceof Boolean) {
                stringBuffer.append(LicenseUtils.boolean2String((Boolean)values));
            } else {
                Boolean[] featureValues = (Boolean[])values;
                for (int i = 0; i < featureValues.length; ++i) {
                    Boolean value = featureValues[i];
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(LicenseUtils.boolean2String(value));
                }
            }
            anArguments.put(LicenseUtils.getPrefixedLicenseFeatureName(name), stringBuffer.toString());
        }
    }

    public static void arguments2Features(Map anArguments, Map aLicenseFeatures) {
        Iterator iterator = anArguments.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!LicenseUtils.isPrefixedLicenseFeatureName(name)) continue;
            String[] featureValuesStr = ((String)anArguments.get(name)).split(",");
            Boolean[] featureValues = new Boolean[featureValuesStr.length];
            for (int i = 0; i < featureValuesStr.length; ++i) {
                featureValues[i] = LicenseUtils.string2Boolean(featureValuesStr[i]);
            }
            aLicenseFeatures.put(LicenseUtils.getLicenseFeatureName(name), featureValues);
        }
    }

    private static Boolean string2Boolean(String aValue) {
        return "1".equals(aValue) ? Boolean.TRUE : Boolean.FALSE;
    }

    private static String boolean2String(Boolean aValue) {
        return Boolean.TRUE.equals(aValue) ? "1" : "0";
    }

    public static String toString(byte[] aBytes) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < aBytes.length; ++i) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(aBytes[i]);
        }
        return result.toString();
    }

    public static byte[] toBytes(String aBytes) {
        String[] bytes = aBytes.split(",");
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = Byte.parseByte(bytes[i].trim());
        }
        return result;
    }

    public static String toString(long[] aLongs) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < aLongs.length; ++i) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(aLongs[i]);
        }
        return result.toString();
    }

    public static long[] toLongs(String aLongs) {
        String[] longs = aLongs.split(",");
        long[] result = new long[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            result[i] = Long.parseLong(longs[i].trim());
        }
        return result;
    }

    protected static void putProperty(LicenseImpl aLicense, String aName, String aValue) {
        if (!StringUtils.noValue(aValue)) {
            aLicense.getProperties().put(aName, aValue);
        } else {
            aLicense.getProperties().remove(aName);
        }
    }

    public static void fromLicense(License aLicense, Customer aCustomer) {
        aCustomer.setFirstName(aLicense.getProperty("pr.firstName", null));
        aCustomer.setLastName(aLicense.getProperty("pr.lastName", null));
        aCustomer.setTitle(aLicense.getProperty("pr.title", null));
        aCustomer.setCompany(aLicense.getProperty("pr.company", null));
        aCustomer.setPhone(aLicense.getProperty("pr.phone", null));
        aCustomer.setEmail(aLicense.getProperty("pr.email", null));
        aCustomer.setAddress(aLicense.getProperty("pr.address", null));
        aCustomer.setCity(aLicense.getProperty("pr.city", null));
        aCustomer.setZip(aLicense.getProperty("pr.zip", null));
        aCustomer.setState(aLicense.getProperty("pr.state", null));
        aCustomer.setCountry(aLicense.getProperty("pr.country", null));
    }

    public static void toLicense(LicenseImpl aLicense, Customer aCustomer) {
        LicenseUtils.putProperty(aLicense, "pr.firstName", aCustomer.getFirstName());
        LicenseUtils.putProperty(aLicense, "pr.lastName", aCustomer.getLastName());
        LicenseUtils.putProperty(aLicense, "pr.title", aCustomer.getTitle());
        LicenseUtils.putProperty(aLicense, "pr.company", aCustomer.getCompany());
        LicenseUtils.putProperty(aLicense, "pr.phone", aCustomer.getPhone());
        LicenseUtils.putProperty(aLicense, "pr.email", aCustomer.getEmail());
        LicenseUtils.putProperty(aLicense, "pr.address", aCustomer.getAddress());
        LicenseUtils.putProperty(aLicense, "pr.city", aCustomer.getCity());
        LicenseUtils.putProperty(aLicense, "pr.zip", aCustomer.getZip());
        LicenseUtils.putProperty(aLicense, "pr.state", aCustomer.getState());
        LicenseUtils.putProperty(aLicense, "pr.country", aCustomer.getCountry());
    }

    public static String toHexString(String aMACAddress) {
        return LicenseUtils.toHexString(Long.parseLong(aMACAddress));
    }

    public static String toHexString(long[] aMACAddresses) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < aMACAddresses.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LicenseUtils.toHexString(aMACAddresses[i]));
        }
        return result.toString();
    }

    public static String toHexString(long aMACAddress) {
        StringBuffer result = new StringBuffer(Long.toHexString(aMACAddress).toUpperCase());
        while (result.length() < 12) {
            result.insert(0, "0");
        }
        for (int i = 2; i < result.length(); i += 2) {
            result.insert(i++, "-");
        }
        return result.toString();
    }

    public static long fromHexString(String aMACAddress) {
        String addr = aMACAddress.replaceAll("-", "");
        return Long.parseLong(addr, 16);
    }

    public static long[] fromHexStrings(String aMACAddress) {
        String[] strs = aMACAddress.split(",");
        long[] result = new long[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result[i] = LicenseUtils.fromHexString(strs[i].trim());
        }
        return result;
    }

    public static void checkJRE() throws IllegalStateException {
        String javaVmName = System.getProperty("java.vm.name");
        if (javaVmName.equals("BEA JRockit(R)")) {
            throw new IllegalStateException("The JVM is not supported: " + javaVmName);
        }
        String javaRuntimeVersion = System.getProperty("java.runtime.version");
        int minorVersion = Integer.parseInt(javaRuntimeVersion.substring(2, 3));
        int buildVersion = Integer.parseInt(javaRuntimeVersion.substring(4, 5));
        if (minorVersion < 4 || minorVersion == 4 && buildVersion < 2) {
            throw new IllegalStateException("The JVM version is not supported: " + javaRuntimeVersion);
        }
    }

    public static void checkJRELibExt() throws IllegalStateException {
        String javaExtDirs = System.getProperty("java.ext.dirs");
        if (javaExtDirs != null) {
            String[] javaExtDirsA = javaExtDirs.split(";");
            for (int j = 0; j < javaExtDirsA.length; ++j) {
                File[] files = new File(javaExtDirsA[j]).listFiles();
                for (int i = 0; files != null && i < files.length; ++i) {
                    String fileName = files[i].getName();
                    if (!"Protection.jar".equals(fileName) && !"ProtectionPriv.jar".equals(fileName) && !"jug.jar".equals(fileName) && !fileName.matches("(jce|bcprov)-jdk[0-9]{2}-[1-9]{3}.jar")) continue;
                    throw new IllegalStateException(files[i].getAbsolutePath() + "\nlibrary must not be located in the lib/ext folder of the JRE." + "\nThe presence of this library may prevent Protection! from working properly.");
                }
            }
        }
    }

    static {
        PROTECTION_LICENSE_PROPERIES.add("pr.ak");
        PROTECTION_LICENSE_PROPERIES.add("pr.agp");
        PROTECTION_LICENSE_PROPERIES.add("pr.s/n");
        PROTECTION_LICENSE_PROPERIES.add("pr.usl");
        PROTECTION_LICENSE_PROPERIES.add("pr.ugp");
        PROTECTION_LICENSE_PROPERIES.add("pr.lsaddr");
        PROTECTION_LICENSE_PROPERIES.add("pr.lgp");
        PROTECTION_LICENSE_PROPERIES.add("pr.firstName");
        PROTECTION_LICENSE_PROPERIES.add("pr.lastName");
        PROTECTION_LICENSE_PROPERIES.add("pr.title");
        PROTECTION_LICENSE_PROPERIES.add("pr.company");
        PROTECTION_LICENSE_PROPERIES.add("pr.phone");
        PROTECTION_LICENSE_PROPERIES.add("pr.email");
        PROTECTION_LICENSE_PROPERIES.add("pr.address");
        PROTECTION_LICENSE_PROPERIES.add("pr.city");
        PROTECTION_LICENSE_PROPERIES.add("pr.zip");
        PROTECTION_LICENSE_PROPERIES.add("pr.state");
        PROTECTION_LICENSE_PROPERIES.add("pr.country");
        PropertiesUtil.addPrefix(new Properties(), "a");
    }
}

