/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.security;

import com.jp.protection.security.BouncyCastleSecurityProvider;
import com.jp.protection.security.RSASecurityProvider;
import com.jp.protection.security.SecurityProvider;
import dev.util.HashedListStrategy;
import dev.util.collections.HashedBoundList;
import java.util.ArrayList;
import java.util.List;

public class SecurityProviderFactory {
    private static HashedBoundList fSecurityProviders = new HashedBoundList(new ArrayList(), new HashedListStrategy(){

        public Object getKeyForObject(Object anObject) {
            return ((SecurityProvider)anObject).getID();
        }
    });
    protected static SecurityProvider fDefaultSecurityProvider;

    public static boolean isLegacySecurityProvider(SecurityProvider aSecurityProvider) {
        return aSecurityProvider instanceof RSASecurityProvider;
    }

    public static SecurityProvider getDefaultSecurityProvider() {
        return fDefaultSecurityProvider;
    }

    public static List getSecurityProviders() {
        return fSecurityProviders;
    }

    public static void registerSecurityProvider(SecurityProvider aProvider) {
        fSecurityProviders.add(aProvider);
    }

    public static void unRegisterSecurityProvider(String anAlgorithm) {
        fSecurityProviders.remove(SecurityProviderFactory.getSecurityProvider(anAlgorithm));
    }

    public static SecurityProvider getSecurityProvider(String anAlgorithm) {
        return (SecurityProvider)fSecurityProviders.get(anAlgorithm);
    }

    static {
        SecurityProviderFactory.registerSecurityProvider(new RSASecurityProvider());
        for (int i = 0; i < BouncyCastleSecurityProvider.SUPPORTED_KEY_LENGTHS.length; ++i) {
            BouncyCastleSecurityProvider provider = new BouncyCastleSecurityProvider(BouncyCastleSecurityProvider.SUPPORTED_KEY_LENGTHS[i]);
            SecurityProviderFactory.registerSecurityProvider(provider);
            if (fDefaultSecurityProvider != null || BouncyCastleSecurityProvider.SUPPORTED_KEY_LENGTHS[i] != 512) continue;
            fDefaultSecurityProvider = provider;
        }
        if (fDefaultSecurityProvider == null) {
            fDefaultSecurityProvider = (SecurityProvider)SecurityProviderFactory.getSecurityProviders().get(SecurityProviderFactory.getSecurityProviders().size() - 1);
        }
    }
}

