/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.security;

import com.jp.protection.security.SecurityProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

class RSASecurityProvider
implements SecurityProvider {
    public static final String NAME = "Version 1";
    public static final String ID = "RSA";
    private KeyPairGeneratorRSA fKeyPairGenerator;
    private static final int[] SUPPORTED_KEY_LENGTHS = new int[]{64, 128, 256};

    RSASecurityProvider() {
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encode(byte[] aData, PrivateKey aPrivateKey) {
        byte[] result = null;
        try {
            BigInteger[] encoded = RSASecurityProvider.encode(aData, (BasicKey)((Object)aPrivateKey));
            int resultSize = 0;
            for (int i = 0; i < encoded.length; ++i) {
                BigInteger bigInteger = encoded[i];
                resultSize += bigInteger.bitLength() / 8 + 1 + 4;
            }
            byte[][] encodedArray = new byte[encoded.length][];
            for (int i = 0; i < encoded.length; ++i) {
                encodedArray[i] = encoded[i].toByteArray();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                try {
                    objectOutputStream.writeObject(encodedArray);
                }
                finally {
                    objectOutputStream.close();
                }
                result = byteArrayOutputStream.toByteArray();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    private static BigInteger[] encode(byte[] aData, BasicKey aKey) throws ArithmeticException {
        byte[] keyExponentBytes = aKey.getKey().toByteArray();
        byte[] keyModuloBytes = aKey.getModulo().toByteArray();
        BigInteger[] bigdigits = new BigInteger[aData.length];
        for (int i = 0; i < bigdigits.length; ++i) {
            byte[] temp = new byte[]{aData[i]};
            bigdigits[i] = new BigInteger(temp);
        }
        BigInteger[] encrypted = new BigInteger[bigdigits.length];
        BigInteger publicKeyExponent = new BigInteger(keyExponentBytes);
        BigInteger publicKeyModulo = new BigInteger(keyModuloBytes);
        for (int j = 0; j < bigdigits.length; ++j) {
            encrypted[j] = bigdigits[j].modPow(publicKeyExponent, publicKeyModulo);
        }
        return encrypted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decode(byte[] aData, PublicKey aPublicKey) {
        byte[] result = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(aData);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                byte[][] arrayData = (byte[][])objectInputStream.readObject();
                BigInteger[] encrypted = new BigInteger[arrayData.length];
                for (int i = 0; i < arrayData.length; ++i) {
                    encrypted[i] = new BigInteger(arrayData[i]);
                }
                result = RSASecurityProvider.decrypt(encrypted, (BasicKey)((Object)aPublicKey));
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            finally {
                objectInputStream.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static byte[] decrypt(BigInteger[] encrypted, BasicKey aKey) throws ArithmeticException {
        BigInteger[] decrypted = new BigInteger[encrypted.length];
        for (int i = 0; i < decrypted.length; ++i) {
            decrypted[i] = new BigInteger(encrypted[i].toString()).modPow(aKey.getKey(), aKey.getModulo());
        }
        byte[] array = new byte[decrypted.length];
        for (int j = 0; j < array.length; ++j) {
            array[j] = decrypted[j].byteValue();
        }
        return array;
    }

    public KeyPair generateKeyPair() {
        if (this.fKeyPairGenerator == null) {
            this.fKeyPairGenerator = new KeyPairGeneratorRSA(128);
        }
        return this.fKeyPairGenerator.generateKeyPair();
    }

    public byte[] getPrivateKeyData(PrivateKey aPrivateKey) {
        return this.getKeyData((BasicKey)((Object)aPrivateKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey getPrivateKey(byte[] aKeyData) {
        PrivateKeyRSA result = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(aKeyData);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                BigInteger privateKey = (BigInteger)objectInputStream.readObject();
                BigInteger modulo = (BigInteger)objectInputStream.readObject();
                result = new PrivateKeyRSA(privateKey, modulo);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            finally {
                objectInputStream.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public byte[] getPublicKeyData(PublicKey aPublicKey) {
        return this.getKeyData((BasicKey)((Object)aPublicKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getKeyData(BasicKey aKey) {
        byte[] result = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(aKey.getKey());
                objectOutputStream.writeObject(aKey.getModulo());
            }
            finally {
                objectOutputStream.close();
            }
            result = byteArrayOutputStream.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey getPublicKey(byte[] aKeyData) {
        PublicKeyRSA result = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(aKeyData);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                BigInteger publicKey = (BigInteger)objectInputStream.readObject();
                BigInteger modulo = (BigInteger)objectInputStream.readObject();
                result = new PublicKeyRSA(publicKey, modulo);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            finally {
                objectInputStream.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public int[] getSupportedKeyLengths() {
        return SUPPORTED_KEY_LENGTHS;
    }

    public int getKeyLength() {
        return 128;
    }

    private static class KeyPairGeneratorRSA
    extends KeyPairGenerator {
        private static final BigInteger ONE = new BigInteger("1");
        private BigInteger N;
        private BigInteger x;
        private BigInteger y;
        private int strength;
        private SecureRandom random;

        public KeyPairGeneratorRSA() {
            this(512);
        }

        public KeyPairGeneratorRSA(int strength) {
            this(strength, null, null);
        }

        public KeyPairGeneratorRSA(int strength, BigInteger x, BigInteger y) {
            super(RSASecurityProvider.ID);
            this.initialize(strength);
            if (x == null || y == null) {
                x = new BigInteger(strength, 99, this.random);
                y = new BigInteger(strength, 99, this.random);
                while (!x.isProbablePrime(100)) {
                    x = new BigInteger(strength, 99, this.random);
                }
                while (!y.isProbablePrime(100)) {
                    y = new BigInteger(strength, 99, this.random);
                }
            }
            this.x = x;
            this.y = y;
            this.N = x.multiply(y);
        }

        public void initialize(int strength) {
            this.initialize(strength, null);
        }

        public void initialize(int strength, SecureRandom random) {
            this.setStrength(strength);
            if (random == null) {
                random = new SecureRandom();
            }
            this.random = random;
        }

        public KeyPair generateKeyPair() {
            BigInteger s = new BigInteger(this.strength, 99, this.random);
            while (!s.isProbablePrime(100)) {
                s = new BigInteger(this.strength, 99, this.random);
            }
            BigInteger p = s.modInverse(this.x.subtract(ONE).multiply(this.y.subtract(ONE)));
            return new KeyPair(new PublicKeyRSA(p, this.N, this.getAlgorithm()), new PrivateKeyRSA(s, this.N, this.getAlgorithm()));
        }

        public int getStrength() {
            return this.strength;
        }

        public void setStrength(int strength) {
            this.strength = strength;
        }
    }

    private static class PrivateKeyRSA
    extends BasicKey
    implements PrivateKey {
        public PrivateKeyRSA(BigInteger aKey, BigInteger aModulo) {
            this(aKey, aModulo, RSASecurityProvider.ID);
        }

        public PrivateKeyRSA(BigInteger aKey, BigInteger aModulo, String anAlgorithm) {
            super(aKey, aModulo, anAlgorithm);
        }
    }

    public static class PublicKeyRSA
    extends BasicKey
    implements PublicKey {
        private PublicKeyRSA(BigInteger aKey, BigInteger aModulo) {
            this(aKey, aModulo, RSASecurityProvider.ID);
        }

        private PublicKeyRSA(BigInteger aKey, BigInteger aModulo, String anAlgorithm) {
            super(aKey, aModulo, anAlgorithm);
        }
    }

    public static class BasicKey {
        private BigInteger fKey;
        private BigInteger fModulo;
        private String fAlgorithm;

        private BasicKey(BigInteger aKey, BigInteger aModulo, String anAlgorithm) {
            this.fKey = aKey;
            this.fModulo = aModulo;
            this.fAlgorithm = anAlgorithm;
        }

        public BigInteger getKey() {
            return this.fKey;
        }

        public BigInteger getModulo() {
            return this.fModulo;
        }

        public String getAlgorithm() {
            return this.fAlgorithm;
        }

        public String getFormat() {
            return null;
        }

        public byte[] getEncoded() {
            return null;
        }

        public String toString() {
            return this.toString(16);
        }

        public String toString(int radix) {
            return this.fKey.toString(radix);
        }
    }
}

