/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.security;

import com.jp.protection.security.SecurityProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.RSAKeyGenParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class BouncyCastleSecurityProvider
implements SecurityProvider {
    protected int fKeySize = 512;
    protected Cipher fCipher;
    public static final String NAME = "RSA";
    public static final String ID = "RSA";
    protected String fName = "RSA";
    protected String fID = "RSA";
    public static final int[] SUPPORTED_KEY_LENGTHS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] doFinal(Cipher aCipher, byte[] aData) throws BadPaddingException, IllegalBlockSizeException, IllegalStateException, IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            int blockSize = aCipher.getBlockSize();
            if (blockSize == 0) {
                stream.write(aCipher.doFinal(aData));
            } else {
                for (int i = 0; i < aData.length; i += blockSize) {
                    stream.write(aCipher.doFinal(aData, i, i + blockSize < aData.length ? blockSize : aData.length - i));
                }
            }
        }
        finally {
            stream.close();
        }
        return stream.toByteArray();
    }

    public BouncyCastleSecurityProvider(int aKeySize) {
        this.checkKeySize(aKeySize);
        this.fKeySize = aKeySize;
        this.fID = "RSA - " + this.fKeySize;
        this.fName = "RSA - " + this.fKeySize;
    }

    public BouncyCastleSecurityProvider() {
        this(512);
    }

    protected void checkKeySize(int aKeySize) {
        boolean isSupported = false;
        for (int i = 0; !isSupported && i < SUPPORTED_KEY_LENGTHS.length; ++i) {
            isSupported = SUPPORTED_KEY_LENGTHS[i] == aKeySize;
        }
        if (!isSupported) {
            throw new IllegalArgumentException("Illegal key size: " + aKeySize);
        }
    }

    public byte[] decode(byte[] aData, PublicKey aPublicKey) {
        try {
            Cipher cipher = this.getCipher();
            cipher.init(2, aPublicKey);
            return BouncyCastleSecurityProvider.doFinal(cipher, aData);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public byte[] encode(byte[] aData, PrivateKey aPrivateKey) {
        try {
            Cipher cipher = this.getCipher();
            cipher.init(1, aPrivateKey);
            return BouncyCastleSecurityProvider.doFinal(cipher, aData);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Cipher getCipher() throws NoSuchPaddingException, NoSuchProviderException, NoSuchAlgorithmException {
        if (this.fCipher == null) {
            this.fCipher = Cipher.getInstance("RSA/NONE/OAEPWithSHA1AndMGF1Padding", "BC");
        }
        return this.fCipher;
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA", "BC");
            gen.initialize(new RSAKeyGenParameterSpec(this.fKeySize, RSAKeyGenParameterSpec.F4), new SecureRandom());
            return gen.generateKeyPair();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getID() {
        return this.fID;
    }

    public String getName() {
        return this.fName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Key readKey(byte[] aKeyData) {
        Key result = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(aKeyData);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                result = (Key)objectInputStream.readObject();
            }
            finally {
                objectInputStream.close();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getKeyData(Key aKey) {
        byte[] result = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(aKey);
            }
            finally {
                objectOutputStream.close();
            }
            result = byteArrayOutputStream.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public PrivateKey getPrivateKey(byte[] aKeyData) {
        return (PrivateKey)BouncyCastleSecurityProvider.readKey(aKeyData);
    }

    public byte[] getPrivateKeyData(PrivateKey aPrivateKey) {
        return BouncyCastleSecurityProvider.getKeyData(aPrivateKey);
    }

    public PublicKey getPublicKey(byte[] aKeyData) {
        return (PublicKey)BouncyCastleSecurityProvider.readKey(aKeyData);
    }

    public byte[] getPublicKeyData(PublicKey aPublicKey) {
        return BouncyCastleSecurityProvider.getKeyData(aPublicKey);
    }

    public int[] getSupportedKeyLengths() {
        return SUPPORTED_KEY_LENGTHS;
    }

    public String toString() {
        return this.getName();
    }

    public int getKeyLength() {
        return this.fKeySize;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SUPPORTED_KEY_LENGTHS = new int[]{512, 1024, 2048};
    }
}

