/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;

public class NetworkCheckPacket
implements Externalizable {
    protected String fProductID;
    protected String fLicenseNumber;
    protected String fHostID;
    protected long fHostTimestamp;
    protected byte fType = 0;
    public static final byte TYPE_REQUEST = 0;
    public static final byte TYPE_RESPONSE = 1;
    protected String fSignature;

    public String getHostID() {
        return this.fHostID;
    }

    public long getHostTimestamp() {
        return this.fHostTimestamp;
    }

    public String getSignature() {
        return this.fSignature;
    }

    public byte getType() {
        return this.fType;
    }

    public String getLicenseNumber() {
        return this.fLicenseNumber;
    }

    public String getProductID() {
        return this.fProductID;
    }

    public static NetworkCheckPacket createRequest(String aProductID, String aLicenseNumber, String aSignature, String aHostID, long aHostTimestamp) {
        NetworkCheckPacket packet = new NetworkCheckPacket();
        packet.fProductID = aProductID;
        packet.fLicenseNumber = aLicenseNumber;
        packet.fType = 0;
        packet.fSignature = aSignature;
        packet.fHostID = aHostID;
        packet.fHostTimestamp = aHostTimestamp;
        return packet;
    }

    public static NetworkCheckPacket createResponse(String aProductID, String aLicenseNumber, String aSignature, String aHostID, long aHostTimestamp) {
        NetworkCheckPacket packet = new NetworkCheckPacket();
        packet.fProductID = aProductID;
        packet.fLicenseNumber = aLicenseNumber;
        packet.fType = 1;
        packet.fSignature = aSignature;
        packet.fHostID = aHostID;
        packet.fHostTimestamp = aHostTimestamp;
        return packet;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        NetworkCheckPacket.writeString(out, this.fProductID);
        NetworkCheckPacket.writeString(out, this.fLicenseNumber);
        NetworkCheckPacket.writeString(out, this.fSignature);
        out.writeByte(this.fType);
        NetworkCheckPacket.writeString(out, this.fHostID);
        out.writeLong(this.fHostTimestamp);
    }

    protected static void writeString(ObjectOutput out, String str) throws IOException {
        out.writeInt(str.length());
        out.writeBytes(str);
    }

    protected static String readString(ObjectInput in) throws IOException {
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return new String(bytes);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fProductID = NetworkCheckPacket.readString(in);
        this.fLicenseNumber = NetworkCheckPacket.readString(in);
        this.fSignature = NetworkCheckPacket.readString(in);
        this.fType = in.readByte();
        if (in.available() > 0) {
            this.fHostID = NetworkCheckPacket.readString(in);
        }
        if (in.available() > 0) {
            this.fHostTimestamp = in.readLong();
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bos);
        this.writeExternal(os);
        os.flush();
        return bos.toByteArray();
    }

    public void fromByteArray(byte[] aBytes, int offset, int length) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(aBytes, offset, length);
        ObjectInputStream is = new ObjectInputStream(bis);
        this.readExternal(is);
    }
}

