/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.network;

import com.jp.protection.pub.pro.network.NetworkCheckListener;
import com.jp.protection.pub.pro.network.NetworkCheckPacket;
import dev.util.StringUtils;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Vector;

public class NetworkCheck {
    public static final int SOCKET_PORT_NUMBER = 1971;
    public static final int SOCKET_TIME_TO_LIVE = 2;
    public static final String SOCKET_GROUP_NAME = "224.0.0.1";
    public static final int SOCKET_BUFFER_SIZE = 1024;
    public static final int SOCKET_TIMEOUT = 0;
    public static String SIGNATURE = "jProductivity-Protection!";
    protected int fSocketPortNumber = 1971;
    protected int fSocketTimeToLive = 2;
    protected String fSocketGroupName = "224.0.0.1";
    protected int fSocketBufferSize = 1024;
    protected int fSocketTimeout = 0;
    protected String fHostID;
    protected long fHostTimestamp = System.currentTimeMillis();
    protected String fSignature = SIGNATURE;
    protected MulticastSocket fMulticastSocket;
    protected Thread fRunnerTread;
    protected boolean fRunning = false;
    protected HashSet fResponceAddresses = new HashSet();
    protected String fProductID;
    protected String fLicenseNumber;
    protected int fNumberCopies = 0;
    protected InetAddress fGroup;
    protected boolean fVerbose = true;
    private transient Vector fNetworkCheckListeners;
    public static final int POLICY_SAME_HOST = 1;
    public static final int POLICY_DIFFERENT_HOST = 2;
    public static final int POLICY_ANY_HOST = 3;
    protected int fDefaultCheckHostPolicy = 2;
    protected int fCheckHostPolicy = 2;
    protected int fResponseCount = 0;

    public NetworkCheck() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            this.fHostID = localHost.getHostName();
            if (this.fHostID == null) {
                this.fHostID = localHost.toString();
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    public int getSocketTimeout() {
        return this.fSocketTimeout;
    }

    public void setSocketTimeout(int aSocketTimeout) {
        this.fSocketTimeout = aSocketTimeout;
    }

    public int getSocketBufferSize() {
        return this.fSocketBufferSize;
    }

    public void setSocketBufferSize(int aSocketBufferSize) {
        this.fSocketBufferSize = aSocketBufferSize;
    }

    public String getSocketGroupName() {
        return this.fSocketGroupName;
    }

    public void setSocketGroupName(String aSocketGroupName) {
        this.fSocketGroupName = aSocketGroupName;
        this.fGroup = null;
    }

    public int getSocketTimeToLive() {
        return this.fSocketTimeToLive;
    }

    public void setSocketTimeToLive(int aSocketTimeToLive) {
        this.fSocketTimeToLive = aSocketTimeToLive;
    }

    public int getSocketPortNumber() {
        return this.fSocketPortNumber;
    }

    public void setSocketPortNumber(int aSocketPortNumber) {
        this.fSocketPortNumber = aSocketPortNumber;
    }

    public synchronized void start() {
        if (this.fRunning) {
            return;
        }
        this.createMulticastSocket();
        this.fRunnerTread = new Thread(new Runnable(){

            public void run() {
                try {
                    int size = NetworkCheck.this.fMulticastSocket.getReceiveBufferSize();
                    DatagramPacket datagramPacket = new DatagramPacket(new byte[size], size);
                    NetworkCheck.this.fRunning = true;
                    try {
                        while (NetworkCheck.this.fRunning) {
                            NetworkCheck.this.fMulticastSocket.receive(datagramPacket);
                            NetworkCheck.this.processDatagramPacket(datagramPacket);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    NetworkCheck.this.stop();
                }
                catch (Exception ex) {
                    NetworkCheck.this.error(ex);
                }
            }
        });
        this.fRunnerTread.start();
    }

    private void error(Exception ex) {
        if (this.isVerbose()) {
            ex.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (!this.fRunning) {
            return;
        }
        this.fRunning = false;
        if (this.fRunnerTread.isAlive()) {
            this.fRunnerTread.interrupt();
        }
        this.releaseMulticastSocket();
    }

    protected boolean isRunning() {
        return this.fRunning;
    }

    public String getProductID() {
        return this.fProductID;
    }

    public void setProductID(String aProductID) {
        this.fProductID = aProductID;
    }

    public String getLicenseNumber() {
        return this.fLicenseNumber;
    }

    public void setLicenseNumber(String aLicenseNumber) {
        this.fLicenseNumber = aLicenseNumber;
    }

    public int getNumberCopies() {
        return this.fNumberCopies;
    }

    public void setNumberCopies(int aNumberCopies) {
        this.fNumberCopies = aNumberCopies;
    }

    public synchronized void check() {
        if (!this.isRunning()) {
            this.start();
        }
        this.fResponceAddresses.clear();
        this.sendRequest(this.fProductID, this.fLicenseNumber);
    }

    protected void send(NetworkCheckPacket aPacket) {
        if (this.fMulticastSocket == null) {
            throw new IllegalStateException("Network check is not started");
        }
        try {
            byte[] bytes = aPacket.toByteArray();
            aPacket.fromByteArray(bytes, 0, bytes.length);
            DatagramPacket datagramPacket = new DatagramPacket(bytes, bytes.length, this.getGroup(), this.getSocketPortNumber());
            this.fMulticastSocket.send(datagramPacket);
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    protected synchronized void createMulticastSocket() {
        try {
            this.fMulticastSocket = new MulticastSocket(this.getSocketPortNumber());
            this.fMulticastSocket.setTimeToLive(this.getSocketTimeToLive());
            this.fMulticastSocket.setSendBufferSize(this.getSocketBufferSize());
            this.fMulticastSocket.setSoTimeout(this.getSocketTimeout());
            this.fMulticastSocket.joinGroup(this.getGroup());
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    protected InetAddress getGroup() throws UnknownHostException {
        if (this.fGroup == null) {
            this.fGroup = InetAddress.getByName(this.getSocketGroupName());
        }
        return this.fGroup;
    }

    protected synchronized void releaseMulticastSocket() {
        try {
            this.fMulticastSocket.leaveGroup(this.getGroup());
            this.fMulticastSocket.close();
            this.fMulticastSocket = null;
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    protected void processDatagramPacket(DatagramPacket aDatagramPacket) {
        try {
            NetworkCheckPacket packet = new NetworkCheckPacket();
            packet.fromByteArray(aDatagramPacket.getData(), aDatagramPacket.getOffset(), aDatagramPacket.getLength());
            if (this.fSignature.equals(packet.getSignature()) && this.fProductID.equals(packet.getProductID()) && this.fLicenseNumber.equals(packet.getLicenseNumber())) {
                if (packet.getType() == 0) {
                    this.sendResponse(this.fProductID, this.fLicenseNumber);
                } else if (packet.getType() == 1 && this.checkResponse(packet)) {
                    this.fResponceAddresses.add(aDatagramPacket.getAddress());
                    if (++this.fResponseCount >= this.fNumberCopies) {
                        this.fireNumberCopiesViolation(this, this.fResponseCount + 1);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    public int getCheckHostPolicy() {
        return this.fCheckHostPolicy;
    }

    public void setCheckHostPolicy(int aCheckHostPolicy) {
        this.fCheckHostPolicy = aCheckHostPolicy;
    }

    public int getDefaultCheckHostPolicy() {
        return this.fDefaultCheckHostPolicy;
    }

    public void setDefaultCheckHostPolicy(int aDefaultCheckHostPolicy) {
        this.fDefaultCheckHostPolicy = aDefaultCheckHostPolicy;
    }

    protected boolean checkResponse(NetworkCheckPacket packet) {
        return this.checkHost(packet) && packet.getHostTimestamp() < this.fHostTimestamp;
    }

    protected boolean checkHost(NetworkCheckPacket packet) {
        boolean result = true;
        switch (this.fCheckHostPolicy) {
            case 1: {
                result = StringUtils.equals(packet.getHostID(), this.fHostID);
                break;
            }
            case 2: {
                result = !StringUtils.equals(packet.getHostID(), this.fHostID);
            }
        }
        return result;
    }

    public int getResponseCount() {
        return this.fResponseCount;
    }

    protected void sendResponse(String aProductID, String aLicenseNumber) {
        this.send(NetworkCheckPacket.createResponse(aProductID, aLicenseNumber, this.fSignature, this.fHostID, this.fHostTimestamp));
    }

    protected void sendRequest(String aProductID, String aLicenseNumber) {
        this.send(NetworkCheckPacket.createRequest(aProductID, aLicenseNumber, this.fSignature, this.fHostID, this.fHostTimestamp));
    }

    public String getSignature() {
        return this.fSignature;
    }

    public void setSignature(String aSignature) {
        this.fSignature = aSignature;
    }

    public synchronized void removeNetworkCheckListener(NetworkCheckListener l) {
        if (this.fNetworkCheckListeners != null && this.fNetworkCheckListeners.contains(l)) {
            Vector v = (Vector)this.fNetworkCheckListeners.clone();
            v.removeElement(l);
            this.fNetworkCheckListeners = v;
        }
    }

    public synchronized void addNetworkCheckListener(NetworkCheckListener l) {
        Vector v;
        Vector vector = v = this.fNetworkCheckListeners == null ? new Vector(2) : (Vector)this.fNetworkCheckListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fNetworkCheckListeners = v;
        }
    }

    protected void fireNumberCopiesViolation(NetworkCheck param1, int param2) {
        if (this.fNetworkCheckListeners != null) {
            Vector listeners = this.fNetworkCheckListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((NetworkCheckListener)listeners.elementAt(i)).numberCopiesViolation(param1, param2);
            }
        }
    }
}

