/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.lserver.rmi;

import com.jp.protection.pub.pro.lserver.BasicLicensingServiceProvider;
import com.jp.protection.pub.pro.lserver.LicenseData;
import com.jp.protection.pub.pro.lserver.LicenseDataImpl;
import com.jp.protection.pub.pro.lserver.LicensingService;
import com.jp.protection.pub.pro.lserver.LicensingServiceProvider;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderFactory;
import com.jp.protection.pub.pro.lserver.LicensingServiceResult;
import com.jp.protection.pub.pro.lserver.LicensingServiceResultImpl;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.HashMap;
import junit.framework.TestCase;

public class TestRmiLicensingServiceProvider
extends TestCase {
    protected LicensingServiceProvider fLicensingServiceProvider;
    static /* synthetic */ Class class$com$jp$protection$pub$pro$lserver$rmi$RmiLicensingServiceProvider;

    protected void setUp() throws Exception {
        super.setUp();
        this.fLicensingServiceProvider = LicensingServiceProviderFactory.getInstance().createProvider("localhost:1099", null);
        ((BasicLicensingServiceProvider)this.fLicensingServiceProvider).setConfirmLicenseLocks(true, null);
    }

    protected void tearDown() throws Exception {
        this.fLicensingServiceProvider.release();
        this.fLicensingServiceProvider = null;
        super.tearDown();
    }

    protected void print(LicensingServiceResult aResult) {
        System.out.print("Result: " + LicensingServiceResultImpl.getResultStr(aResult.getResult()));
        if (aResult.getMessage() != null) {
            System.out.println(" Message: " + aResult.getMessage());
        } else {
            System.out.println("");
        }
    }

    public void testLicenseLockFloating() throws RemoteException {
        LicenseDataImpl.RequestImpl request = this.createRequest();
        request.setUserLicensingModel(4);
        this.testLicenseLock(request, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testLicenseLock(LicenseData.Request aRequest, boolean isTestExpiration) throws RemoteException {
        block8: {
            String ipAddress = null;
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("ipAddress", ipAddress);
            LicensingService licensingService = this.fLicensingServiceProvider.createLicensingService(attrs);
            LicensingService licensingService1 = this.fLicensingServiceProvider.createLicensingService(attrs);
            TestRmiLicensingServiceProvider.assertTrue((String)"Unable to obtain licensing service", (licensingService != null ? 1 : 0) != 0);
            try {
                HashMap<String, String> attrs1 = new HashMap<String, String>();
                attrs1.put("ipAddress", ipAddress);
                System.out.println("---------- Can Lock License ------------");
                LicensingServiceResult result = licensingService.canLockLicense(aRequest, attrs1);
                this.print(result);
                System.out.println("----------------------------------------");
                System.out.println("------------ Lock License --------------");
                LicensingServiceResult result1 = licensingService.lockLicense(aRequest, attrs1);
                this.print(result);
                System.out.println("----------------------------------------");
                if (result.getResult() != 1) break block8;
                if (isTestExpiration) {
                    try {
                        System.out.println("Waiting for service expire...");
                        Thread.currentThread();
                        Thread.sleep(70000L);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                System.out.println("---------- Can Lock License ------------");
                result = licensingService.canLockLicense(aRequest, attrs1);
                this.print(result);
                System.out.println("----------------------------------------");
                System.out.println("--------- Confirm License Lock ---------");
                result = licensingService.confirmLicenseLock(result1.getTicket(), attrs1);
                this.print(result);
                System.out.println("----------------------------------------");
                System.out.println("------------ Unlock License  -----------");
                result = licensingService.unlockLicense(result1.getTicket(), attrs1);
                this.print(result);
                System.out.println("----------------------------------------");
                System.out.println("---------- Can Lock License ------------");
                result = licensingService.canLockLicense(aRequest, attrs1);
                this.print(result);
                System.out.println("----------------------------------------");
            }
            finally {
                this.fLicensingServiceProvider.releaseLicensingService(licensingService1);
                this.fLicensingServiceProvider.releaseLicensingService(licensingService);
            }
        }
    }

    protected LicenseDataImpl.RequestImpl createRequest() {
        LicenseDataImpl.RequestImpl request = new LicenseDataImpl.RequestImpl();
        request.setLicenseNumber("123");
        request.setProduct("DemoCalc");
        request.setNumberCopies(1);
        return request;
    }

    static {
        try {
            LicensingServiceProviderFactory.getInstance().registerProvider("RMI", class$com$jp$protection$pub$pro$lserver$rmi$RmiLicensingServiceProvider == null ? (class$com$jp$protection$pub$pro$lserver$rmi$RmiLicensingServiceProvider = TestRmiLicensingServiceProvider.class$("com.jp.protection.pub.pro.lserver.rmi.RmiLicensingServiceProvider")) : class$com$jp$protection$pub$pro$lserver$rmi$RmiLicensingServiceProvider, null, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

