/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.lserver.rmi;

import com.jp.protection.pub.pro.lserver.BasicLicensingServiceProvider;
import com.jp.protection.pub.pro.lserver.LicenseData;
import com.jp.protection.pub.pro.lserver.LicensingService;
import com.jp.protection.pub.pro.lserver.LicensingServiceResult;
import com.jp.protection.pub.pro.lserver.TimeoutHolder;
import com.jp.protection.pub.pro.lserver.rmi.RemoteLicensingServer;
import com.jp.protection.pub.pro.lserver.rmi.RemoteLicensingService;
import dev.util.StringUtils;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class RmiLicensingServiceProvider
extends BasicLicensingServiceProvider {
    public static final MessageFormat URL_FORMAT = new MessageFormat("rmi://{0}/LicensingServer");
    protected RemoteLicensingServer fRemoteLicensingServer;

    public RemoteLicensingServer getRemoteLicensingServer() {
        try {
            if (this.fRemoteLicensingServer == null) {
                this.fRemoteLicensingServer = (RemoteLicensingServer)Naming.lookup(URL_FORMAT.format(new Object[]{this.fAddress != null ? this.fAddress : ""}));
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        return this.fRemoteLicensingServer;
    }

    protected LicensingService createLicensingServiceImpl(Map anAttributes) {
        if (StringUtils.noValue(this.fAddress)) {
            throw new IllegalStateException("Licensing Server address is not specified");
        }
        HashMap attributes = new HashMap();
        attributes.putAll(this.fAttributes);
        if (anAttributes != null) {
            attributes.putAll(anAttributes);
        }
        try {
            return new LicensingServiceImpl(this.getRemoteLicensingServer().createLicensingService(attributes));
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void releaseLicensingServiceImpl(LicensingService aLicensingService) {
        try {
            String ticket = ((LicensingServiceImpl)aLicensingService).getRemoteLicensingService().getTicket();
            this.getRemoteLicensingServer().releaseLicensingService(ticket);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class LicensingServiceImpl
    implements LicensingService,
    TimeoutHolder {
        protected RemoteLicensingService fRemoteLicensingService;

        public LicensingServiceImpl(RemoteLicensingService aRemoteLicensingService) {
            this.fRemoteLicensingService = aRemoteLicensingService;
        }

        public RemoteLicensingService getRemoteLicensingService() {
            return this.fRemoteLicensingService;
        }

        public LicensingServiceResult.LicenseResult getLicense(LicenseData.Request aRequest, Map anAttributes) {
            try {
                return this.fRemoteLicensingService.getLicense(aRequest, anAttributes, -1);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
        }

        public LicensingServiceResult lockLicense(LicenseData.Request aRequest, Map anAttributes) {
            try {
                return this.fRemoteLicensingService.lockLicense(aRequest, anAttributes);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
        }

        public LicensingServiceResult canLockLicense(LicenseData.Request aRequest, Map anAttributes) {
            try {
                return this.fRemoteLicensingService.canLockLicense(aRequest, anAttributes);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
        }

        public LicensingServiceResult confirmLicenseLock(String aTicket, Map anAttributes) {
            try {
                return this.fRemoteLicensingService.confirmLicenseLock(aTicket, anAttributes);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
        }

        public LicensingServiceResult unlockLicense(String aTicket, Map anAttributes) {
            try {
                return this.fRemoteLicensingService.unlockLicense(aTicket, anAttributes);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
        }

        public long getTimeout() {
            try {
                return this.fRemoteLicensingService.getTimeout();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

