/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.lserver;

import com.jp.protection.pub.pro.lserver.LicensingServiceProvider;
import dev.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class LicensingServiceProviderFactory {
    protected static int fLicenseLockConfirmPeriod = 10000;
    protected static LicensingServiceProviderFactory fInstance;
    protected HashMap fProviderMap = new HashMap();
    protected HashMap fProviderAttrsMap = new HashMap();
    protected String fDefaultProviderName;
    public static final String ATTR_LS_ADDRESS = "lsAddress";
    public static final String ATTR_LS_LOGIN = "lsLogin";
    public static final String ATTR_LS_PASSWORD = "lsPassword";

    public static int getLicenseLockConfirmPeriod() {
        return fLicenseLockConfirmPeriod;
    }

    public static void setLicenseLockConfirmPeriod(int aLicenseLockConfirmPeriod) {
        fLicenseLockConfirmPeriod = aLicenseLockConfirmPeriod;
    }

    public static LicensingServiceProviderFactory getInstance() {
        if (fInstance == null) {
            fInstance = new LicensingServiceProviderFactory();
        }
        return fInstance;
    }

    public void registerProvider(String aName, Class aProviderClass, String anAddress, String aLogin, String aPassword, boolean isDefault) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (!StringUtils.noValue(anAddress)) {
            attrs.put(ATTR_LS_ADDRESS, anAddress);
        }
        if (!StringUtils.noValue(aLogin)) {
            attrs.put(ATTR_LS_LOGIN, aLogin);
        }
        if (!StringUtils.noValue(aPassword)) {
            attrs.put(ATTR_LS_PASSWORD, aPassword);
        }
        this.registerProvider(aName, aProviderClass, attrs, isDefault);
    }

    public void registerProvider(String aName, Class aProviderClass, Map aProviderAttrs, boolean isDefault) {
        this.fProviderMap.put(aName, aProviderClass);
        this.fProviderAttrsMap.put(aName, aProviderAttrs);
        if (isDefault) {
            this.fDefaultProviderName = aName;
        }
    }

    public void unRegisterProvider(String aName) {
        this.fProviderMap.remove(aName);
        this.fProviderAttrsMap.remove(aName);
        if (this.fDefaultProviderName == aName) {
            this.fDefaultProviderName = null;
        }
    }

    public void release() {
        this.fProviderMap.clear();
        this.fProviderAttrsMap.clear();
        this.fDefaultProviderName = null;
    }

    public LicensingServiceProvider createProvider(String anAddress, Map aProviderAttrs) {
        if (this.fDefaultProviderName != null) {
            return this.createProvider(this.fDefaultProviderName, anAddress, aProviderAttrs);
        }
        throw new IllegalArgumentException("There's no default licensing service provider specified");
    }

    public String getProviderAddress(String aName) {
        String name = aName != null ? aName : this.fDefaultProviderName;
        Map attrs = (Map)this.fProviderAttrsMap.get(name);
        if (attrs != null) {
            return (String)attrs.get(ATTR_LS_ADDRESS);
        }
        throw new IllegalArgumentException("Licensing service provider is not found: " + name);
    }

    public LicensingServiceProvider createProvider(String aName, String anAddress, Map aProviderAttrs) {
        String name = aName != null ? aName : this.fDefaultProviderName;
        Class providerClass = (Class)this.fProviderMap.get(name);
        if (providerClass == null) {
            throw new RuntimeException("No licensing service provider found");
        }
        try {
            LicensingServiceProvider result = (LicensingServiceProvider)providerClass.newInstance();
            HashMap attrs = new HashMap();
            Map defaultAttrs = (Map)this.fProviderAttrsMap.get(name);
            if (defaultAttrs != null) {
                attrs.putAll(defaultAttrs);
            }
            if (aProviderAttrs != null) {
                attrs.putAll(aProviderAttrs);
            }
            result.init(anAddress != null ? anAddress : (String)attrs.get(ATTR_LS_ADDRESS), attrs);
            return result;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Unable to create licensing service provider: " + aName, ex);
        }
    }

    public boolean hasProviders() {
        return !this.fProviderMap.isEmpty();
    }
}

