/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.lserver;

import com.jp.protection.pub.pro.lserver.LicenseData;
import com.jp.protection.pub.pro.lserver.LicensingService;
import com.jp.protection.pub.pro.lserver.LicensingServiceProvider;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderFactory;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderListener;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderListenerSupport;
import com.jp.protection.pub.pro.lserver.LicensingServiceResult;
import com.jp.protection.pub.pro.lserver.LicensingServiceResultImpl;
import com.jp.protection.pub.pro.lserver.TimeoutHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BasicLicensingServiceProvider
implements LicensingServiceProvider {
    protected String fAddress;
    protected Map fAttributes;
    protected Map fProxyLicensingServiceMap = new HashMap();
    protected boolean fConfirmLicenseLocks = false;
    protected Thread fConfirmLicenseLocksThread;
    protected List fLicensingServices = new ArrayList();
    protected HashMap fTicketMap = new HashMap();
    protected HashMap fTicketLicenseDataMap = new HashMap();
    protected boolean fDefault = false;
    protected transient LicensingServiceProviderListenerSupport fListenerSupport = new LicensingServiceProviderListenerSupport();

    protected LicensingService createLicensingServiceProxy(LicensingService aLicensingService) {
        return new LicensingServiceProxy(aLicensingService);
    }

    public void init(String anAddress, Map anAttributes) {
        this.fAddress = anAddress;
        this.fAttributes = anAttributes;
    }

    public LicensingService createLicensingService(Map anAttributes) {
        anAttributes.putAll(this.fAttributes);
        LicensingService licensingService = this.createLicensingServiceImpl(anAttributes);
        LicensingService proxy = this.createLicensingServiceProxy(licensingService);
        this.fProxyLicensingServiceMap.put(proxy, licensingService);
        this.fLicensingServices.add(proxy);
        this.fListenerSupport.fireLicensingServiceObtained(this, proxy);
        return proxy;
    }

    protected abstract LicensingService createLicensingServiceImpl(Map var1);

    protected abstract void releaseLicensingServiceImpl(LicensingService var1);

    public void releaseLicensingService(LicensingService aLicensingService) {
        Iterator tickets = new HashSet(this.getTickets(aLicensingService)).iterator();
        while (tickets.hasNext()) {
            String ticket = (String)tickets.next();
            try {
                aLicensingService.unlockLicense(ticket, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.removeTicket(aLicensingService, ticket);
        }
        try {
            this.releaseLicensingServiceImpl((LicensingService)this.fProxyLicensingServiceMap.get(aLicensingService));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fProxyLicensingServiceMap.remove(aLicensingService);
        this.fLicensingServices.remove(aLicensingService);
        this.fListenerSupport.fireLicensingServiceReleased(this, aLicensingService);
    }

    public void release() {
        this.setConfirmLicenseLocks(false);
        Iterator licensingServices = new ArrayList(this.fLicensingServices).iterator();
        while (licensingServices.hasNext()) {
            this.releaseLicensingService((LicensingService)licensingServices.next());
        }
    }

    protected boolean confirmLicenseLocks(Map anAttributes) {
        boolean result = true;
        Iterator licensingServices = this.fLicensingServices.iterator();
        while (licensingServices.hasNext()) {
            if (this.confirmLicenseLocks((LicensingService)licensingServices.next(), anAttributes)) continue;
            result = false;
        }
        return result;
    }

    protected boolean confirmLicenseLocks(LicensingService aLicensingService, Map anAttributes) {
        boolean result = true;
        LicensingServiceProxy licensingService = (LicensingServiceProxy)aLicensingService;
        Iterator tickets = this.getTickets(licensingService).iterator();
        while (tickets.hasNext()) {
            String ticket = (String)tickets.next();
            boolean needNotify = false;
            String message = null;
            if (!licensingService.isExpired(ticket)) {
                try {
                    licensingService.confirmLicenseLock(ticket, anAttributes);
                }
                catch (Throwable ex) {
                    result = false;
                    needNotify = licensingService.isExpired(ticket) && licensingService.isNeedNotify(ticket);
                    licensingService.setErrorMessage(ticket, BasicLicensingServiceProvider.getMessage(ex));
                }
            } else {
                result = false;
                needNotify = licensingService.isNeedNotify(ticket);
                message = licensingService.getErrorMessage(ticket);
            }
            if (!needNotify) continue;
            this.fListenerSupport.fireLicenseLockConfirmed(this, licensingService, ticket, new LicensingServiceResultImpl(5, message, ticket));
            licensingService.setNeedNotify(ticket, false);
        }
        return result;
    }

    public boolean isConfirmLicenseLocks() {
        return this.fConfirmLicenseLocks;
    }

    public void setConfirmLicenseLocks(boolean aConfirmLicenseLocks) {
        this.setConfirmLicenseLocks(aConfirmLicenseLocks, null);
    }

    protected long getLicenseLockConfirmPeriod() {
        long result = -1L;
        if (!this.fLicensingServices.isEmpty()) {
            result = ((LicensingServiceProxy)this.fLicensingServices.get(0)).getTimeout() / 5L;
        }
        if (result < 0L) {
            result = LicensingServiceProviderFactory.getLicenseLockConfirmPeriod();
        }
        return result;
    }

    public void setConfirmLicenseLocks(boolean aConfirmLicenseLocks, final Map anAttributes) {
        if (this.fConfirmLicenseLocks != aConfirmLicenseLocks) {
            this.fConfirmLicenseLocks = aConfirmLicenseLocks;
            if (this.fConfirmLicenseLocks) {
                this.fConfirmLicenseLocksThread = new Thread(new Runnable(){
                    private Map fAttributes;
                    {
                        this.fAttributes = new HashMap(anAttributes != null ? anAttributes : Collections.EMPTY_MAP);
                    }

                    public void run() {
                        while (BasicLicensingServiceProvider.this.isConfirmLicenseLocks()) {
                            BasicLicensingServiceProvider.this.confirmLicenseLocks(this.fAttributes);
                            try {
                                Thread.currentThread();
                                Thread.sleep(BasicLicensingServiceProvider.this.getLicenseLockConfirmPeriod());
                            }
                            catch (Exception ex) {
                                // empty catch block
                                break;
                            }
                        }
                        BasicLicensingServiceProvider.this.fConfirmLicenseLocksThread = null;
                    }
                }, "confirmLicenseLocksThread");
                this.fConfirmLicenseLocksThread.setPriority(3);
                this.fConfirmLicenseLocksThread.start();
            } else {
                this.fConfirmLicenseLocksThread = null;
            }
        }
    }

    protected Set getTickets(LicensingService aLicensingService) {
        Set result = (Set)this.fTicketMap.get(aLicensingService);
        return result != null ? result : Collections.EMPTY_SET;
    }

    protected LicenseData getLicenseData(String aTicket) {
        return (LicenseData)this.fTicketLicenseDataMap.get(aTicket);
    }

    protected void addTicket(LicensingService aLicensingService, String aTicket, LicenseData aLicenseData) {
        HashSet<String> tickets = (HashSet<String>)this.fTicketMap.get(aLicensingService);
        if (tickets == null) {
            tickets = new HashSet<String>();
            this.fTicketMap.put(aLicensingService, tickets);
        }
        tickets.add(aTicket);
        if (aLicenseData != null) {
            this.fTicketLicenseDataMap.put(aTicket, aLicenseData);
        }
    }

    protected void removeTicket(LicensingService aLicensingService, String aTicket) {
        Set tickets = (Set)this.fTicketMap.get(aLicensingService);
        if (tickets != null) {
            tickets.remove(aTicket);
            this.fTicketLicenseDataMap.remove(aTicket);
            if (tickets.isEmpty()) {
                this.fTicketMap.remove(aLicensingService);
            }
        }
    }

    public boolean isDefault() {
        return this.fDefault;
    }

    public void setDefault(boolean aDefault) {
        this.fDefault = aDefault;
    }

    public synchronized void addLicensingServiceProviderListener(LicensingServiceProviderListener l) {
        this.fListenerSupport.addLicensingServiceProviderListener(l);
    }

    public synchronized void removeLicensingServiceProviderListener(LicensingServiceProviderListener l) {
        this.fListenerSupport.removeLicensingServiceProviderListener(l);
    }

    public static String getMessage(Throwable ex) {
        Throwable cause;
        int index;
        String result = null;
        if (ex.getCause() != null && ex.getCause() instanceof IOException && (index = (result = (cause = ex.getCause()).getMessage()).indexOf(";")) != -1) {
            result = result.substring(0, index);
        }
        return result;
    }

    protected class LicensingServiceProxy
    implements LicensingService,
    TimeoutHolder {
        protected LicensingService fLicensingService;
        protected long fTimeout = -1L;
        protected Map fConfirmLicenseLockTimeMap = new HashMap();
        protected Map fErrorMessageMap = new HashMap();
        protected Set fNeedNotifySet = new HashSet();

        public LicensingServiceProxy(LicensingService aLicensingService) {
            this.fLicensingService = aLicensingService;
        }

        public LicensingService getLicensingService() {
            return this.fLicensingService;
        }

        public LicensingServiceResult.LicenseResult getLicense(LicenseData.Request aRequest, Map anAttributes) {
            LicensingServiceResult.LicenseResult result = this.fLicensingService.getLicense(aRequest, anAttributes);
            if (result.getResult() == 1 && result.getTicket() != null) {
                BasicLicensingServiceProvider.this.addTicket(this.fLicensingService, result.getTicket(), result.getResponse());
            }
            BasicLicensingServiceProvider.this.fListenerSupport.fireLicenseGot(BasicLicensingServiceProvider.this, this.fLicensingService, aRequest, result);
            return result;
        }

        public LicensingServiceResult lockLicense(LicenseData.Request aRequest, Map anAttributes) {
            LicensingServiceResult result = this.fLicensingService.lockLicense(aRequest, anAttributes);
            if (result.getResult() == 1 && result.getTicket() != null) {
                BasicLicensingServiceProvider.this.addTicket(this, result.getTicket(), aRequest);
                this.licenseLockConfirmed(result.getTicket());
            }
            BasicLicensingServiceProvider.this.fListenerSupport.fireLicenseLocked(BasicLicensingServiceProvider.this, this, aRequest, result);
            if (this.fTimeout < 0L) {
                this.fTimeout = this.fLicensingService instanceof TimeoutHolder ? ((TimeoutHolder)((Object)this.fLicensingService)).getTimeout() : -1L;
            }
            return result;
        }

        public LicensingServiceResult canLockLicense(LicenseData.Request aRequest, Map anAttributes) {
            LicensingServiceResult result = this.fLicensingService.canLockLicense(aRequest, anAttributes);
            if (result.getResult() == 1) {
                BasicLicensingServiceProvider.this.fListenerSupport.fireLicenseCanLocked(BasicLicensingServiceProvider.this, this, aRequest, result);
            }
            return result;
        }

        public boolean isExpired(String aTicket) {
            Long time = (Long)this.fConfirmLicenseLockTimeMap.get(aTicket);
            return time != null ? System.currentTimeMillis() - time > this.fTimeout : true;
        }

        protected void licenseLockConfirmed(String aTicket) {
            this.fConfirmLicenseLockTimeMap.put(aTicket, new Long(System.currentTimeMillis()));
        }

        public LicensingServiceResult confirmLicenseLock(String aTicket, Map anAttributes) {
            LicensingServiceResult result = this.fLicensingService.confirmLicenseLock(aTicket, anAttributes);
            if (result.getResult() == 1) {
                this.licenseLockConfirmed(aTicket);
            }
            BasicLicensingServiceProvider.this.fListenerSupport.fireLicenseLockConfirmed(BasicLicensingServiceProvider.this, this, aTicket, result);
            return result;
        }

        public LicensingServiceResult unlockLicense(String aTicket, Map anAttributes) {
            LicensingServiceResult result = this.fLicensingService.unlockLicense(aTicket, anAttributes);
            if (result.getResult() == 1 && result.getTicket() != null) {
                BasicLicensingServiceProvider.this.removeTicket(this, aTicket);
                this.fConfirmLicenseLockTimeMap.remove(aTicket);
                this.setErrorMessage(aTicket, null);
                this.setNeedNotify(aTicket, true);
            }
            BasicLicensingServiceProvider.this.fListenerSupport.fireLicenseUnlocked(BasicLicensingServiceProvider.this, this, aTicket, result);
            return result;
        }

        public long getTimeout() {
            return this.fTimeout;
        }

        public String getErrorMessage(String aTicket) {
            return (String)this.fErrorMessageMap.get(aTicket);
        }

        public void setErrorMessage(String aTicket, String aMessage) {
            if (aMessage != null) {
                this.fErrorMessageMap.put(aTicket, aMessage);
            } else {
                this.fErrorMessageMap.remove(aTicket);
            }
        }

        public void setNeedNotify(String aTicket, boolean aNeedNotify) {
            if (aNeedNotify) {
                this.fNeedNotifySet.remove(aTicket);
            } else {
                this.fNeedNotifySet.add(aTicket);
            }
        }

        public boolean isNeedNotify(String aTicket) {
            return !this.fNeedNotifySet.contains(aTicket);
        }
    }
}

