/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.ls;

import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.pro.ls.BasicLicenseStorage;
import com.jp.protection.pub.pro.ls.LicenseStorage;
import com.jp.protection.utils.LicenseUtils;
import dev.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarLicenseStorage
extends BasicLicenseStorage {
    public static final String ROOT_LICENSE_ENTRIES = "License Entries";
    public static final String EXTENSION_LICENSE_ENTRY = ".entry";
    public static final Attributes.Name PROPERTY_DIGEST = new Attributes.Name("LicenseEntries-Digest");
    public static final Attributes.Name PROPERTY_SEPARATE_LICENSE = new Attributes.Name("SeparateLicense");
    public static final byte[] COOKIE = "K@)3olN#s9}4Cn_8<dU4".getBytes();
    protected boolean fSeparateLicense = true;
    protected static final byte[] EMPTY_LICENSE_BYTES = new byte[0];
    protected MessageDigest fMessageDigest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File aFile) throws IOException {
        FileInputStream in = aFile.canRead() ? new FileInputStream(aFile) : null;
        try {
            this.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(InputStream anInputStream) throws IOException {
        boolean isSuccess = false;
        this.fireBeforeLicenseStorageLoad();
        try {
            this.fLicenseEntryMap.clear();
            this.resetDigest();
            if (anInputStream != null) {
                String readDigest = null;
                JarInputStream jarInputStream = new JarInputStream(anInputStream);
                try {
                    if (jarInputStream.getManifest() != null) {
                        Attributes attrs = jarInputStream.getManifest().getMainAttributes();
                        readDigest = (String)attrs.get(PROPERTY_DIGEST);
                        Object value = attrs.get(PROPERTY_SEPARATE_LICENSE);
                        if (value != null) {
                            this.setSeparateLicense(Boolean.TRUE.toString().equals(value));
                        }
                    }
                    JarEntry jarEntry = jarInputStream.getNextJarEntry();
                    while (jarEntry != null) {
                        try {
                            String name = jarEntry.getName();
                            if (!jarEntry.isDirectory() && name.startsWith(ROOT_LICENSE_ENTRIES)) {
                                this.loadLicenseEntry(jarInputStream, jarEntry);
                            }
                        }
                        finally {
                            jarInputStream.closeEntry();
                        }
                        jarEntry = jarInputStream.getNextJarEntry();
                    }
                }
                finally {
                    jarInputStream.close();
                }
                this.checkDigest(readDigest != null ? LicenseUtils.toBytes(readDigest) : null);
            }
            this.calculateCurrentID();
            this.setModified(false);
            isSuccess = true;
        }
        finally {
            this.fireLicenseStorageLoaded(isSuccess);
        }
    }

    private final void checkDigest(byte[] aReadDigest) throws IOException {
        this.updateDigest(COOKIE);
        byte[] digest = this.getDigest();
        boolean isOK = Arrays.equals(aReadDigest, digest);
        if (!isOK) {
            this.fLicenseEntryMap.clear();
            throw new IOException("Integrity violation");
        }
    }

    protected boolean isLicenseBytesEntry(JarEntry aJarEntry) {
        return !aJarEntry.getName().endsWith(EXTENSION_LICENSE_ENTRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLicenseEntry(JarInputStream aJarInputStream, JarEntry aJarEntry) throws IOException {
        block8: {
            byte[] bytes = StreamUtil.readB(aJarInputStream);
            if (!this.isLicenseBytesEntry(aJarEntry)) {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                ObjectInputStream objectInputStream = new ObjectInputStream(in);
                try {
                    try {
                        LicenseStorage.LicenseEntry licenseEntry = (LicenseStorage.LicenseEntry)objectInputStream.readObject();
                        if (!this.isSeparateLicense()) {
                            licenseEntry.setLicenseBytes((byte[])objectInputStream.readObject());
                            this.updateDigest(licenseEntry.getLicenseBytes());
                        }
                        this.addLicenseEntryImpl(licenseEntry, this.getLicenseEntryName(aJarEntry));
                        break block8;
                    }
                    catch (ClassNotFoundException ex) {
                        throw new IOException(ex.getMessage());
                    }
                }
                finally {
                    objectInputStream.close();
                }
            }
            LicenseStorage.LicenseEntry licenseEntry = this.getLicenseEntry(this.getLicenseBytesEntryName(aJarEntry));
            if (licenseEntry != null) {
                licenseEntry.setLicenseBytes(bytes);
                this.updateDigest(bytes);
            }
        }
    }

    protected String getLicenseEntryName(JarEntry aJarEntry) {
        String name = aJarEntry.getName();
        return name.substring(ROOT_LICENSE_ENTRIES.length() + 1, name.length() - EXTENSION_LICENSE_ENTRY.length());
    }

    protected String getLicenseBytesEntryName(JarEntry aJarEntry) {
        String name = aJarEntry.getName();
        return name.substring(ROOT_LICENSE_ENTRIES.length() + 1, name.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File aFile) throws IOException {
        if (aFile.getParentFile() != null && !aFile.getParentFile().exists()) {
            aFile.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(aFile);
        try {
            this.store(out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(OutputStream anOutputStream) throws IOException {
        boolean isSuccess = false;
        this.fireBeforeLicenseStorageSave();
        try {
            JarOutputStream jarOutputStream = new JarOutputStream(anOutputStream, this.createManifest());
            try {
                this.storeLicenseEntries(jarOutputStream);
            }
            finally {
                jarOutputStream.close();
            }
            this.setModified(false);
            isSuccess = true;
        }
        finally {
            this.fireLicenseStorageSaved(isSuccess);
        }
    }

    protected Manifest createManifest() {
        Manifest result = new Manifest();
        byte[] digest = this.calculateDigest();
        if (digest != null) {
            result.getMainAttributes().put(PROPERTY_DIGEST, LicenseUtils.toString(digest));
        }
        result.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        result.getMainAttributes().put(PROPERTY_SEPARATE_LICENSE, (this.isSeparateLicense() ? Boolean.TRUE : Boolean.FALSE).toString());
        return result;
    }

    private byte[] calculateDigest() {
        this.resetDigest();
        Iterator licenseEntries = this.getLicenseEntries("", true).iterator();
        while (licenseEntries.hasNext()) {
            LicenseStorage.LicenseEntry licenseEntry = (LicenseStorage.LicenseEntry)licenseEntries.next();
            this.updateDigest(licenseEntry.getLicenseBytes());
        }
        this.updateDigest(COOKIE);
        byte[] digest = this.getDigest();
        return digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeLicenseEntries(JarOutputStream jarOutputStream) throws IOException {
        Iterator licenseEntries = this.getLicenseEntries("", true).iterator();
        while (licenseEntries.hasNext()) {
            LicenseStorage.LicenseEntry entry = (LicenseStorage.LicenseEntry)licenseEntries.next();
            InputStream inputStream = this.getInputStream(entry);
            try {
                this.addJarEntry(jarOutputStream, inputStream, this.getJarEntryName(entry));
            }
            finally {
                inputStream.close();
            }
            if (!this.isSeparateLicense()) continue;
            inputStream = this.getLicenseInputStream(entry);
            try {
                this.addJarEntry(jarOutputStream, inputStream, this.getLicenseBytesJarEntryName(entry));
            }
            finally {
                inputStream.close();
            }
        }
    }

    public boolean isSeparateLicense() {
        return this.fSeparateLicense;
    }

    public void setSeparateLicense(boolean aSeparateLicense) {
        this.fSeparateLicense = aSeparateLicense;
    }

    protected String getJarEntryName(LicenseStorage.LicenseEntry anEntry) {
        return "License Entries/" + this.getName(anEntry) + EXTENSION_LICENSE_ENTRY;
    }

    protected String getLicenseBytesJarEntryName(LicenseStorage.LicenseEntry anEntry) {
        return "License Entries/" + this.getName(anEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(LicenseStorage.LicenseEntry aLicenseEntry) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(aLicenseEntry);
                if (!this.isSeparateLicense()) {
                    objectOutputStream.writeObject(aLicenseEntry.getLicenseBytes());
                }
            }
            finally {
                objectOutputStream.close();
            }
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected InputStream getLicenseInputStream(LicenseStorage.LicenseEntry aLicenseEntry) throws IOException {
        return new ByteArrayInputStream(aLicenseEntry.getLicenseBytes() != null ? aLicenseEntry.getLicenseBytes() : EMPTY_LICENSE_BYTES);
    }

    protected void addJarEntry(JarOutputStream jarOutputStream, InputStream anInputStream, String anEntryName) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        jarOutputStream.putNextEntry(new JarEntry(anEntryName));
        while ((bytesRead = anInputStream.read(buffer)) != -1) {
            jarOutputStream.write(buffer, 0, bytesRead);
        }
        jarOutputStream.closeEntry();
    }

    protected void updateDigest(byte[] aBytes) {
        MessageDigest messageDigest = this.getMessageDigest();
        if (messageDigest != null && aBytes != null) {
            messageDigest.update(aBytes);
        }
    }

    protected void resetDigest() {
        MessageDigest messageDigest = this.getMessageDigest();
        if (messageDigest != null) {
            messageDigest.reset();
        }
    }

    protected byte[] getDigest() {
        MessageDigest messageDigest = this.getMessageDigest();
        return messageDigest != null ? messageDigest.digest() : null;
    }

    protected MessageDigest getMessageDigest() {
        if (this.fMessageDigest == null) {
            try {
                this.fMessageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.fMessageDigest;
    }

    public LicenseReader createLicenseReader(String aLicenseEntryName) {
        LicenseStorage.LicenseEntry licenseEntry = this.getLicenseEntry(aLicenseEntryName);
        if (licenseEntry == null) {
            licenseEntry = this.createLicenseEntry();
            this.addLicenseEntry(licenseEntry, aLicenseEntryName);
        }
        return new BasicLicenseStorage.EntryLicenseReader(licenseEntry, aLicenseEntryName);
    }
}

