/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.ls;

import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.launch.ProtectionLauncherConfig;
import com.jp.protection.pub.launch.ProtectionLauncherConfigReader;
import com.jp.protection.pub.pro.ls.BasicLauncherConfigStorage;
import dev.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class JarLauncherConfigStorage
extends BasicLauncherConfigStorage {
    public static final String ROOT_LAUNCHER_CONFIGS = "Launcher Configs";
    public static final String EXTENSION_LAUNCHER_CONFIG = ".launcherConfig";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File aFile, ProtectionLauncherConfigReader aReader) throws IOException {
        FileInputStream in = new FileInputStream(aFile);
        try {
            this.load(in, aReader);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream anInputStream, ProtectionLauncherConfigReader aReader) throws IOException {
        this.fLauncherConfigs.clear();
        JarInputStream jarInputStream = new JarInputStream(anInputStream);
        try {
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                try {
                    String name = jarEntry.getName();
                    if (!jarEntry.isDirectory() && name.startsWith(ROOT_LAUNCHER_CONFIGS)) {
                        this.loadLauncherConfig(jarInputStream, jarEntry, aReader);
                    }
                }
                finally {
                    jarInputStream.closeEntry();
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
        }
        finally {
            jarInputStream.close();
        }
        this.setModified(false);
        this.fireLauncherConfigStorageLoaded();
    }

    protected void loadLauncherConfig(JarInputStream aJarInputStream, JarEntry aJarEntry, ProtectionLauncherConfigReader aReader) throws IOException {
        this.addLauncherConfig(aReader.read(new ByteArrayInputStream(StreamUtil.readB(aJarInputStream))));
    }

    protected String getJarEntryName(ProtectionLauncherConfig launcherConfig) {
        ProductInfo productInfo = launcherConfig.getProductInfo();
        String result = "Launcher Configs/" + productInfo.getID();
        if (productInfo.getEdition() != null) {
            result = result + "-" + productInfo.getEdition();
        }
        result = result + "-" + productInfo.getMajorVersion() + "-" + productInfo.getMinorVersion() + EXTENSION_LAUNCHER_CONFIG;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(Serializable anObject) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(anObject);
            }
            finally {
                objectOutputStream.close();
            }
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

