/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.ls;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.pro.ls.LicenseStorage;
import com.jp.protection.pub.pro.ls.LicenseStorageListener;
import dev.util.HashDualMap;
import dev.util.StringUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class BasicLicenseStorage
implements LicenseStorage,
PropertyChangeListener {
    private int fCurrentID = 0;
    protected HashMap fLicenseEntryIDMap = new HashMap();
    protected HashDualMap fLicenseEntryMap = new HashDualMap();
    protected transient Vector fLicenseStorageListeners;
    protected boolean fModified = false;

    public synchronized int getNewID() {
        return ++this.fCurrentID;
    }

    protected synchronized void calculateCurrentID() {
        this.fCurrentID = 0;
        Iterator iterator = this.getLicenseEntries("", true).iterator();
        while (iterator.hasNext()) {
            LicenseStorage.LicenseEntry licenseEntry = (LicenseStorage.LicenseEntry)iterator.next();
            this.fCurrentID = Math.max(this.fCurrentID, licenseEntry.getID());
        }
    }

    public void assignNewID(LicenseStorage.LicenseEntry aLicenseEntry) {
        ((BasicLicenseEntry)aLicenseEntry).fID = this.getNewID();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof LicenseStorage.LicenseEntry) {
            this.setModified(true);
            this.fireLicenseEntryUpdated((LicenseStorage.LicenseEntry)evt.getSource());
        }
    }

    public LicenseStorage.LicenseEntry createLicenseEntry() {
        return new BasicLicenseEntry(this.getNewID());
    }

    public void addLicenseEntry(LicenseStorage.LicenseEntry anEntry, String aName) {
        this.addLicenseEntryImpl(anEntry, aName);
        this.setModified(true);
        this.fireLicenseEntryAdded(anEntry);
    }

    protected void addLicenseEntryImpl(LicenseStorage.LicenseEntry anEntry, String aName) throws IllegalArgumentException {
        if (this.fLicenseEntryMap.containsKey(aName)) {
            throw new IllegalArgumentException("License entry with such name is already exists: " + aName);
        }
        this.checkLicenseExistence(anEntry, anEntry.getLicenseBytes());
        this.fLicenseEntryMap.put(aName, anEntry);
        this.fLicenseEntryIDMap.put(new Integer(anEntry.getID()), anEntry);
        if (anEntry instanceof BasicLicenseEntry) {
            ((BasicLicenseEntry)anEntry).setBasicLicenseStorage(this);
        }
    }

    protected void checkLicenseExistence(LicenseStorage.LicenseEntry anEntry, byte[] aLicenseBytes) {
        Iterator licenseEntries = this.fLicenseEntryMap.valueIterator();
        while (licenseEntries.hasNext()) {
            LicenseStorage.LicenseEntry licenseEntry = (LicenseStorage.LicenseEntry)licenseEntries.next();
            if (anEntry == licenseEntry || licenseEntry.getLicenseBytes() == aLicenseBytes || !Arrays.equals(licenseEntry.getLicenseBytes(), aLicenseBytes)) continue;
            throw new IllegalArgumentException("Such a license is already exists");
        }
    }

    public Collection getLicenseEntries(String aPath, boolean isIncludeSubPaths) {
        ArrayList result = new ArrayList();
        String path = aPath.replace('\\', '/');
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Iterator iterator = this.fLicenseEntryMap.keyIterator();
        while (iterator.hasNext()) {
            String name = ((String)iterator.next()).replace('\\', '/');
            if (isIncludeSubPaths) {
                if (!name.startsWith(path)) continue;
                result.add(this.fLicenseEntryMap.get(name));
                continue;
            }
            int index = name.lastIndexOf(47);
            if (index == -1 || !path.equals(name.substring(0, index))) continue;
            result.add(this.fLicenseEntryMap.get(name));
        }
        return result;
    }

    public Collection getLicenseEntries(String aProduct, String aProductEdition, int aMajorVersion, int aMinorVersion, int aLicenseType, boolean isExactMatch) {
        Collection result = this.getLicenseEntries(aProduct, aProductEdition, aMajorVersion, aMinorVersion, aLicenseType);
        if (result.isEmpty() && !isExactMatch) {
            result = this.getLicenseEntries(aProduct, aProductEdition, aMajorVersion, aMinorVersion, -1);
            if (result.isEmpty()) {
                result = this.getLicenseEntries(aProduct, aProductEdition, aMajorVersion, -1, -1);
            }
            if (result.isEmpty()) {
                result = this.getLicenseEntries(aProduct, aProductEdition, -1, -1, -1);
            }
            if (result.isEmpty()) {
                result = this.getLicenseEntries(aProduct, LicenseStorage.ANY_PRODUCT_EDITION, -1, -1, -1);
            }
        }
        return result;
    }

    public Collection getLicenseEntries(String aProduct, String aProductEdition, int aMajorVersion, int aMinorVersion, int aLicenseType) {
        ArrayList<LicenseStorage.LicenseEntry> result = new ArrayList<LicenseStorage.LicenseEntry>();
        Iterator iterator = this.fLicenseEntryMap.valueIterator();
        while (iterator.hasNext()) {
            LicenseStorage.LicenseEntry entry = (LicenseStorage.LicenseEntry)iterator.next();
            if (aProduct != LicenseStorage.ANY_PRODUCT && !aProduct.equals(entry.getProduct())) {
                entry = null;
            } else if (aProductEdition != LicenseStorage.ANY_PRODUCT_EDITION && !aProductEdition.equals(entry.getProductEdition())) {
                entry = null;
            } else if (aMajorVersion > -1 && aMajorVersion != entry.getMajorVersion()) {
                entry = null;
            } else if (aLicenseType > -1 && aLicenseType != entry.getLicenseType()) {
                entry = null;
            }
            if (entry == null) continue;
            result.add(entry);
        }
        return result;
    }

    public LicenseStorage.LicenseEntry getLicenseEntry(String aName) {
        return (LicenseStorage.LicenseEntry)this.fLicenseEntryMap.get(aName);
    }

    public String getName(LicenseStorage.LicenseEntry anEntry) {
        return (String)this.fLicenseEntryMap.getKey(anEntry);
    }

    public static String getLicenseEntryShortName(String aName) {
        String name = aName.replace('\\', '/');
        int index = name.lastIndexOf(47);
        return index != -1 ? name.substring(index + 1, name.length()) : name;
    }

    public static String getLicenseEntryPath(String aName) {
        String name = aName.replace('\\', '/');
        int index = name.lastIndexOf(47);
        return index != -1 ? name.substring(0, index) : null;
    }

    public void removeLicenseEntry(LicenseStorage.LicenseEntry anEntry) {
        this.fLicenseEntryMap.removeByValue(anEntry);
        this.fLicenseEntryIDMap.remove(new Integer(anEntry.getID()));
        if (anEntry instanceof BasicLicenseEntry) {
            ((BasicLicenseEntry)anEntry).setBasicLicenseStorage(null);
        }
        this.setModified(true);
        this.fireLicenseEntryRemoved(anEntry);
    }

    public LicenseStorage.LicenseEntry getLicenseEntry(int anID) {
        return (LicenseStorage.LicenseEntry)this.fLicenseEntryIDMap.get(new Integer(anID));
    }

    public synchronized void addLicenseStorageListener(LicenseStorageListener l) {
        Vector v;
        Vector vector = v = this.fLicenseStorageListeners == null ? new Vector(2) : (Vector)this.fLicenseStorageListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fLicenseStorageListeners = v;
        }
    }

    public synchronized void removeLicenseStorageListener(LicenseStorageListener l) {
        if (this.fLicenseStorageListeners != null && this.fLicenseStorageListeners.contains(l)) {
            Vector v = (Vector)this.fLicenseStorageListeners.clone();
            v.removeElement(l);
            this.fLicenseStorageListeners = v;
        }
    }

    protected void fireLicenseEntryAdded(LicenseStorage.LicenseEntry aLicenseEntry) {
        if (this.fLicenseStorageListeners != null) {
            Vector listeners = this.fLicenseStorageListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseStorageListener)listeners.elementAt(i)).licenseEntryAdded(this, aLicenseEntry);
            }
        }
    }

    protected void fireLicenseEntryUpdated(LicenseStorage.LicenseEntry aLicenseEntry) {
        if (this.fLicenseStorageListeners != null) {
            Vector listeners = this.fLicenseStorageListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseStorageListener)listeners.elementAt(i)).licenseEntryUpdated(this, aLicenseEntry);
            }
        }
    }

    protected void fireLicenseEntryRemoved(LicenseStorage.LicenseEntry aLicenseEntry) {
        if (this.fLicenseStorageListeners != null) {
            Vector listeners = this.fLicenseStorageListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseStorageListener)listeners.elementAt(i)).licenseEntryRemoved(this, aLicenseEntry);
            }
        }
    }

    protected void fireBeforeLicenseStorageLoad() {
        if (this.fLicenseStorageListeners != null) {
            Vector listeners = this.fLicenseStorageListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseStorageListener)listeners.elementAt(i)).beforeLicenseStorageLoad(this);
            }
        }
    }

    protected void fireLicenseStorageLoaded(boolean isSuccess) {
        if (this.fLicenseStorageListeners != null) {
            Vector listeners = this.fLicenseStorageListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseStorageListener)listeners.elementAt(i)).licenseStorageLoaded(this, isSuccess);
            }
        }
    }

    protected void fireBeforeLicenseStorageSave() {
        if (this.fLicenseStorageListeners != null) {
            Vector listeners = this.fLicenseStorageListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseStorageListener)listeners.elementAt(i)).beforeLicenseStorageSave(this);
            }
        }
    }

    protected void fireLicenseStorageSaved(boolean isSuccess) {
        if (this.fLicenseStorageListeners != null) {
            Vector listeners = this.fLicenseStorageListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseStorageListener)listeners.elementAt(i)).licenseStorageSaved(this, isSuccess);
            }
        }
    }

    public boolean isModified() {
        return this.fModified;
    }

    public void setModified(boolean aModified) {
        this.fModified = aModified;
    }

    public static void updateLicenseEntryProperties(License aLicense, LicenseStorage.LicenseEntry aLicenseEntry) {
        aLicenseEntry.setLicenseNumber(aLicense.getLicenseNumber());
        aLicenseEntry.setProduct(aLicense.getProduct());
        aLicenseEntry.setProductEdition(aLicense.getProductEdition());
        aLicenseEntry.setMajorVersion(aLicense.getProductMajorVersion());
        aLicenseEntry.setMinorVersion(aLicense.getProductMinorVersion());
        aLicenseEntry.setLicenseType(aLicense.getLicenseType());
        aLicenseEntry.setUserLicensingModel(aLicense.getUserLicensingModel());
    }

    public static class EntryLicenseReader
    extends LicenseReader {
        protected LicenseStorage.LicenseEntry fLicenseEntry;
        protected String fLicenseEntryName;

        public EntryLicenseReader(LicenseStorage.LicenseEntry aLicenseEntry, String aLicenseEntryName) {
            this.fLicenseEntry = aLicenseEntry;
            this.fLicenseEntryName = aLicenseEntryName;
        }

        public InputStream getLicenseInputStream() {
            return this.fLicenseEntry.getLicenseBytes() != null ? new ByteArrayInputStream(this.fLicenseEntry.getLicenseBytes()) : null;
        }

        public InputStream getLicenseFileInputStream() {
            return this.getLicenseInputStream();
        }

        public InputStream getLicenseResourceInputStream() {
            return this.getLicenseInputStream();
        }

        public String getLicenseFileLocation() {
            return this.fLicenseEntryName;
        }

        protected void updateLicenseEntryProperties() {
            EntryLicenseReader licenseReader = new EntryLicenseReader(this.fLicenseEntry, this.fLicenseEntryName);
            licenseReader.setSecurityAlgorithm(this.getSecurityAlgorithm());
            licenseReader.setDecryptKeyBytes(this.getDecryptKeyBytes());
            License license = licenseReader.getLicense();
            if (license != null) {
                BasicLicenseStorage.updateLicenseEntryProperties(license, this.fLicenseEntry);
            }
        }

        public OutputStream getLicenseOutputStream() {
            ByteArrayOutputStream result = new ByteArrayOutputStream(){

                public void close() throws IOException {
                    super.close();
                    EntryLicenseReader.this.fLicenseEntry.setLicenseBytes(this.toByteArray());
                    EntryLicenseReader.this.updateLicenseEntryProperties();
                }
            };
            return result;
        }
    }

    public static class BasicLicenseEntry
    implements LicenseStorage.LicenseEntry,
    Serializable {
        public static final long serialVersionUID = 1L;
        public static final String PROPERTY_LICENSE_BYTES = "licenseBytes";
        public static final String PROPERTY_LICENSE_TYPE = "licenseType";
        public static final String PROPERTY_LICENSE_NUMBER = "licenseNumber";
        public static final String PROPERTY_PRODUCT = "product";
        public static final String PROPERTY_PRODUCT_EDITION = "productEdition";
        public static final String PROPERTY_MAJOR_VERSION = "majorVersion";
        public static final String PROPERTY_MINOR_VERSION = "minorVersion";
        public static final String PROPERTY_USER_LICENSING_MODEL = "userLicensingModel";
        protected transient byte[] fLicenseBytes;
        protected String fLicenseNumber;
        protected int fLicenseType = -1;
        protected String fProduct;
        protected String fProductEdition = LicenseStorage.ANY_PRODUCT_EDITION;
        protected int fMajorVersion = -1;
        protected int fMinorVersion = -1;
        protected int fUserLicensingModel = -1;
        protected transient BasicLicenseStorage fBasicLicenseStorage;
        protected transient PropertyChangeSupport fPropertyChangeSupport;
        protected int fID;

        public int getID() {
            return this.fID;
        }

        public int hashCode() {
            return this.fID;
        }

        public boolean equals(Object anOther) {
            if (anOther == this) {
                return true;
            }
            if (!(anOther instanceof BasicLicenseEntry)) {
                return false;
            }
            return this.fID == ((BasicLicenseEntry)anOther).fID;
        }

        public BasicLicenseEntry(int anID) {
            this.fID = anID;
        }

        public BasicLicenseEntry(int anID, byte[] aLicenseBytes, String aProduct) {
            this(anID);
            this.fLicenseBytes = aLicenseBytes;
            this.fProduct = aProduct;
        }

        public BasicLicenseEntry(int anID, byte[] aLicenseBytes, String aProduct, String aProductEdition, int aMajorVersion, int aMinorVersion, int aLicenseType) {
            this(anID);
            this.fLicenseBytes = aLicenseBytes;
            this.fProduct = aProduct;
            this.fProductEdition = aProductEdition;
            this.fMajorVersion = aMajorVersion;
            this.fMinorVersion = aMinorVersion;
            this.fLicenseType = aLicenseType;
        }

        public PropertyChangeSupport getPropertyChangeSupport() {
            if (this.fPropertyChangeSupport == null) {
                this.fPropertyChangeSupport = new PropertyChangeSupport(this);
            }
            return this.fPropertyChangeSupport;
        }

        public BasicLicenseStorage getBasicLicenseStorage() {
            return this.fBasicLicenseStorage;
        }

        protected void setBasicLicenseStorage(BasicLicenseStorage aBasicLicenseStorage) {
            if (this.fBasicLicenseStorage != null) {
                this.removePropertyChangeListener(this.fBasicLicenseStorage);
            }
            this.fBasicLicenseStorage = aBasicLicenseStorage;
            if (this.fBasicLicenseStorage != null) {
                this.addPropertyChangeListener(this.fBasicLicenseStorage);
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            PropertyChangeSupport delegate = this.getPropertyChangeSupport();
            delegate.addPropertyChangeListener(listener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            PropertyChangeSupport delegate = this.getPropertyChangeSupport();
            delegate.removePropertyChangeListener(listener);
        }

        public byte[] getLicenseBytes() {
            return this.fLicenseBytes;
        }

        public void setLicenseBytes(byte[] aLicenseBytes) {
            if (this.fLicenseBytes != aLicenseBytes) {
                if (this.fBasicLicenseStorage != null) {
                    this.fBasicLicenseStorage.checkLicenseExistence(this, aLicenseBytes);
                }
                byte[] oldValue = this.fLicenseBytes;
                this.fLicenseBytes = aLicenseBytes;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LICENSE_BYTES, oldValue, this.fLicenseBytes);
            }
        }

        public void setLicenseType(int aLicenseType) {
            if (this.fLicenseType != aLicenseType) {
                int oldValue = this.fLicenseType;
                this.fLicenseType = aLicenseType;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LICENSE_TYPE, oldValue, this.fLicenseType);
            }
        }

        public void setMajorVersion(int aMajorVersion) {
            if (this.fMajorVersion != aMajorVersion) {
                int oldValue = this.fMajorVersion;
                this.fMajorVersion = aMajorVersion;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MAJOR_VERSION, oldValue, this.fMajorVersion);
            }
        }

        public void setMinorVersion(int aMinorVersion) {
            if (this.fMinorVersion != aMinorVersion) {
                int oldValue = this.fMinorVersion;
                this.fMinorVersion = aMinorVersion;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MINOR_VERSION, oldValue, this.fMinorVersion);
            }
        }

        public void setProduct(String aProduct) {
            if (!StringUtils.equals(this.fProduct, aProduct)) {
                String oldValue = this.fProduct;
                this.fProduct = aProduct;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PRODUCT, oldValue, this.fProduct);
            }
        }

        public void setProductEdition(String aProductEdition) {
            if (!StringUtils.equals(this.fProductEdition, aProductEdition)) {
                String oldValue = this.fProductEdition;
                this.fProductEdition = aProductEdition;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PRODUCT_EDITION, oldValue, this.fProductEdition);
            }
        }

        public void setLicenseNumber(String aLicenseNumber) {
            if (!StringUtils.equals(this.fLicenseNumber, aLicenseNumber)) {
                String oldValue = this.fLicenseNumber;
                this.fLicenseNumber = aLicenseNumber;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LICENSE_NUMBER, oldValue, this.fLicenseNumber);
            }
        }

        public void setUserLicensingModel(int aUserLicensingModel) {
            if (this.fUserLicensingModel != aUserLicensingModel) {
                int oldValue = this.fUserLicensingModel;
                this.fUserLicensingModel = aUserLicensingModel;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_USER_LICENSING_MODEL, oldValue, this.fUserLicensingModel);
            }
        }

        public int getLicenseType() {
            return this.fLicenseType;
        }

        public String getProduct() {
            return this.fProduct;
        }

        public String getProductEdition() {
            return this.fProductEdition;
        }

        public int getMajorVersion() {
            return this.fMajorVersion;
        }

        public int getMinorVersion() {
            return this.fMinorVersion;
        }

        public String getLicenseNumber() {
            return this.fLicenseNumber;
        }

        public int getUserLicensingModel() {
            return this.fUserLicensingModel;
        }
    }
}

