/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.ls;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.launch.ProtectionLauncher;
import com.jp.protection.pub.launch.ProtectionLauncherConfig;
import com.jp.protection.pub.pro.ls.BasicLicenseStorage;
import com.jp.protection.pub.pro.ls.LauncherConfigStorage;
import com.jp.protection.pub.pro.ls.LauncherConfigStorageListener;
import com.jp.protection.pub.pro.ls.LicenseStorage;
import dev.util.HashedListStrategy;
import dev.util.collections.ContainerAdapter;
import dev.util.collections.HashedBoundList;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class BasicLauncherConfigStorage
implements LauncherConfigStorage {
    protected HashedBoundList fLauncherConfigs = new HashedBoundList(new ArrayList(), new HashedListStrategy(){

        public Object getKeyForObject(Object anObject) {
            return ((ProtectionLauncherConfig)anObject).getProductInfo().getID();
        }
    }, new ContainerAdapter(){

        public void elementAdded(Object anElement, Object aSource) {
            BasicLauncherConfigStorage.this.setModified(true);
            BasicLauncherConfigStorage.this.fireLauncherConfigAdded((ProtectionLauncherConfig)anElement);
        }

        public void elementRemoved(Object anElement, Object aSource) {
            BasicLauncherConfigStorage.this.setModified(true);
            BasicLauncherConfigStorage.this.fireLauncherConfigRemoved((ProtectionLauncherConfig)anElement);
        }
    });
    protected boolean fModified = false;
    transient Vector fLauncherConfigStorageListeners;

    public ProtectionLauncher getLauncher(LicenseStorage.LicenseEntry anEntry, Component anOwner, boolean isExactMatch) {
        ProtectionLauncherConfig launcherConfig = this.getLauncherConfig(anEntry, isExactMatch);
        if (launcherConfig == null) {
            throw new IllegalStateException("Launcher configuration is not found");
        }
        return this.createLauncher(anEntry, launcherConfig, anOwner);
    }

    public ProtectionLauncherConfig getLauncherConfig(LicenseStorage.LicenseEntry anEntry, boolean isExactMatch) {
        ProtectionLauncherConfig result = this.getLauncherConfig(anEntry.getProduct(), anEntry.getProductEdition(), anEntry.getMajorVersion(), anEntry.getMinorVersion());
        if (result == null && !isExactMatch) {
            result = this.getLauncherConfig(anEntry.getProduct(), anEntry.getProductEdition(), anEntry.getMajorVersion(), -1);
            if (result == null) {
                result = this.getLauncherConfig(anEntry.getProduct(), anEntry.getProductEdition(), -1, -1);
            }
            if (result == null) {
                result = this.getLauncherConfig(anEntry.getProduct(), LicenseStorage.ANY_PRODUCT_EDITION, -1, -1);
            }
        }
        return result;
    }

    public ProtectionLauncherConfig getLauncherConfig(String aProduct, String aProductEdition, int aMajorVersion, int aMinorVersion) {
        ProtectionLauncherConfig result = null;
        Iterator iterator = this.getLauncherConfigs().iterator();
        while (result == null && iterator.hasNext()) {
            result = (ProtectionLauncherConfig)iterator.next();
            ProductInfo product = result.getProductInfo();
            if (aProduct != LicenseStorage.ANY_PRODUCT && !aProduct.equals(product.getID())) {
                result = null;
                continue;
            }
            if (aProductEdition != LicenseStorage.ANY_PRODUCT_EDITION && !aProductEdition.equals(product.getEdition())) {
                result = null;
                continue;
            }
            if (aMajorVersion > -1 && aMajorVersion != product.getMajorVersion()) {
                result = null;
                continue;
            }
            if (aMinorVersion <= -1 || aMinorVersion == product.getMinorVersion()) continue;
            result = null;
        }
        return result;
    }

    protected ProtectionLauncher createLauncher(LicenseStorage.LicenseEntry anEntry, ProtectionLauncherConfig aLauncherConfig, Component anOwner) {
        EntryProtectionLauncher result = new EntryProtectionLauncher(anEntry, aLauncherConfig, anOwner);
        result.init();
        return result;
    }

    public void addLauncherConfig(ProtectionLauncherConfig aLauncherConfig) {
        this.getLauncherConfigs().add(aLauncherConfig);
    }

    public ProtectionLauncherConfig getLauncherConfig(String aProductID) {
        return (ProtectionLauncherConfig)this.fLauncherConfigs.get(aProductID);
    }

    public Collection getLauncherConfigs() {
        return this.fLauncherConfigs;
    }

    public LicenseReader getLicenseReader(LicenseStorage.LicenseEntry anEntry, boolean isExactMatch) {
        ProtectionLauncherConfig launcherConfig = this.getLauncherConfig(anEntry, isExactMatch);
        if (launcherConfig == null) {
            throw new IllegalStateException("Launcher configuration is not found");
        }
        EntryLicenseReader result = new EntryLicenseReader(this, anEntry);
        result.setDecryptKeyBytes(launcherConfig.getDecryptKeyBytes());
        result.setSecurityAlgorithm(launcherConfig.getSecurityAlgorithm());
        return result;
    }

    public void setModified(boolean aModified) {
        this.fModified = aModified;
    }

    protected String getLicenseFileLocation(LicenseStorage.LicenseEntry anEntry, LicenseReader aLicenseReader) {
        return aLicenseReader.getLicenseFileName();
    }

    protected void updateLicenseEntryProperties(LicenseStorage.LicenseEntry aLicenseEntry) {
        License license = this.getLicenseReader(aLicenseEntry, false).getLicense();
        if (license != null) {
            BasicLicenseStorage.updateLicenseEntryProperties(license, aLicenseEntry);
        }
    }

    public synchronized void addLauncherConfigStorageListener(LauncherConfigStorageListener l) {
        Vector v;
        Vector vector = v = this.fLauncherConfigStorageListeners == null ? new Vector(2) : (Vector)this.fLauncherConfigStorageListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fLauncherConfigStorageListeners = v;
        }
    }

    public synchronized void removeLauncherConfigStorageListener(LauncherConfigStorageListener l) {
        if (this.fLauncherConfigStorageListeners != null && this.fLauncherConfigStorageListeners.contains(l)) {
            Vector v = (Vector)this.fLauncherConfigStorageListeners.clone();
            v.removeElement(l);
            this.fLauncherConfigStorageListeners = v;
        }
    }

    protected void fireLauncherConfigAdded(ProtectionLauncherConfig aLauncherConfig) {
        if (this.fLauncherConfigStorageListeners != null) {
            Vector listeners = this.fLauncherConfigStorageListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LauncherConfigStorageListener)listeners.elementAt(i)).launcherConfigAdded(this, aLauncherConfig);
            }
        }
    }

    protected void fireLauncherConfigRemoved(ProtectionLauncherConfig aLauncherConfig) {
        if (this.fLauncherConfigStorageListeners != null) {
            Vector listeners = this.fLauncherConfigStorageListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LauncherConfigStorageListener)listeners.elementAt(i)).launcherConfigRemoved(this, aLauncherConfig);
            }
        }
    }

    protected void fireLauncherConfigStorageLoaded() {
        if (this.fLauncherConfigStorageListeners != null) {
            Vector listeners = this.fLauncherConfigStorageListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LauncherConfigStorageListener)listeners.elementAt(i)).launcherConfigStorageLoaded(this);
            }
        }
    }

    protected void fireLauncherConfigStorageSaved() {
        if (this.fLauncherConfigStorageListeners != null) {
            Vector listeners = this.fLauncherConfigStorageListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LauncherConfigStorageListener)listeners.elementAt(i)).launcherConfigStorageSaved(this);
            }
        }
    }

    protected class EntryProtectionLauncher
    extends ProtectionLauncher {
        protected LicenseStorage.LicenseEntry fEntry;

        public EntryProtectionLauncher(LicenseStorage.LicenseEntry anEntry, ProtectionLauncherConfig aLauncherConfig, Component anOwner) {
            super(aLauncherConfig, anOwner);
            this.fEntry = anEntry;
        }

        protected LicenseReader createLicenseReader() {
            return new EntryLicenseReader(BasicLauncherConfigStorage.this, this.fEntry);
        }
    }

    public static class EntryLicenseReader
    extends LicenseReader {
        protected LicenseStorage.LicenseEntry fEntry;
        protected BasicLauncherConfigStorage fLauncherConfigStorage;

        public EntryLicenseReader(BasicLauncherConfigStorage aLauncherConfigStorage, LicenseStorage.LicenseEntry aEntry) {
            this.fLauncherConfigStorage = aLauncherConfigStorage;
            this.fEntry = aEntry;
        }

        public EntryLicenseReader(LicenseStorage.LicenseEntry aEntry) {
            this.fEntry = aEntry;
        }

        public InputStream getLicenseInputStream() {
            return this.fEntry.getLicenseBytes() != null ? new ByteArrayInputStream(this.fEntry.getLicenseBytes()) : null;
        }

        public InputStream getLicenseFileInputStream() {
            return this.getLicenseInputStream();
        }

        public InputStream getLicenseResourceInputStream() {
            return this.getLicenseInputStream();
        }

        public String getLicenseFileLocation() {
            return this.fLauncherConfigStorage != null ? this.fLauncherConfigStorage.getLicenseFileLocation(this.fEntry, this) : this.getLicenseFileName();
        }

        public OutputStream getLicenseOutputStream() {
            ByteArrayOutputStream result = new ByteArrayOutputStream(){

                public void close() throws IOException {
                    super.close();
                    EntryLicenseReader.this.fEntry.setLicenseBytes(this.toByteArray());
                    if (EntryLicenseReader.this.fLauncherConfigStorage != null) {
                        EntryLicenseReader.this.fLauncherConfigStorage.updateLicenseEntryProperties(EntryLicenseReader.this.fEntry);
                    }
                }
            };
            return result;
        }
    }
}

