/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.integration.ws;

import com.jp.protection.pub.pro.integration.LicenseDescr;
import com.jp.protection.pub.pro.integration.LicenseInfo;
import com.jp.protection.pub.pro.integration.LicensingFacade;
import com.jp.protection.pub.pro.integration.LicensingFacadeProvider;
import com.jp.protection.pub.pro.integration.LicensingFacadeResult;
import com.jp.protection.pub.pro.integration.ws.LicensingFacadeResultWS_Proxy;
import com.jp.protection.pub.pro.integration.ws.gen.Customer;
import com.jp.protection.pub.pro.integration.ws.gen.LicensingFacadeServiceLocator;
import com.jp.protection.pub.pro.integration.ws.gen.LicensingFacade_PortType;
import dev.beans.BeanTools;
import dev.lang.NestedException;
import java.net.InetAddress;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.axis.AxisFault;

public class LicensingFacadeWS
implements LicensingFacade {
    protected LicensingFacade_PortType fLicensingFacade;
    protected String fLogin;
    protected String fPassword;
    public static final String[] PROPERTIES_LICENSE_INFO = new String[]{"gracePeriod", "licenseNumber", "licenseOptions", "licenseType", "numberCopies", "product", "productEdition", "productMajorVersion", "productMinorVersion"};
    public static final String[] PROPERTIES_LICENSE_DESCR = new String[]{"licenseType", "product", "productEdition", "productMajorVersion", "productMinorVersion"};

    public LicensingFacadeWS(URL aConnectionURL) {
        URL connectionURL = aConnectionURL;
        String connectionURLStr = System.getProperty("protection.facadeURL", null);
        if (connectionURLStr != null) {
            try {
                connectionURL = new URL(connectionURLStr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        try {
            LicensingFacadeServiceLocator locator = new LicensingFacadeServiceLocator();
            this.fLicensingFacade = connectionURL != null ? locator.getLicensingFacade(connectionURL) : locator.getLicensingFacade();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Unable to connect to LicensingFacade Web Service at: " + connectionURL);
        }
    }

    public LicensingFacadeWS(URL aConnectionURL, String aLogin, String aPassword) {
        this(aConnectionURL);
        this.fLogin = aLogin;
        this.fPassword = aPassword;
    }

    protected HashMap prepareMap(Map aMap) {
        HashMap<String, String> result = aMap != null ? new HashMap(aMap) : new HashMap<String, String>();
        result.put("$locale$", Locale.getDefault().toString());
        try {
            result.put("$ipAddress$", InetAddress.getLocalHost().getHostAddress());
            result.put("$hostName$", InetAddress.getLocalHost().getHostName());
            result.put("$user$", System.getProperty("user.name", "user"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public LicensingFacadeResult getLicense(LicenseDescr aLicenseDescr, dev.entities.Customer aCustomer, String aLogin, String aPassword, Map anArguments) {
        try {
            return this.convertLicensingFacadeResult(this.fLicensingFacade.getLicense(this.convertLicenseDescr(aLicenseDescr), this.convertUser(aCustomer), this.fLogin != null ? this.fLogin : aLogin, this.fPassword != null ? this.fPassword : aPassword, this.prepareMap(anArguments)));
        }
        catch (AxisFault af) {
            if (af.detail != null) {
                throw new NestedException(af.detail);
            }
            throw new NestedException(af);
        }
        catch (Exception ex) {
            throw new NestedException(ex);
        }
    }

    public LicensingFacadeResult getLicense(String aSerialNumber, dev.entities.Customer aCustomer, String aLogin, String aPassword, Map anArguments) {
        try {
            return this.convertLicensingFacadeResult(this.fLicensingFacade.getLicense(aSerialNumber, this.convertUser(aCustomer), this.fLogin != null ? this.fLogin : aLogin, this.fPassword != null ? this.fPassword : aPassword, this.prepareMap(anArguments)));
        }
        catch (AxisFault af) {
            if (af.detail != null) {
                throw new NestedException(af.detail);
            }
            throw new NestedException(af);
        }
        catch (Exception ex) {
            throw new NestedException(ex);
        }
    }

    public String getVersion() {
        try {
            return this.fLicensingFacade.getVersion();
        }
        catch (AxisFault af) {
            if (af.detail != null) {
                throw new NestedException(af.detail);
            }
            throw new NestedException(af);
        }
        catch (Exception ex) {
            throw new NestedException(ex);
        }
    }

    public LicensingFacadeResult getLicense(LicenseInfo aLicenseInfo, dev.entities.Customer aCustomer, String aLogin, String aPassword, Map anArguments) {
        try {
            return this.convertLicensingFacadeResult(this.fLicensingFacade.getLicense(this.convertLicenseInfo(aLicenseInfo), this.convertUser(aCustomer), this.fLogin != null ? this.fLogin : aLogin, this.fPassword != null ? this.fPassword : aPassword, this.prepareMap(anArguments)));
        }
        catch (AxisFault af) {
            if (af.detail != null) {
                throw new NestedException(af.detail);
            }
            throw new NestedException(af);
        }
        catch (Exception ex) {
            throw new NestedException(ex);
        }
    }

    public LicensingFacadeResult activateLicense(byte[] aLicenseBytes, dev.entities.Customer aUser, String aLicenseKey, String aLogin, String aPassword, Map anArguments) {
        try {
            return this.convertLicensingFacadeResult(this.fLicensingFacade.activateLicense(aLicenseBytes, this.convertUser(aUser), aLicenseKey, this.fLogin != null ? this.fLogin : aLogin, this.fPassword != null ? this.fPassword : aPassword, this.prepareMap(anArguments)));
        }
        catch (AxisFault af) {
            if (af.detail != null) {
                throw new NestedException(af.detail);
            }
            throw new NestedException(af);
        }
        catch (Exception ex) {
            throw new NestedException(ex);
        }
    }

    public LicensingFacadeResult deactivateLicense(byte[] aLicenseBytes, String aDeactivationKey, String aLogin, String aPassword, Map anArguments) {
        try {
            return this.convertLicensingFacadeResult(this.fLicensingFacade.deactivateLicense(aLicenseBytes, aDeactivationKey, this.fLogin != null ? this.fLogin : aLogin, this.fPassword != null ? this.fPassword : aPassword, this.prepareMap(anArguments)));
        }
        catch (AxisFault af) {
            if (af.detail != null) {
                throw new NestedException(af.detail);
            }
            throw new NestedException(af);
        }
        catch (Exception ex) {
            throw new NestedException(ex);
        }
    }

    protected Customer convertUser(dev.entities.Customer aCustomer) {
        Customer result = new Customer();
        BeanTools.beanCopy(aCustomer, result, dev.entities.Customer.PROPERTIES);
        return result;
    }

    protected com.jp.protection.pub.pro.integration.ws.gen.LicenseInfo convertLicenseInfo(LicenseInfo aLicenseInfo) {
        Calendar calendar;
        com.jp.protection.pub.pro.integration.ws.gen.LicenseInfo result = new com.jp.protection.pub.pro.integration.ws.gen.LicenseInfo();
        BeanTools.beanCopy(aLicenseInfo, result, PROPERTIES_LICENSE_INFO);
        if (aLicenseInfo.getLicenseIssueDate() != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(aLicenseInfo.getLicenseIssueDate());
            result.setLicenseIssueDate(calendar);
        }
        if (aLicenseInfo.getLicenseExpireDate() != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(aLicenseInfo.getLicenseExpireDate());
            result.setLicenseExpireDate(calendar);
        }
        return result;
    }

    protected com.jp.protection.pub.pro.integration.ws.gen.LicenseDescr convertLicenseDescr(LicenseDescr aLicenseDescr) {
        com.jp.protection.pub.pro.integration.ws.gen.LicenseDescr result = new com.jp.protection.pub.pro.integration.ws.gen.LicenseDescr();
        BeanTools.beanCopy(aLicenseDescr, result, PROPERTIES_LICENSE_DESCR);
        return result;
    }

    protected LicensingFacadeResult convertLicensingFacadeResult(com.jp.protection.pub.pro.integration.ws.gen.LicensingFacadeResultWS_Proxy aLicensingFacadeResult) {
        return new LicensingFacadeResult(aLicensingFacadeResult.getResult(), LicensingFacadeResultWS_Proxy.getLicenseBytes(aLicensingFacadeResult.getLicenseBytes()), aLicensingFacadeResult.getMessage(), aLicensingFacadeResult.getDeliveryType());
    }

    public static class Provider
    extends LicensingFacadeProvider {
        protected URL fConnectionURL;
        protected String fLogin;
        protected String fPassword;

        public Provider(URL aConnectionURL) {
            this.fConnectionURL = aConnectionURL;
        }

        public Provider(URL aConnectionURL, String aLogin, String aPassword) {
            this.fConnectionURL = aConnectionURL;
            this.fLogin = aLogin;
            this.fPassword = aPassword;
        }

        public LicensingFacade getLicensingFacade() {
            return new LicensingFacadeWS(this.fConnectionURL, this.fLogin, this.fPassword);
        }
    }
}

