/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.integration;

import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.integration.LicenseDescr;
import com.jp.protection.pub.pro.integration.LicensingFacade;
import com.jp.protection.pub.pro.integration.LicensingFacadeProvider;
import com.jp.protection.pub.pro.integration.LicensingFacadeResult;
import dev.entities.Customer;
import dev.lang.NestedException;
import dev.util.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;

public class IssueResolverSupport {
    protected ProductInfo fProductInfo;
    protected Customer fCustomer;
    protected String fLogin;
    protected String fPassword;
    protected String fSerialNumber;
    protected String fLicensingFacadeProviderName;
    protected static final String MSG_UNABLE_TO_GET_EVAL = "Unable to get evaluation license";
    protected static final String MSG_UNABLE_TO_GET_LICENSE_BY_S_N = "Unable to get license by Serial Number";
    protected static final String MSG_UNABLE_TO_ACTIVATE = "Unable to activate license";
    protected static final String MSG_NO_LICENSING_FACADE = "There is no LicensingFacade available";
    protected boolean fVerbose = false;
    protected HashMap fArguments;
    protected LicenseHost fLicenseHost;

    public IssueResolverSupport(ProductInfo aProductInfo, Customer aCustomer) {
        if (aProductInfo == null) {
            throw new IllegalArgumentException("Product information should be specified");
        }
        if (aCustomer == null) {
            throw new IllegalArgumentException("Customer information should be specified");
        }
        this.fProductInfo = aProductInfo;
        this.fCustomer = aCustomer;
    }

    public String getLogin() {
        return this.fLogin;
    }

    public void setLogin(String aLogin) {
        this.fLogin = aLogin;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setPassword(String aPassword) {
        this.fPassword = aPassword;
    }

    public Customer getCustomer() {
        return this.fCustomer;
    }

    public ProductInfo getProductInfo() {
        return this.fProductInfo;
    }

    public String getSerialNumber() {
        return this.fSerialNumber;
    }

    public void setSerialNumber(String aSerialNumber) {
        this.fSerialNumber = aSerialNumber;
    }

    public String getLicensingFacadeProviderName() {
        return this.fLicensingFacadeProviderName;
    }

    public void setLicensingFacadeProviderName(String aLicensingFacadeProviderName) {
        this.fLicensingFacadeProviderName = aLicensingFacadeProviderName;
    }

    protected LicenseDescr getEvaluationLicenseDescr(boolean isExtEvaluation) {
        ProductInfo productInfo = this.getProductInfo();
        LicenseDescr result = new LicenseDescr();
        result.setProductMajorVersion(productInfo.getMajorVersion());
        result.setProductMinorVersion(productInfo.getMinorVersion());
        result.setProduct(productInfo.getID());
        result.setProductEdition(productInfo.getEdition());
        result.setLicenseType(isExtEvaluation ? 2 : 1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveLicense(LicenseReader aLicenseReader, byte[] licenseBytes) {
        boolean result = false;
        if (licenseBytes != null) {
            try {
                OutputStream out = aLicenseReader.getLicenseOutputStream();
                try {
                    out.write(licenseBytes);
                }
                finally {
                    out.close();
                    result = true;
                }
            }
            catch (Exception ex) {
                this.error(ex);
            }
        }
        return result;
    }

    private LicensingFacade getLicensingFacade() {
        LicensingFacade licensingFacade = LicensingFacadeProvider.getInstance(this.fLicensingFacadeProviderName).getLicensingFacade();
        return licensingFacade;
    }

    public boolean getEvaluationLicense() {
        return this.getEvaluationLicense(this.getLicenseHost().getLicenseReader());
    }

    public boolean getEvaluationLicense(LicenseReader aLicenseReader) {
        return this.getEvaluationLicense(aLicenseReader, false);
    }

    public boolean getEvaluationLicense(boolean isExtEvaluation) {
        return this.getEvaluationLicense(this.getLicenseHost().getLicenseReader(), isExtEvaluation);
    }

    public boolean getEvaluationLicense(LicenseReader aLicenseReader, boolean isExtEvaluation) {
        boolean result = false;
        LicensingFacadeResult requestResult = null;
        byte[] licenseBytes = null;
        try {
            LicensingFacade licensingFacade = this.getLicensingFacade();
            if (licensingFacade != null) {
                requestResult = licensingFacade.getLicense(this.getEvaluationLicenseDescr(isExtEvaluation), this.getCustomer(), this.getLogin(), this.getPassword(), (Map)this.getArguments());
                if (requestResult != null) {
                    if (requestResult.getResult() == 1) {
                        licenseBytes = requestResult.getLicenseBytes();
                        result = licenseBytes != null;
                    } else {
                        this.error("Unable to get evaluation license: " + requestResult.getMessage());
                    }
                } else {
                    this.error(MSG_UNABLE_TO_GET_EVAL);
                }
            } else {
                this.error(MSG_NO_LICENSING_FACADE);
            }
        }
        catch (NestedException ne) {
            this.error(ne);
            if (ne.getNestedException() instanceof ConnectException || ne.getNestedException() instanceof java.rmi.ConnectException) {
                this.error("Unable to get evaluation license: " + ne.getMessage());
            } else {
                this.error(MSG_UNABLE_TO_GET_EVAL);
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
        result = this.saveLicense(aLicenseReader, licenseBytes);
        return result;
    }

    public boolean getLicenseBySerialNumber() {
        return this.getLicenseBySerialNumber(this.getLicenseHost().getLicenseReader(), this.getSerialNumber());
    }

    public boolean getLicenseBySerialNumber(LicenseReader aLicenseReader) {
        return this.getLicenseBySerialNumber(aLicenseReader, this.getSerialNumber());
    }

    public boolean getLicenseBySerialNumber(LicenseReader aLicenseReader, String aSerialNumber) {
        boolean result = false;
        LicensingFacadeResult requestResult = null;
        byte[] licenseBytes = null;
        try {
            LicensingFacade licensingFacade = this.getLicensingFacade();
            if (licensingFacade != null) {
                requestResult = licensingFacade.getLicense(aSerialNumber, this.getCustomer(), this.getLogin(), this.getPassword(), (Map)this.getArguments());
                if (requestResult != null) {
                    if (requestResult.getResult() == 1) {
                        licenseBytes = requestResult.getLicenseBytes();
                    } else {
                        this.error("Unable to get license by Serial Number: " + requestResult.getMessage());
                    }
                } else {
                    this.error(MSG_UNABLE_TO_GET_LICENSE_BY_S_N);
                }
            } else {
                this.error(MSG_NO_LICENSING_FACADE);
            }
        }
        catch (NestedException ne) {
            this.error(ne);
            if (ne.getNestedException() instanceof ConnectException || ne.getNestedException() instanceof java.rmi.ConnectException) {
                this.error("Unable to get license by Serial Number: " + ne.getMessage());
            } else {
                this.error(MSG_UNABLE_TO_GET_LICENSE_BY_S_N);
            }
        }
        catch (Exception ex) {
            this.error(ex);
            this.error(MSG_UNABLE_TO_GET_LICENSE_BY_S_N);
        }
        result = this.saveLicense(aLicenseReader, licenseBytes);
        return result;
    }

    public boolean activateLicense(LicenseHost aLicenseHost, String anActivationKey) {
        boolean result = false;
        byte[] licenseBytes = null;
        LicensingFacadeResult requestResult = null;
        try {
            LicensingFacade licensingFacade = LicensingFacadeProvider.getInstance().getLicensingFacade();
            if (licensingFacade != null) {
                requestResult = licensingFacade.activateLicense(this.getLicenseBytes(aLicenseHost), this.getCustomer(), anActivationKey, this.getLogin(), this.getPassword(), this.getArguments());
                if (requestResult.getResult() == 1) {
                    licenseBytes = requestResult.getLicenseBytes();
                } else {
                    this.error("Unable to activate license: " + requestResult.getMessage());
                }
            } else {
                this.error(MSG_NO_LICENSING_FACADE);
            }
        }
        catch (NestedException ne) {
            this.error(ne);
            if (ne.getNestedException() instanceof ConnectException || ne.getNestedException() instanceof java.rmi.ConnectException) {
                this.error("Unable to activate license: " + ne.getMessage());
            } else {
                this.error(MSG_UNABLE_TO_ACTIVATE);
            }
        }
        catch (Exception ex) {
            this.error(ex);
            this.error(MSG_UNABLE_TO_ACTIVATE);
        }
        result = this.saveLicense(aLicenseHost.getLicenseReader(), licenseBytes);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getLicenseBytes(LicenseHost aLicenseHost) {
        byte[] result = null;
        InputStream licenseInputStream = aLicenseHost.getLicenseReader().getLicenseFileInputStream();
        if (licenseInputStream == null) {
            licenseInputStream = aLicenseHost.getLicenseReader().getLicenseResourceInputStream();
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                StreamUtil.copy(licenseInputStream, byteArrayOutputStream);
                byteArrayOutputStream.close();
                result = byteArrayOutputStream.toByteArray();
            }
            finally {
                licenseInputStream.close();
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
        return result;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    public HashMap getArguments() {
        return this.fArguments;
    }

    public void setArguments(HashMap aArguments) {
        this.fArguments = aArguments;
    }

    public LicenseHost getLicenseHost() {
        return this.fLicenseHost;
    }

    public void setLicenseHost(LicenseHost aLicenseHost) {
        this.fLicenseHost = aLicenseHost;
    }

    protected void error(String aMessage) {
        if (this.isVerbose()) {
            System.err.println(aMessage);
        }
    }

    protected void error(Exception ex) {
        if (this.isVerbose()) {
            ex.printStackTrace();
        }
    }
}

