/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseAdapter;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.LicenseHostPro;
import com.jp.protection.pub.pro.lserver.BasicLicensingServiceProvider;
import com.jp.protection.pub.pro.lserver.LicenseData;
import com.jp.protection.pub.pro.lserver.LicenseDataImpl;
import com.jp.protection.pub.pro.lserver.LicensingService;
import com.jp.protection.pub.pro.lserver.LicensingServiceProvider;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderAdapter;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderFactory;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderListener;
import com.jp.protection.pub.pro.lserver.LicensingServiceResult;
import com.jp.protection.pub.pro.lserver.LicensingServiceResultImpl;
import dev.net.HttpProxy;
import dev.util.StringUtils;
import java.util.Map;
import java.util.prefs.Preferences;

public class LicensingServiceSupport
extends LicenseAdapter {
    protected LicenseHostPro fLicenseHost;
    protected String fProviderName;
    protected LicensingServiceProvider fLicensingServiceProvider;
    protected LicensingService fLicensingService;
    protected Thread fShutdownHook = new Thread(){

        public void run() {
            LicensingServiceSupport.this.release(true);
        }
    };
    protected String fLicensingServerAddress;
    protected LicensingServiceProviderListener fLicensingServiceProviderListener = new LicensingServiceProviderAdapter(){

        public void licenseLockConfirmed(LicensingServiceProvider aSource, LicensingService aService, String aTicket, LicensingServiceResult aResult) {
            LicensingServiceSupport.this.fConfirmLockResult = aResult;
            switch (LicensingServiceSupport.this.fConfirmLockResult.getResult()) {
                case 4: {
                    LicensingServiceSupport.this.fLicenseHost.fireLicenseLockRevoked(LicensingServiceSupport.this.fLicenseHost, LicensingServiceSupport.this.fLicenseHost.getLicense(), LicensingServiceSupport.this.fConfirmLockResult.getMessage());
                    break;
                }
                case 5: {
                    LicensingServiceSupport.this.fLicenseHost.fireLicenseLockExpired(LicensingServiceSupport.this.fLicenseHost, LicensingServiceSupport.this.fLicenseHost.getLicense(), LicensingServiceSupport.this.fConfirmLockResult.getMessage());
                    break;
                }
            }
        }
    };
    protected LicensingServiceResult fObtainLicenseResult;
    protected LicensingServiceResult fLockResult;
    protected LicensingServiceResult fConfirmLockResult;
    protected LicensingServiceResult fUnlockLicenseResult;
    protected boolean fAcquireMACAddress = true;
    protected Preferences fPreferences;

    public LicensingServiceSupport(LicenseHostPro aLicenseHost) {
        this.fLicenseHost = aLicenseHost;
        this.fLicenseHost.addLicenseHostListener(this);
    }

    public void licenseAboutToRead(LicenseReader aSource, String aProductID) {
        this.release();
    }

    public String getProviderName() {
        return this.fProviderName;
    }

    public void setProviderName(String aProviderName) {
        this.fProviderName = aProviderName;
    }

    public String getLicensingServerAddress() {
        return this.fLicenseHost.loadSecretStorageProperty("licensingServerAddress", null);
    }

    public void setLicensingServerAddress(String aLicensingServerAddress) {
        this.fLicenseHost.saveSecretStorageProperty("licensingServerAddress", aLicensingServerAddress);
    }

    public boolean isLicensingServerAddressKnown() {
        License license = this.fLicenseHost.getLicense();
        return license != null && !StringUtils.noValue(license.getLicensingServerAddress());
    }

    public boolean hasLicensingServiceProvider() {
        return this.fLicensingServiceProvider != null;
    }

    public LicensingServiceProvider createLicensingServiceProvider(String aLicensingServerAddress) {
        return LicensingServiceProviderFactory.getInstance().createProvider(this.fProviderName, aLicensingServerAddress, null);
    }

    public LicensingService createLicensingService(LicensingServiceProvider aLicensingServiceProvider) {
        return aLicensingServiceProvider.createLicensingService(this.createAttributes());
    }

    protected LicensingServiceProvider getLicensingServiceProvider() {
        if (this.fLicensingServiceProvider == null) {
            String address;
            String string = address = this.fLicenseHost.getLicense() != null ? this.fLicenseHost.getLicense().getLicensingServerAddress() : null;
            if (StringUtils.noValue(address)) {
                address = this.getLicensingServerAddress();
            }
            this.fLicensingServiceProvider = LicensingServiceProviderFactory.getInstance().createProvider(this.fProviderName, address, null);
            Runtime.getRuntime().addShutdownHook(this.fShutdownHook);
            this.fLicensingServiceProvider.addLicensingServiceProviderListener(this.fLicensingServiceProviderListener);
            if (this.fLicensingServiceProvider instanceof BasicLicensingServiceProvider) {
                ((BasicLicensingServiceProvider)this.fLicensingServiceProvider).setConfirmLicenseLocks(true, null);
            }
        }
        return this.fLicensingServiceProvider;
    }

    public LicensingServiceResult getLockResult() {
        return this.fLockResult;
    }

    public LicensingServiceResult getConfirmLockResult() {
        return this.fConfirmLockResult;
    }

    public LicensingServiceResult getObtainLicenseResult() {
        return this.fObtainLicenseResult;
    }

    public void setLockResult(LicensingServiceResult aLockResult) {
        this.fLockResult = aLockResult;
    }

    private LicenseDataImpl.RequestImpl createRequest() {
        LicenseDataImpl.RequestImpl request = new LicenseDataImpl.RequestImpl();
        License license = this.fLicenseHost.getLicense();
        request.setLicenseType(license.getLicenseType());
        request.setLicenseNumber(license.getLicenseNumber());
        request.setNumberCopies(license.getNumberCopies());
        request.setProduct(license.getProduct());
        request.setProductEdition(license.getProductEdition());
        request.setProductMajorVersion(license.getProductMajorVersion());
        request.setProductMinorVersion(license.getProductMinorVersion());
        request.setUserLicensingModel(license.getUserLicensingModel());
        request.setLicenseOptions(license.getLicenseOptions());
        request.setLicenseIssueDate(license.getLicenseIssueDate());
        request.setLicenseExpireInfo(this.fLicenseHost.getLicenseExpireInfo(license));
        return request;
    }

    public static LicenseData.Request createRequest(ProductInfo aProductInfo) {
        LicenseDataImpl.RequestImpl request = new LicenseDataImpl.RequestImpl();
        request.setLicenseType(3);
        request.setProduct(aProductInfo.getID());
        request.setProductEdition(aProductInfo.getEdition());
        request.setProductMajorVersion(aProductInfo.getMajorVersion());
        request.setProductMinorVersion(aProductInfo.getMinorVersion());
        return request;
    }

    public synchronized boolean lockLicense(boolean isForceLock) {
        boolean result;
        boolean lockOK = this.isLockOK();
        boolean bl = result = lockOK && !isForceLock;
        if (!result) {
            try {
                LicensingService licensingService;
                if (lockOK && isForceLock) {
                    this.unlockLicense();
                }
                if ((licensingService = this.getLicensingService()) != null) {
                    this.fLockResult = licensingService.lockLicense(this.createRequest(), this.createAttributes());
                    this.fConfirmLockResult = null;
                    result = this.fLockResult.getResult() == 1;
                }
            }
            catch (RuntimeException ex) {
                this.fLockResult = LicensingServiceSupport.createResult(ex);
                this.error(ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean obtainLicense(String aServerAddress, ProductInfo aProductInfo) {
        boolean result = false;
        LicensingServiceProvider provider = this.createLicensingServiceProvider(aServerAddress);
        try {
            LicensingService service = this.createLicensingService(provider);
            if (service != null) {
                result = this.obtainLicense(service, aProductInfo);
            }
        }
        catch (RuntimeException ex) {
            this.fObtainLicenseResult = LicensingServiceSupport.createResult(ex);
            this.error(ex);
        }
        finally {
            if (provider != null) {
                provider.release();
            }
        }
        return result;
    }

    public synchronized boolean obtainLicense(LicensingService aLicensingService, ProductInfo aProductInfo) {
        boolean result = false;
        try {
            this.fObtainLicenseResult = aLicensingService.getLicense(LicensingServiceSupport.createRequest(aProductInfo), this.createAttributes());
            result = this.fObtainLicenseResult.getResult() == 1;
        }
        catch (RuntimeException ex) {
            this.fObtainLicenseResult = LicensingServiceSupport.createResult(ex);
            this.error(ex);
        }
        return result;
    }

    public byte[] getObtainedLicenseBytes() {
        return this.fObtainLicenseResult != null && this.fObtainLicenseResult.getResult() == 1 ? ((LicensingServiceResult.LicenseResult)this.fObtainLicenseResult).getResponse().getLicenseBytes() : null;
    }

    public static LicensingServiceResult createResult(RuntimeException ex) {
        String message = LicensingServiceSupport.getUserMessage(ex);
        return new LicensingServiceResultImpl(message != null ? 2 : 3, message);
    }

    public synchronized LicensingServiceResult canLockLicense() {
        LicensingServiceResult result;
        try {
            result = this.getLicensingService().canLockLicense(this.createRequest(), this.createAttributes());
        }
        catch (RuntimeException ex) {
            result = LicensingServiceSupport.createResult(ex);
            this.error(ex);
        }
        return result;
    }

    public boolean isLockOK() {
        boolean result;
        boolean bl = result = this.fLockResult != null && this.fLockResult.getResult() == 1;
        if (this.fConfirmLockResult != null) {
            result &= this.fConfirmLockResult.getResult() == 1 || this.fConfirmLockResult.getResult() == 4;
        }
        return result;
    }

    public boolean isLockRevoked() {
        return this.fConfirmLockResult != null && this.fConfirmLockResult.getResult() == 4;
    }

    public boolean isLockExpired() {
        return this.fConfirmLockResult != null && this.fConfirmLockResult.getResult() == 5;
    }

    public synchronized boolean unlockLicense() {
        if (this.isLockOK()) {
            try {
                this.fUnlockLicenseResult = this.getLicensingService().unlockLicense(this.fLockResult.getTicket(), this.createAttributes());
            }
            catch (RuntimeException ex) {
                this.fUnlockLicenseResult = LicensingServiceSupport.createResult(ex);
                this.error(ex);
            }
        } else {
            this.fUnlockLicenseResult = new LicensingServiceResultImpl(3, "License is not locked");
        }
        this.fLockResult = null;
        this.fConfirmLockResult = null;
        return this.fUnlockLicenseResult.getResult() == 1;
    }

    public LicensingServiceResult getUnlockLicenseResult() {
        return this.fUnlockLicenseResult;
    }

    private Map createAttributes() {
        return this.fLicenseHost.getContext().createAttributes(this.isAcquireMACAddress());
    }

    public boolean isAcquireMACAddress() {
        return this.fAcquireMACAddress;
    }

    public void setAcquireMACAddress(boolean aAcquireMACAddress) {
        this.fAcquireMACAddress = aAcquireMACAddress;
    }

    public LicensingService getLicensingService() {
        return this.getLicensingService(false);
    }

    public LicensingService getLicensingService(boolean aForceCreate) {
        if (this.fLicensingService == null || aForceCreate || this.isHttpProxyChanged()) {
            this.applyHttpProxy();
            LicensingServiceProvider licensingServiceProvider = this.getLicensingServiceProvider();
            this.fLicensingService = this.getLicensingServiceProvider().createLicensingService(this.createAttributes());
        }
        return this.fLicensingService;
    }

    public static String getUserMessage(Throwable ex) {
        return BasicLicensingServiceProvider.getMessage(ex);
    }

    protected void error(String aMessage) {
        if (this.fLicenseHost.isVerbose()) {
            System.err.println(aMessage);
        }
    }

    protected void error(Throwable ex) {
        if (this.fLicenseHost.isVerbose()) {
            ex.printStackTrace();
        }
    }

    public synchronized void release(boolean isShutdown) {
        try {
            if (this.fLicensingServiceProvider != null) {
                this.fLicensingServiceProvider.removeLicensingServiceProviderListener(this.fLicensingServiceProviderListener);
                this.fLicensingServiceProvider.release();
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
        this.fLicensingServiceProvider = null;
        this.fLicensingService = null;
        this.fLockResult = null;
        this.fConfirmLockResult = null;
        if (!isShutdown) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.fShutdownHook);
            }
            catch (Exception exception) {}
        } else {
            this.fLicenseHost.removeLicenseHostListener(this);
        }
    }

    public void release() {
        this.release(false);
    }

    public Preferences getPreferences() {
        return this.fPreferences;
    }

    public void setPreferences(Preferences aPreferences) {
        this.fPreferences = aPreferences;
    }

    protected boolean isHttpProxyChanged() {
        return false;
    }

    protected void applyHttpProxy() {
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            HttpProxy.applyFromPreferences(preferences.node("httpProxy"));
        }
    }
}

