/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro;

import com.jp.protection.pub.pro.LicenseHostPro;
import com.jp.protection.utils.LicenseUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.safehaus.uuid.EthernetAddress;
import org.safehaus.uuid.NativeInterfaces;

public class LicenseHostProContext {
    public static final String ATTR_AVAILABLE_PROCESSORS = "availableProcessors";
    public static final String ATTR_IP_ADDRESS = "ipAddress";
    public static final String ATTR_HOST_NAME = "hostName";
    public static final String ATTR_MAC_ADDRESS = "macAddress";
    public static final String ATTR_MAC_ADDRESSES = "macAddresses";
    public static final String ATTR_INSTALL_ID = "installID";
    public static final String ATTR_USER_NAME = "userName";
    public static final String ATTR_LOCALE = "locale";
    protected LicenseHostPro fLicenseHost;
    protected boolean fVerbose = false;

    protected static String getAttributeName(String aName, String aPrefix, String aSuffix) {
        String result = aName;
        if (aPrefix != null) {
            result = aPrefix + result;
        }
        if (aSuffix != null) {
            result = result + aSuffix;
        }
        return result;
    }

    public Map createAttributes(boolean isAcquireMACAddress) {
        return this.createAttributes(null, isAcquireMACAddress);
    }

    public Map createAttributes(String aPrefix, boolean isAcquireMACAddress) {
        HashMap attrs = new HashMap();
        this.fillAttributes(attrs, null, isAcquireMACAddress);
        return attrs;
    }

    public void fillAttributes(Map anAttributes, String aPrefix, boolean isAcquireMACAddress) {
        anAttributes.put(LicenseHostProContext.getAttributeName(ATTR_AVAILABLE_PROCESSORS, aPrefix, null), String.valueOf(this.getAvailableProcessors()));
        try {
            anAttributes.put(LicenseHostProContext.getAttributeName(ATTR_IP_ADDRESS, aPrefix, null), this.getIPAddress());
            anAttributes.put(LicenseHostProContext.getAttributeName(ATTR_HOST_NAME, aPrefix, null), this.getHostName());
        }
        catch (Throwable ex) {
            this.error(ex);
        }
        if (isAcquireMACAddress) {
            try {
                anAttributes.put(LicenseHostProContext.getAttributeName(ATTR_MAC_ADDRESS, aPrefix, null), String.valueOf(this.getMACAddress()));
                anAttributes.put(LicenseHostProContext.getAttributeName(ATTR_MAC_ADDRESSES, aPrefix, null), LicenseUtils.toString(this.getMACAddresses()));
            }
            catch (Throwable ex) {
                this.error(ex);
            }
        }
        anAttributes.put(LicenseHostProContext.getAttributeName(ATTR_INSTALL_ID, aPrefix, null), String.valueOf(this.getInstallID()));
        anAttributes.put(LicenseHostProContext.getAttributeName(ATTR_USER_NAME, aPrefix, null), this.getUserName());
        anAttributes.put(LicenseHostProContext.getAttributeName(ATTR_LOCALE, aPrefix, null), Locale.getDefault().toString());
    }

    public LicenseHostProContext(LicenseHostPro aLicenseHost) {
        this.fLicenseHost = aLicenseHost;
    }

    public String getUserName() {
        return this.getSystemProperty("user.name", "user");
    }

    public String getSystemProperty(String aName, String aDefaultValue) {
        return System.getProperty(aName, aDefaultValue);
    }

    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public String getIPAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName().toUpperCase();
    }

    public long getMACAddress() {
        return NativeInterfaces.getPrimaryInterface().toLong();
    }

    public long[] getMACAddresses() {
        EthernetAddress[] all = NativeInterfaces.getAllInterfaces();
        long[] result = new long[all.length];
        for (int i = 0; i < all.length; ++i) {
            result[i] = all[i].toLong();
        }
        return result;
    }

    public int getInstallID() {
        int result = this.fLicenseHost.loadSecretStorageIntProperty(ATTR_INSTALL_ID, true, 0L, true);
        if (result == 0) {
            SecureRandom random = new SecureRandom();
            while ((result = random.nextInt()) == 0) {
            }
            this.fLicenseHost.saveSecretStorageProperty(ATTR_INSTALL_ID, String.valueOf(result));
        }
        return result;
    }

    public int getActivationNumber(String aLicenseNumber) {
        return this.fLicenseHost.loadSecretStorageIntProperty(LicenseHostPro.getActivationNumberPropertyName(aLicenseNumber), true, 0L, true);
    }

    public void setActivationNumber(String aLicenseNumber, int aValue) {
        if (aValue <= this.getActivationNumber(aLicenseNumber)) {
            throw new IllegalArgumentException("New activation number should be greater than current one: " + aValue);
        }
        this.fLicenseHost.saveSecretStorageProperty(LicenseHostPro.getActivationNumberPropertyName(aLicenseNumber), String.valueOf(aValue));
    }

    public static void setNativeLibFolder(File aFolder) {
        NativeInterfaces.setLibDir((File)aFolder);
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    protected void error(String aMessage) {
        if (this.isVerbose()) {
            System.err.println(aMessage);
        }
    }

    protected void error(Throwable ex) {
        if (this.isVerbose()) {
            ex.printStackTrace();
        }
    }
}

