/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseAdapter;
import com.jp.protection.pub.LicenseHost;
import com.jp.protection.pub.LicenseHostListener;
import com.jp.protection.pub.LicenseImpl;
import com.jp.protection.pub.LicenseOutdatedException;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.LicenseReaderListener;
import com.jp.protection.pub.pro.LicenseHostProContext;
import com.jp.protection.pub.pro.LicensingServiceSupport;
import com.jp.protection.pub.pro.network.NetworkCheck;
import com.jp.protection.pub.pro.network.NetworkCheckListener;
import dev.lang.BitTools;
import dev.util.CalendarUtil;
import dev.util.StringUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;

public class LicenseHostPro
extends LicenseHost
implements NetworkCheckListener {
    static ResourceBundle res = ResourceBundle.getBundle("com.jp.protection.pub.pro.Res");
    public static final String PROPERTY_CLEAR_PREVIOUS_SHUTDOWN_DATE = "clearPreviousShutdownDate";
    protected boolean fNetworkCheckEnabled = true;
    protected String fSignature;
    protected NetworkCheck fNetworkCheck;
    protected boolean fAutoIncUseCount = true;
    public static final int LOCK_MAC_ADDRESS = 1;
    public static final int LOCK_USER = 2;
    public static final int LOCK_IP_ADDRESS = 4;
    public static final int LOCK_HOST = 8;
    public static final int LOCK_CPU_NUMBER = 16;
    public static final int LOCK_INSTALL_ID = 32;
    public static final int LOCK_ALL = 63;
    protected int fActivationLockOptions = 1;
    protected static final char[] ACTIVATION_KEY_CHARS_STRIPPED;
    protected static final char[] ACTIVATION_KEY_CHARS;
    protected boolean fUseStrippedActivationKeyChars = false;
    public static final String ACTIVATION_KEY_PATTERN = "#####-#####-#####-#####-#####";
    public static final char ACTIVATION_KEY_PATTERN_CHAR = '#';
    protected LicensingServiceSupport fLicensingServiceSupport = new LicensingServiceSupport(this);
    protected boolean fMaintainPreviousShutdownDate = false;
    protected Thread fShutdownHook = new Thread(){

        public void run() {
            Date prevDate = LicenseHostPro.this.getPreviousShutdownDate();
            Date current = new Date();
            if (prevDate == null || current.getTime() > prevDate.getTime()) {
                LicenseHostPro.this.setPreviousShutdownDate(current);
            }
        }
    };
    protected boolean fCheckPreviousShutdownDate = false;
    public static final String PROPERTY_USE_COUNT = "useCount";
    public static final String PROPERTY_LICENSING_SERVER_ADDRESS = "licensingServerAddress";
    public static final String PROPERTY_FIRST_LAUNCH_DATE = "firstLaunchDate";
    public static final String PROPERTY_ACTIVATION_NUMBER = "activationNumber";
    public static final String PROPERTY_INSTALL_ID = "installID";
    protected LicenseHostProContext fContext = new LicenseHostProContext(this);
    protected static final MessageFormat FMT_OR_USAGES_LEFT;
    protected static final MessageFormat FMT_USAGES_LEFT;
    protected LicenseReaderListener fLicenseReaderListener;
    public static final String PROPERTY_LATEST_DEACTIVATION_KEY = "latestDeactivationKey";
    public static final String PROPERTY_LATEST_ACTIVATION_KEY = "latestActivationKey";

    public LicenseHostPro() {
    }

    public LicenseHostPro(LicenseReader aLicenseReader) {
        super(aLicenseReader);
    }

    public LicenseHostPro(LicenseReader aLicenseReader, LicenseHostListener aLicenseHostListener) {
        super(aLicenseReader, aLicenseHostListener);
    }

    protected boolean checkExpirationImpl(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        boolean result = super.checkExpirationImpl(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion);
        if (aLicense.getLicenseExpireDate() != null) {
            if (result && aLicense.getGracePeriod() != -1) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, aLicense.getGracePeriod());
                Date expDate = this.getLicenseExpirationDate(true);
                if (calendar.getTimeInMillis() > expDate.getTime()) {
                    this.fireLicenseAboutToExpire(this, aLicense, 1 + CalendarUtil.getDaysDifference(this.getLicenseExpirationDate(false), new Date()));
                }
            }
            if (result) {
                result = this.checkPreviousShutdownDate();
            }
        }
        if (result) {
            result = this.checkUseCount(aLicense);
        }
        return result;
    }

    public int getExpireDaysLeft(License aLicense) {
        int result = -1;
        if (aLicense.getLicenseExpireDate() != null) {
            result = 1 + CalendarUtil.getDaysDifference(this.getLicenseExpirationDate(true), new Date());
        }
        return result;
    }

    public int getUseCountLeft(License aLicense) {
        int result = -1;
        String useCountStr = aLicense.getProperty("pr.usl", null);
        if (!StringUtils.noValue(useCountStr)) {
            result = 0;
            int useCount = Integer.parseInt(useCountStr);
            int gracePeriod = 0;
            String gracePeriodStr = aLicense.getProperty("pr.ugp", null);
            if (!StringUtils.noValue(gracePeriodStr)) {
                gracePeriod = Integer.parseInt(gracePeriodStr);
            }
            int actualUseCount = this.getUseCount(aLicense);
            result = useCount + gracePeriod - actualUseCount;
        }
        return result;
    }

    protected boolean checkUseCount(License aLicense) {
        boolean result = true;
        String useCountStr = aLicense.getProperty("pr.usl", null);
        if (!StringUtils.noValue(useCountStr)) {
            int actualUseCount;
            int difference;
            int useCount = Integer.parseInt(useCountStr);
            int gracePeriod = 0;
            String gracePeriodStr = aLicense.getProperty("pr.ugp", null);
            if (!StringUtils.noValue(gracePeriodStr)) {
                gracePeriod = Integer.parseInt(gracePeriodStr);
            }
            if ((difference = useCount + gracePeriod - (actualUseCount = this.getUseCount(aLicense))) > 0 && difference <= gracePeriod) {
                this.fireLicenseUseLimitAboutReach(this, aLicense, difference);
            }
            result = difference > 0;
        }
        return result;
    }

    protected void checkCommercial(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        this.saveFirstLaunchDate();
        super.checkCommercial(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion);
    }

    protected void saveFirstLaunchDate() {
        License license = this.getLicense();
        if (license != null && this.getFirstLaunchDate(license) == null) {
            this.setFirstLaunchDate(license, new Date());
        }
    }

    protected void checkEvaluation(LicenseImpl aLicense, String aProduct, int aProductMajorVersion, int aProductMinorVersion) {
        this.saveFirstLaunchDate();
        super.checkEvaluation(aLicense, aProduct, aProductMajorVersion, aProductMinorVersion);
    }

    protected void clearPreviousShutdownDate() {
        String hintStr;
        License license = this.getLicense();
        if (license != null && !StringUtils.noValue(hintStr = license.getProperty("licenseHostHint-clearPreviousShutdownDate", null))) {
            try {
                int hint = Integer.parseInt(hintStr);
                int loadedHint = this.loadSecretStorageIntProperty(PROPERTY_CLEAR_PREVIOUS_SHUTDOWN_DATE, true, 0L, false);
                if (hint > loadedHint) {
                    this.setPreviousShutdownDate(null);
                    this.saveSecretStorageProperty(PROPERTY_CLEAR_PREVIOUS_SHUTDOWN_DATE, String.valueOf(loadedHint + 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void checkLicense(String aProduct, int aProductMajorVersion, int aProductMinorVersion, boolean aForceLicenseRead) {
        this.clearPreviousShutdownDate();
        super.checkLicense(aProduct, aProductMajorVersion, aProductMinorVersion, aForceLicenseRead);
        License license = this.getLicense();
        if (license != null && license.getLicenseState() == 2 && this.isCheckNumberOfCopies()) {
            if (BitTools.checkBit(license.getLicenseOptions(), 8) && (license.getUserLicensingModel() == 2 || license.getUserLicensingModel() == 0)) {
                this.checkNumberOfCopies(license);
            } else if (BitTools.checkBit(license.getLicenseOptions(), 64) && license.getUserLicensingModel() == 3) {
                this.disallowSeveralInstances(license);
            }
        }
    }

    public boolean isCheckNumberOfCopies() {
        return this.fNetworkCheckEnabled;
    }

    public void setCheckNumberOfCopies(boolean aCheckNumberOfCopies) {
        this.fNetworkCheckEnabled = aCheckNumberOfCopies;
    }

    public boolean isNetworkCheckEnabled() {
        return this.fNetworkCheckEnabled;
    }

    public void setNetworkCheckEnabled(boolean aNetworkCheckEnabled) {
        this.fNetworkCheckEnabled = aNetworkCheckEnabled;
    }

    protected void fireProductFeaturesSupported(License aLicense) {
        Iterator iterator = aLicense.getProductFeatureNames().iterator();
        while (iterator.hasNext()) {
            String productFeature = (String)iterator.next();
            boolean isEnabled = false;
            if (aLicense.getLicenseState() == 2 || aLicense.getLicenseState() == 3) {
                if (aLicense.getLicenseType() == 3) {
                    isEnabled = aLicense.isProductFeatureSupported(productFeature, aLicense.getLicenseState() == 2 ? 0 : 2);
                } else if (aLicense.getLicenseType() == 1 || aLicense.getLicenseType() == 2) {
                    isEnabled = aLicense.isProductFeatureSupported(productFeature, aLicense.getLicenseState() == 2 ? 1 : 3);
                }
            } else if (aLicense.getLicenseState() == 4) {
                isEnabled = aLicense.isProductFeatureSupported(productFeature, 4);
            }
            this.fireFeatureChecked(this, aLicense, productFeature, isEnabled);
        }
    }

    public String getSignature() {
        return this.fSignature;
    }

    public void setSignature(String aSignature) {
        this.fSignature = aSignature;
    }

    protected void checkNumberOfCopies(License aLicense) {
        NetworkCheck networkCheck = this.getNetworkCheck();
        networkCheck.setProductID(aLicense.getProduct());
        networkCheck.setLicenseNumber(aLicense.getLicenseNumber());
        networkCheck.setNumberCopies(aLicense.getNumberCopies());
        networkCheck.setSignature(this.getSignature() != null ? this.getSignature() : aLicense.getLicenseNumber());
        if (BitTools.checkBit(aLicense.getLicenseOptions(), 16)) {
            networkCheck.setCheckHostPolicy(3);
        } else if (BitTools.checkBit(aLicense.getLicenseOptions(), 32)) {
            networkCheck.setCheckHostPolicy(2);
        } else {
            networkCheck.setCheckHostPolicy(networkCheck.getDefaultCheckHostPolicy());
        }
        networkCheck.check();
    }

    protected void disallowSeveralInstances(License aLicense) {
        NetworkCheck networkCheck = this.getNetworkCheck();
        networkCheck.setProductID(aLicense.getProduct());
        networkCheck.setLicenseNumber(aLicense.getLicenseNumber());
        networkCheck.setNumberCopies(1);
        networkCheck.setSignature(this.getSignature() != null ? this.getSignature() : aLicense.getLicenseNumber());
        networkCheck.setCheckHostPolicy(1);
        networkCheck.check();
    }

    public void stopNetworkCheck() {
        if (this.fNetworkCheck != null) {
            this.fNetworkCheck.stop();
        }
    }

    public int getNetworkCheckHostPolicy() {
        return this.getNetworkCheck().getCheckHostPolicy();
    }

    public void setNetworkCheckHostPolicy(int aCheckHostPolicy) {
        this.getNetworkCheck().setCheckHostPolicy(aCheckHostPolicy);
    }

    public NetworkCheck getNetworkCheck() {
        if (this.fNetworkCheck == null) {
            this.fNetworkCheck = new NetworkCheck();
            this.fNetworkCheck.addNetworkCheckListener(this);
        }
        return this.fNetworkCheck;
    }

    protected void fireNumberCopiesViolation(LicenseHost aSource, License aLicense, int aNumberInUse) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                LicenseHostListener l = (LicenseHostListener)listeners.elementAt(i);
                l.numberCopiesViolation(aSource, aLicense, aNumberInUse);
            }
        }
    }

    protected void fireLicenseAboutToExpire(LicenseHost aSource, License aLicense, int aDaysLeft) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                LicenseHostListener l = (LicenseHostListener)listeners.elementAt(i);
                l.licenseAboutToExpire(aSource, aLicense, aDaysLeft);
            }
        }
    }

    protected void fireLicenseNeedLock(LicenseHost aSource, License aLicense, int aDaysLeft) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                LicenseHostListener l = (LicenseHostListener)listeners.elementAt(i);
                l.licenseNeedLock(aSource, aLicense, aDaysLeft);
            }
        }
    }

    protected void fireLicenseLockExpired(LicenseHost aSource, License aLicense, String aReason) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                LicenseHostListener l = (LicenseHostListener)listeners.elementAt(i);
                l.licenseLockExpired(aSource, aLicense, aReason);
            }
        }
    }

    protected void fireLicenseLockRevoked(LicenseHost aSource, License aLicense, String aReason) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                LicenseHostListener l = (LicenseHostListener)listeners.elementAt(i);
                l.licenseLockRevoked(aSource, aLicense, aReason);
            }
        }
    }

    protected void fireLicenseUseLimitAboutReach(LicenseHost aSource, License aLicense, int aUseLeft) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                LicenseHostListener l = (LicenseHostListener)listeners.elementAt(i);
                l.licenseUseLimitAboutReach(aSource, aLicense, aUseLeft);
            }
        }
    }

    protected void fireLicenseLockViolation(LicenseHost aSource, License aLicense) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                LicenseHostListener l = (LicenseHostListener)listeners.elementAt(i);
                l.licenseLockViolation(aSource, aLicense);
            }
        }
    }

    protected void fireLicenseNotActivated(LicenseHost aSource, License aLicense) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseHostListener)listeners.elementAt(i)).licenseNotActivated(aSource, aLicense);
            }
        }
    }

    protected void fireLicenseNotLocked(LicenseHost aSource, License aLicense, String aReason) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseHostListener)listeners.elementAt(i)).licenseNotLocked(aSource, aLicense, aReason);
            }
        }
    }

    protected void fireLicenseNeedActivation(LicenseHost aSource, License aLicense, int aDaysLeft) {
        if (this.fLicenseHostListeners != null) {
            Vector listeners = this.fLicenseHostListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((LicenseHostListener)listeners.elementAt(i)).licenseNeedActivation(aSource, aLicense, aDaysLeft);
            }
        }
    }

    public boolean isAutoIncUseCount() {
        return this.fAutoIncUseCount;
    }

    public void setAutoIncUseCount(boolean aAutoIncUseCount) {
        this.fAutoIncUseCount = aAutoIncUseCount;
    }

    protected void setLicenseState(LicenseImpl aLicense, int aState) {
        super.setLicenseState(aLicense, aState);
        switch (aState) {
            case 7: {
                this.fireLicenseNotLocked(this, aLicense, this.fLicensingServiceSupport.getLockResult().getMessage());
                break;
            }
            case 5: {
                this.fireLicenseNotActivated(this, aLicense);
                break;
            }
            case 6: {
                this.fireLicenseLockViolation(this, aLicense);
                break;
            }
            case 2: {
                if (!this.isAutoIncUseCount()) break;
                this.setUseCount(aLicense, this.getUseCount(aLicense) + 1);
                this.setAutoIncUseCount(false);
            }
        }
    }

    public void numberCopiesViolation(NetworkCheck aSource, int aNumberInUse) {
        this.fireNumberCopiesViolation(this, this.getLicense(), aNumberInUse);
    }

    public String getActivationKey() {
        String result;
        LicenseImpl license = (LicenseImpl)this.getLicense();
        if (license == null) {
            throw new IllegalStateException("License is not read yet");
        }
        if (BitTools.checkBit(license.getLicenseOptions(), 1)) {
            result = this.getActivationKey(license);
        } else if (BitTools.checkBit(license.getLicenseOptions(), 2)) {
            result = this.getActivationLockKey(license);
        } else {
            throw new IllegalStateException("License is not require activation");
        }
        return result;
    }

    public String getActivationKey(LicenseImpl aLicense) {
        return this.getActivationKey(aLicense.getLicenseNumber());
    }

    public String getActivationKey(String aLicenseNumber) {
        return LicenseHostPro.getActivationKey(this.composeActivationKey(aLicenseNumber), this.getActivationKeyChars());
    }

    protected long composeActivationKey(String aLicenseNumber) {
        return aLicenseNumber.hashCode() + this.getActivationNumber(aLicenseNumber);
    }

    public int getActivationLockOptions() {
        return this.fActivationLockOptions;
    }

    public void setActivationLockOptions(int aActivationLockOptions) {
        if (aActivationLockOptions < 1 || aActivationLockOptions > 63) {
            throw new IllegalArgumentException("Illegal lock options value: " + aActivationLockOptions);
        }
        this.fActivationLockOptions = aActivationLockOptions;
    }

    public String getActivationLockKey(LicenseImpl aLicense) {
        return this.getActivationLockKey(aLicense.getLicenseNumber());
    }

    protected String[] getActivationLockKeys(LicenseImpl aLicense) {
        return this.getActivationLockKeys(aLicense.getLicenseNumber());
    }

    public String getActivationLockKey(String aLicenseNumber) {
        return LicenseHostPro.getActivationKey(this.composeActivationLockKey(aLicenseNumber, this.getActivationLockKey()), this.getActivationKeyChars());
    }

    protected String[] getActivationLockKeys(String aLicenseNumber) {
        long[] lockKeys = this.getActivationLockKeys();
        String[] result = new String[lockKeys.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = LicenseHostPro.getActivationKey(this.composeActivationLockKey(aLicenseNumber, lockKeys[i]), this.getActivationKeyChars());
        }
        return result;
    }

    protected long composeActivationLockKey(String aLicenseNumber, long anActivationKeyValue) {
        return (long)aLicenseNumber.hashCode() + anActivationKeyValue + (long)this.getActivationNumber(aLicenseNumber);
    }

    protected char[] getActivationKeyChars() {
        return LicenseHostPro.getActivationKeyChars(this.isUseStrippedActivationKeyChars());
    }

    public static char[] getActivationKeyChars(boolean isUseStrippedActivationKeyChars) {
        return isUseStrippedActivationKeyChars ? ACTIVATION_KEY_CHARS_STRIPPED : ACTIVATION_KEY_CHARS;
    }

    protected long[] getActivationLockKeys() {
        long[] result = BitTools.checkBit(this.fActivationLockOptions, 1) ? this.getContext().getMACAddresses() : new long[1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.applyGeneralLockAttributes(result[i]);
        }
        return result;
    }

    private long applyGeneralLockAttributes(long aLock) {
        if (BitTools.checkBit(this.fActivationLockOptions, 2)) {
            aLock += (long)this.getContext().getUserName().hashCode();
        }
        if (BitTools.checkBit(this.fActivationLockOptions, 16)) {
            aLock += (long)this.getContext().getAvailableProcessors();
        }
        if (BitTools.checkBit(this.fActivationLockOptions, 32)) {
            aLock += (long)this.getContext().getInstallID();
        }
        try {
            if (BitTools.checkBit(this.fActivationLockOptions, 4)) {
                aLock += (long)this.getContext().getIPAddress().hashCode();
            }
            if (BitTools.checkBit(this.fActivationLockOptions, 8)) {
                aLock += (long)this.getContext().getHostName().hashCode();
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
        return aLock;
    }

    protected long getActivationLockKey() {
        long[] keys = this.getActivationLockKeys();
        return keys != null && keys.length > 0 ? keys[0] : 0L;
    }

    protected boolean checkSystemDateTrick() {
        Date shutdownDate;
        boolean result = true;
        if (this.isCheckPreviousShutdownDate() && (shutdownDate = this.getPreviousShutdownDate()) != null) {
            result = CalendarUtil.getHoursDifferenceInt(new Date(), shutdownDate) >= 0;
        }
        return result;
    }

    public int getActivationDaysLeft(License aLicense) {
        return this.getDaysLeft(aLicense, aLicense.getActivationGracePeriod());
    }

    protected int getDaysLeft(License aLicense, int aGracePeriod) {
        int result = 0;
        int gracePeriod = aGracePeriod;
        if (gracePeriod != -1) {
            try {
                Date firstLaunchDate = this.getFirstLaunchDate(aLicense);
                if (firstLaunchDate != null && this.checkSystemDateTrick()) {
                    result = gracePeriod - CalendarUtil.getDaysDifferenceInt(new Date(), firstLaunchDate);
                }
            }
            catch (Exception ex) {
                this.error(ex);
            }
        }
        return result;
    }

    public int getLockDaysLeft(License aLicense) {
        return this.getDaysLeft(aLicense, aLicense.getLockGracePeriod());
    }

    protected boolean checkActivationGracePeriod(LicenseImpl aLicense) {
        boolean result;
        int daysLeft = this.getActivationDaysLeft(aLicense);
        boolean bl = result = daysLeft > 0;
        if (result) {
            this.fireLicenseNeedActivation(this, aLicense, daysLeft);
        }
        return result;
    }

    protected boolean checkLockGracePeriod(LicenseImpl aLicense) {
        boolean result;
        int daysLeft = this.getLockDaysLeft(aLicense);
        boolean bl = result = daysLeft > 0;
        if (result) {
            this.fireLicenseNeedLock(this, aLicense, daysLeft);
        }
        return result;
    }

    protected boolean checkActivation(LicenseImpl aLicense) {
        boolean result = true;
        if (aLicense.getUserLicensingModel() == 3 || aLicense.getUserLicensingModel() == 0) {
            if (BitTools.checkBit(aLicense.getLicenseOptions(), 1)) {
                result = this.checkActivationImpl(aLicense, result);
            } else if (BitTools.checkBit(aLicense.getLicenseOptions(), 2)) {
                result = this.checkActivationLockImpl(aLicense, result);
            }
        }
        return result;
    }

    protected boolean checkActivationLockImpl(LicenseImpl aLicense, boolean result) throws LicenseOutdatedException {
        String licenseActivationKey = aLicense.getProperty("pr.ak", "");
        if (licenseActivationKey.equals("")) {
            String activationKey = this.getActivationLockKey(aLicense);
            if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseMissingActivation(this, activationKey)) {
                throw new LicenseOutdatedException();
            }
            result = this.checkActivationGracePeriod(aLicense);
            if (!result) {
                this.setLicenseState(aLicense, 5);
            }
        } else {
            String[] activationKeys = this.getActivationLockKeys(aLicense);
            boolean isOK = false;
            for (int i = 0; !isOK && i < activationKeys.length; ++i) {
                if (!licenseActivationKey.equals(activationKeys[i])) continue;
                isOK = true;
            }
            if (!isOK) {
                if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseActivationLockViolation(this)) {
                    throw new LicenseOutdatedException();
                }
                result = false;
                this.setLicenseState(aLicense, 6);
            }
        }
        return result;
    }

    protected boolean checkActivationImpl(LicenseImpl aLicense, boolean result) throws LicenseOutdatedException {
        String activationKey = this.getActivationKey(aLicense);
        if (!activationKey.equals(aLicense.getProperty("pr.ak", null))) {
            if (this.fIssueResolver != null && this.fIssueResolver.resolveLicenseMissingActivation(this, activationKey)) {
                throw new LicenseOutdatedException();
            }
            result = this.checkActivationGracePeriod(aLicense);
            if (!result) {
                this.setLicenseState(aLicense, 5);
            }
        }
        return result;
    }

    protected boolean checkLicenseLock(LicenseImpl aLicense) {
        boolean result = true;
        if (!(aLicense.getUserLicensingModel() != 4 && aLicense.getUserLicensingModel() != 5 || (result = this.checkLicenseLockImpl(aLicense)))) {
            if (this.fIssueResolver != null) {
                result = this.fIssueResolver.resolveLicenseNotLocked(this);
            }
            if (!result && !this.checkLockGracePeriod(aLicense)) {
                this.setLicenseState(aLicense, 7);
            } else {
                result = true;
            }
        }
        return result;
    }

    protected boolean checkLicenseLockImpl(License aLicense) {
        return this.lockLicense();
    }

    public LicensingServiceSupport getLicensingServiceSupport() {
        return this.fLicensingServiceSupport;
    }

    public boolean lockLicense() {
        return this.fLicensingServiceSupport.lockLicense(false);
    }

    public boolean unlockLicense() {
        return this.fLicensingServiceSupport.unlockLicense();
    }

    protected long getMACAddress() {
        return this.getContext().getMACAddress();
    }

    protected long[] getMACAddresses() {
        return this.getContext().getMACAddresses();
    }

    public static void setNativeLibFolder(File aFolder) {
        LicenseHostProContext.setNativeLibFolder(aFolder);
    }

    public boolean isUseStrippedActivationKeyChars() {
        return this.fUseStrippedActivationKeyChars;
    }

    public void setUseStrippedActivationKeyChars(boolean aUseStrippedActivationKeyChars) {
        this.fUseStrippedActivationKeyChars = aUseStrippedActivationKeyChars;
    }

    protected static String getActivationKey(long aKey) {
        return LicenseHostPro.getActivationKey(aKey, ACTIVATION_KEY_CHARS);
    }

    protected static String getActivationKey(long aKey, char[] aKeyChars) {
        return LicenseHostPro.getActivationKey(String.valueOf(aKey).getBytes(), aKeyChars);
    }

    public static String getActivationKey(byte[] aKey, char[] aKeyChars) {
        StringBuffer result = new StringBuffer(ACTIVATION_KEY_PATTERN);
        int patternLength = result.length();
        int keyCharsOffset = 0;
        int i = 0;
        for (int j = 0; i < aKey.length && j < patternLength; ++i, ++j) {
            keyCharsOffset += Math.abs(aKey[i]);
            while (keyCharsOffset >= aKeyChars.length) {
                keyCharsOffset -= aKeyChars.length;
            }
            while (result.charAt(j) != '#' && j < patternLength) {
                ++j;
            }
            result.setCharAt(j, aKeyChars[keyCharsOffset]);
            if (i != aKey.length - 1) continue;
            i = -1;
        }
        return result.toString();
    }

    public Date getPreviousShutdownDate() {
        return this.loadSecretStorageDateProperty("previousShutdownDate", false, null, false);
    }

    protected void setPreviousShutdownDate(Date aDate) {
        this.saveSecretStorageProperty("previousShutdownDate", aDate != null ? String.valueOf(aDate.getTime()) : null);
    }

    public boolean isCheckPreviousShutdownDate() {
        return this.fCheckPreviousShutdownDate;
    }

    public void setCheckPreviousShutdownDate(boolean aCheckPreviousShutdownDate) {
        if (this.fCheckPreviousShutdownDate != aCheckPreviousShutdownDate) {
            this.fCheckPreviousShutdownDate = aCheckPreviousShutdownDate;
            if (this.fCheckPreviousShutdownDate && !this.isMaintainPreviousShutdownDate()) {
                this.setMaintainPreviousShutdownDate(true);
            }
        }
    }

    public boolean isMaintainPreviousShutdownDate() {
        return this.fMaintainPreviousShutdownDate;
    }

    public void setMaintainPreviousShutdownDate(boolean aMaintainPreviousShutdownDate) {
        try {
            if (this.fMaintainPreviousShutdownDate != aMaintainPreviousShutdownDate) {
                if (this.fMaintainPreviousShutdownDate) {
                    Runtime.getRuntime().removeShutdownHook(this.fShutdownHook);
                }
                this.fMaintainPreviousShutdownDate = aMaintainPreviousShutdownDate;
                if (this.fMaintainPreviousShutdownDate) {
                    Runtime.getRuntime().addShutdownHook(this.fShutdownHook);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void release() {
        super.release();
        this.fLicensingServiceSupport.release();
        this.stopNetworkCheck();
        this.setMaintainPreviousShutdownDate(false);
    }

    protected boolean checkPreviousShutdownDate() {
        Date date;
        boolean result = true;
        if (this.isCheckPreviousShutdownDate() && (date = this.getPreviousShutdownDate()) != null) {
            result = System.currentTimeMillis() > date.getTime();
        }
        return result;
    }

    protected static String getUseCountPropertyName(License aLicense) {
        return "useCount[" + aLicense.getLicenseNumber() + "]";
    }

    protected int getUseCount(License aLicense) {
        return this.loadSecretStorageIntProperty(LicenseHostPro.getUseCountPropertyName(aLicense), true, 0L, false);
    }

    protected void setUseCount(License aLicense, int aUseCount) {
        this.saveSecretStorageProperty(LicenseHostPro.getUseCountPropertyName(aLicense), String.valueOf(aUseCount));
    }

    public void incUseCount() {
        License license = this.getLicense();
        this.setUseCount(license, this.getUseCount(license) + 1);
    }

    protected static String getFirstLaunchDatePropertyName(License aLicense) {
        return "firstLaunchDate[" + aLicense.getLicenseNumber() + "]";
    }

    protected Date getFirstLaunchDate(License aLicense) {
        return this.loadSecretStorageDateProperty(LicenseHostPro.getFirstLaunchDatePropertyName(aLicense), true, null, false);
    }

    protected void setFirstLaunchDate(License aLicense, Date aDate) {
        this.saveSecretStorageProperty(LicenseHostPro.getFirstLaunchDatePropertyName(aLicense), String.valueOf(aDate.getTime()));
    }

    protected static String getActivationNumberPropertyName(String aLicenseNumber) {
        return "activationNumber[" + aLicenseNumber + "]";
    }

    protected int getActivationNumber(String aLicenseNumber) {
        return this.getContext().getActivationNumber(aLicenseNumber);
    }

    protected void setActivationNumber(String aLicenseNumber, int aValue) {
        this.getContext().setActivationNumber(aLicenseNumber, aValue);
    }

    private final String getDeactivationKey(License aLicense, boolean isCompleted) {
        byte[] licenseKeyBytes = this.getLicenseReader().getDecryptKeyBytes();
        long licenseKeyBytesSum = 0L;
        for (int i = 0; i < licenseKeyBytes.length; ++i) {
            licenseKeyBytesSum += (long)licenseKeyBytes[i];
        }
        String deactivationKey = (isCompleted ? "17" : "12") + String.valueOf(licenseKeyBytesSum + (long)aLicense.getProperty("pr.ak", "").hashCode());
        return LicenseHostPro.getActivationKey(deactivationKey.getBytes(), LicenseHostPro.getActivationKeyChars(true));
    }

    public boolean canDeactivateLicense() {
        License license = this.getLicense(false);
        return license != null && license.getLicenseType() == 3 && license.getLicenseState() == 2 && (BitTools.checkBit(license.getLicenseOptions(), 1) || BitTools.checkBit(license.getLicenseOptions(), 2)) && !StringUtils.noValue(license.getProperty("pr.ak", null));
    }

    public String deactivateLicense() {
        boolean completed;
        LicenseImpl license = (LicenseImpl)this.getLicense(false);
        String licenseNumber = license.getLicenseNumber();
        int activationNumber = this.getActivationNumber(licenseNumber) + 1;
        this.setActivationNumber(licenseNumber, activationNumber);
        boolean bl = completed = activationNumber == this.getActivationNumber(licenseNumber);
        if (completed) {
            license.setLicenseState(5);
        }
        String result = this.getDeactivationKey(license, completed);
        if (completed) {
            this.setLatestDeactivationKey(license, result);
            this.setLatestActivationKey(license, license.getActivationKey());
        }
        return result;
    }

    protected int getInstallID() {
        return this.getContext().getInstallID();
    }

    public LicenseHostProContext getContext() {
        return this.fContext;
    }

    public void setContext(LicenseHostProContext aContext) {
        if (aContext == null) {
            throw new IllegalArgumentException("Context should not be null");
        }
        this.fContext = aContext;
    }

    public void setVerbose(boolean aVerbose) {
        super.setVerbose(aVerbose);
        this.fContext.setVerbose(aVerbose);
    }

    public String getLicenseExpireInfo(License aLicense) {
        String result = null;
        if (aLicense.getLicenseState() != 3) {
            int usageLeft;
            Date expireDate = this.getLicenseExpirationDate(true);
            if (expireDate != null) {
                result = DATE_FORMAT.format(expireDate);
            }
            if ((usageLeft = this.getUseCountLeft(aLicense)) >= 0) {
                result = usageLeft == 0 ? (result != null ? result + res.getString("Or_Next_Run") : res.getString("Next_Run")) : (result != null ? result + FMT_OR_USAGES_LEFT.format(new Object[]{new Integer(usageLeft)}) : FMT_USAGES_LEFT.format(new Object[]{new Integer(usageLeft)}));
            }
        }
        return result;
    }

    public void setLicenseReader(LicenseReader aLicenseReader) {
        if (this.fLicenseReader != null) {
            this.fLicenseReader.removeLicenseReaderListener(this.getLicenseReaderListener());
        }
        super.setLicenseReader(aLicenseReader);
        if (this.fLicenseReader != null) {
            this.fLicenseReader.addLicenseReaderListener(this.getLicenseReaderListener());
        }
    }

    protected LicenseReaderListener getLicenseReaderListener() {
        if (this.fLicenseReaderListener == null) {
            this.fLicenseReaderListener = new LicenseAdapter(false){

                public void licenseAboutToRead(LicenseReader aSource, String aProductID) {
                    LicenseHostPro.this.stopNetworkCheck();
                }
            };
        }
        return this.fLicenseReaderListener;
    }

    protected static String getLatestDeactivationKeyPropertyName(License aLicense) {
        return "latestDeactivationKey[" + aLicense.getLicenseNumber() + "]";
    }

    public String getLatestDeactivationKey() {
        License license = this.getLicense();
        return license != null ? this.getLatestDeactivationKey(license) : null;
    }

    protected String getLatestDeactivationKey(License aLicense) {
        return this.loadSecretStorageProperty(LicenseHostPro.getLatestDeactivationKeyPropertyName(aLicense), null);
    }

    protected void setLatestDeactivationKey(License aLicense, String aDeactivationKey) {
        this.saveSecretStorageProperty(LicenseHostPro.getLatestDeactivationKeyPropertyName(aLicense), aDeactivationKey);
    }

    protected static String getLatestActivationKeyPropertyName(License aLicense) {
        return "latestActivationKey[" + aLicense.getLicenseNumber() + "]";
    }

    public String getLatestActivationKey() {
        License license = this.getLicense();
        return license != null ? this.getLatestActivationKey(license) : null;
    }

    protected String getLatestActivationKey(License aLicense) {
        return this.loadSecretStorageProperty(LicenseHostPro.getLatestActivationKeyPropertyName(aLicense), null);
    }

    protected void setLatestActivationKey(License aLicense, String anActivationKey) {
        this.saveSecretStorageProperty(LicenseHostPro.getLatestActivationKeyPropertyName(aLicense), anActivationKey);
    }

    static {
        try {
            LicenseHostPro.setNativeLibFolder(new File("../native_lib/"));
        }
        catch (NoClassDefFoundError ex) {
            System.err.println("Class not found: " + ex.getMessage());
        }
        ACTIVATION_KEY_CHARS_STRIPPED = new char[]{'W', 'Y', 'V', 'J', 'N', 'X', 'R', 'H', '3', 'G', '5', 'C', '4', 'P', '6', 'A', 'L', '7', 'U', 'F', '8', 'E', 'D', '9', 'T', 'B', 'Q', 'K', 'M'};
        ACTIVATION_KEY_CHARS = new char[]{'1', 'W', 'Y', 'Z', 'V', '2', 'J', 'N', 'X', 'R', 'H', '3', 'O', 'I', 'G', '5', 'C', '4', 'P', '6', 'A', 'L', '7', 'U', 'F', '8', 'S', 'E', 'D', '9', 'T', 'B', '0', 'Q', 'K', 'M'};
        FMT_OR_USAGES_LEFT = new MessageFormat(res.getString("Or_Usages_Left"));
        FMT_USAGES_LEFT = new MessageFormat(res.getString("Usages_Left"));
    }
}

