/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro;

import com.jp.protection.pub.pro.IntegrityHostPro;
import com.jp.protection.security.SecurityProvider;
import com.jp.protection.security.SecurityProviderFactory;
import com.jp.protection.utils.LicenseUtils;
import dev.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class IntegrityHostProConfigReader {
    protected boolean fVerbose = false;
    protected boolean fSkipEncryption = false;
    protected String fSecurityAlgorithm = "RSA";
    protected byte[] fDecryptKeyBytes;
    protected SecurityProvider fSecurityProvider;

    protected SecurityProvider getSecurityProvider() {
        if (this.fSecurityProvider == null || !this.fSecurityProvider.getID().equals(this.fSecurityAlgorithm)) {
            this.fSecurityProvider = SecurityProviderFactory.getSecurityProvider(this.fSecurityAlgorithm);
        }
        return this.fSecurityProvider;
    }

    public String getSecurityAlgorithm() {
        return this.fSecurityAlgorithm;
    }

    public void setSecurityAlgorithm(String aSecurityAlgorithm) {
        this.fSecurityAlgorithm = aSecurityAlgorithm;
    }

    public byte[] getDecryptKeyBytes() {
        return this.fDecryptKeyBytes;
    }

    public void setDecryptKeyBytes(byte[] aDecryptKeyBytes) {
        this.fDecryptKeyBytes = aDecryptKeyBytes;
    }

    public void setDecryptKeyBytes(String aDecryptKeyBytes) {
        this.fDecryptKeyBytes = LicenseUtils.toBytes(aDecryptKeyBytes);
    }

    public boolean isSkipEncryption() {
        return this.fSkipEncryption;
    }

    public void setSkipEncryption(boolean aSkipEncryption) {
        this.fSkipEncryption = aSkipEncryption;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    protected void error(Throwable aThrowable) {
        if (this.isVerbose()) {
            aThrowable.printStackTrace();
        }
    }

    private byte[] decode(byte[] aConfigBytes) {
        byte[] result = aConfigBytes;
        if (!this.isSkipEncryption()) {
            try {
                SecurityProvider securityProvider = this.getSecurityProvider();
                PublicKey publicKey = securityProvider.getPublicKey(this.fDecryptKeyBytes);
                result = securityProvider.decode(aConfigBytes, publicKey);
            }
            catch (Exception ex) {
                result = null;
                this.error(ex);
            }
        }
        return result;
    }

    public void read(IntegrityHostPro.Config aConfig, InputStream anInputStream) throws IOException {
        this.read(aConfig, StreamUtil.readB(anInputStream));
    }

    public void read(IntegrityHostPro.Config aConfig, String aResourceName) throws IOException {
        this.read(aConfig, this.getClass().getResourceAsStream(aResourceName));
    }

    protected void read(IntegrityHostPro.Config aConfig, byte[] aConfigBytes) throws IOException {
        aConfigBytes = this.decode(aConfigBytes);
        Properties properties = new Properties();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(aConfigBytes);
        properties.load(byteArrayInputStream);
        aConfig.load(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(IntegrityHostPro.Config aConfig, File aFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(aFile);
        try {
            this.read(aConfig, inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(IntegrityHostPro.Config aConfig, File aJarFile, String anEntryName) throws IOException {
        JarFile jarFile = new JarFile(aJarFile);
        try {
            JarEntry jarEntry = jarFile.getJarEntry(anEntryName);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            try {
                this.read(aConfig, inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        finally {
            jarFile.close();
        }
    }
}

