/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro;

import com.jp.protection.pub.IntegrityHost;
import com.jp.protection.pub.pro.IntegrityHostProConfigReader;
import com.jp.protection.utils.LicenseUtils;
import com.jp.util.IndexedPropertiesSupport;
import dev.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;

public class IntegrityHostPro
extends IntegrityHost {
    protected String[] fFiles;

    public IntegrityHostPro(String[] aDigestEntries, byte[] aCheckDigest) {
        super(aDigestEntries, aCheckDigest);
    }

    public IntegrityHostPro(String[] aDigestEntries, String[] aFiles, byte[] aCheckDigest) {
        super(aDigestEntries, aCheckDigest);
        this.setFiles(aFiles);
    }

    public IntegrityHostPro() {
    }

    public String[] getFiles() {
        return this.fFiles;
    }

    public void setFiles(String[] aFiles) {
        this.fFiles = aFiles;
    }

    protected static File[] toFiles(String[] aFiles) {
        File[] result = new File[aFiles.length];
        for (int i = 0; i < aFiles.length; ++i) {
            result[i] = new File(aFiles[i]);
        }
        return result;
    }

    public boolean check() {
        if (this.fDigestEntries != null) {
            this.calculateDigest(this.fDigestEntries);
        }
        if (this.fFiles != null) {
            this.calculateDigest(IntegrityHostPro.toFiles(this.fFiles), false);
        }
        return Arrays.equals(this.getDigest(), this.fCheckDigest);
    }

    public static boolean checkStatic(String[] aDigestEntries, String[] aFiles, byte[] aCheckDigest, int anAlgorithm) {
        IntegrityHostPro host = new IntegrityHostPro();
        host.setAlgorithm(anAlgorithm);
        host.setFiles(aFiles);
        host.setDigestEntries(aDigestEntries);
        host.setCheckDigest(aCheckDigest);
        return host.check();
    }

    public static boolean checkStatic(IntegrityHostProConfigReader aReader, File aFile) {
        return new IntegrityHostPro().check(aReader, aFile);
    }

    public static boolean checkStatic(IntegrityHostProConfigReader aReader, File aJarFile, String anEntryName) {
        return new IntegrityHostPro().check(aReader, aJarFile, anEntryName);
    }

    public static boolean checkStatic(IntegrityHostProConfigReader aReader, Class aBaseClass, String aResourceName) {
        return new IntegrityHostPro().check(aReader, aBaseClass, aResourceName);
    }

    public static boolean checkStatic(IntegrityHostProConfigReader aReader, String aResourceName) {
        return new IntegrityHostPro().check(aReader, aResourceName);
    }

    public boolean check(IntegrityHostProConfigReader aReader, File aJarFile, String anEntryName) {
        try {
            Config config = new Config();
            aReader.read(config, aJarFile, anEntryName);
            return this.check(config);
        }
        catch (Exception ex) {
            this.error(ex);
            return false;
        }
    }

    public boolean check(IntegrityHostProConfigReader aReader, String aResourceName) {
        return this.check(aReader, this.getClass(), aResourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(IntegrityHostProConfigReader aReader, Class aBaseClass, String aResourceName) {
        boolean bl;
        InputStream stream = aBaseClass.getResourceAsStream(aResourceName);
        if (stream == null) {
            this.error("Digest configuration not found: " + aResourceName);
            return false;
        }
        try {
            Config config = new Config();
            aReader.read(config, stream);
            bl = this.check(config);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception ex) {
                this.error(ex);
                return false;
            }
        }
        stream.close();
        return bl;
    }

    public boolean check(IntegrityHostProConfigReader aReader, File aFile) {
        try {
            Config config = new Config();
            aReader.read(config, aFile);
            return this.check(config);
        }
        catch (Exception ex) {
            this.error(ex);
            return false;
        }
    }

    public static boolean checkStatic(Config aConfig) {
        return new IntegrityHostPro().check(aConfig);
    }

    public boolean check(Config aConfig) {
        this.setFiles(aConfig.getFiles());
        this.setDigestEntries(aConfig.getDigestEntries());
        this.setCheckDigest(aConfig.getDigest());
        this.setAlgorithm(aConfig.getAlgorithm());
        return this.check();
    }

    public boolean check(File[] aFiles, byte[] aCheckDigest) {
        this.calculateDigest(aFiles);
        return Arrays.equals(this.getDigest(), aCheckDigest);
    }

    protected void calculateDigest(File[] aFiles) {
        this.calculateDigest(aFiles, true);
    }

    protected void calculateDigest(File[] aFiles, boolean isReset) {
        if (isReset) {
            this.resetDigest();
        }
        this.updateDigest(aFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDigest(File[] aFiles) {
        if (aFiles != null && aFiles.length > 0) {
            try {
                for (int i = 0; i < aFiles.length; ++i) {
                    FileInputStream inputStream = new FileInputStream(aFiles[i]);
                    try {
                        this.updateDigest(StreamUtil.readB(inputStream));
                        continue;
                    }
                    finally {
                        ((InputStream)inputStream).close();
                    }
                }
            }
            catch (Exception ex) {
                this.error(ex);
            }
        }
    }

    public static class Config {
        protected String[] fFiles;
        protected String[] fDigestEntries;
        protected byte[] fDigest;
        protected int fAlgorithm = 1;
        public static final String INDEX_CRC_ENTRY = "crcEntry";
        public static final String INDEX_FILE = "file";
        public static final String PROPERTY_NAME = "name";
        public static final String PROPERTY_DIGEST = "digest";
        public static final String PROPERTY_ALGORITHM = "algorithm";

        public Config() {
        }

        public Config(String[] aDigestEntries, String[] aFiles, int aAlgorithm, byte[] aDigest) {
            this.fDigestEntries = aDigestEntries;
            this.fFiles = aFiles;
            this.fAlgorithm = aAlgorithm;
            this.fDigest = aDigest;
        }

        public String[] getDigestEntries() {
            return this.fDigestEntries;
        }

        public int getAlgorithm() {
            return this.fAlgorithm;
        }

        public byte[] getDigest() {
            return this.fDigest;
        }

        public String[] getFiles() {
            return this.fFiles;
        }

        protected void save(String[] aValues, String anIndexName, Properties aProperties) {
            IndexedPropertiesSupport indexedPropertiesSupport = new IndexedPropertiesSupport(aProperties);
            indexedPropertiesSupport.setIndexName(anIndexName);
            indexedPropertiesSupport.setItemCount(aValues.length);
            for (int i = 0; i < aValues.length; ++i) {
                indexedPropertiesSupport.setIndex(i);
                indexedPropertiesSupport.setProperty(PROPERTY_NAME, aValues[i]);
            }
        }

        protected String[] load(String anIndexName, Properties aProperties) {
            String[] result = null;
            IndexedPropertiesSupport indexedPropertiesSupport = new IndexedPropertiesSupport(aProperties);
            indexedPropertiesSupport.setIndexName(anIndexName);
            int count = indexedPropertiesSupport.getItemCount();
            if (count > 0) {
                result = new String[count];
                for (int i = 0; i < count; ++i) {
                    indexedPropertiesSupport.setIndex(i);
                    result[i] = indexedPropertiesSupport.getProperty(PROPERTY_NAME);
                }
            }
            return result;
        }

        public void save(Properties aProperties) {
            if (this.fDigestEntries != null) {
                this.save(this.fDigestEntries, INDEX_CRC_ENTRY, aProperties);
            }
            if (this.fFiles != null) {
                this.save(this.fFiles, INDEX_FILE, aProperties);
            }
            if (this.fDigest != null) {
                aProperties.put(PROPERTY_DIGEST, LicenseUtils.toString(this.fDigest));
            }
            aProperties.put(PROPERTY_ALGORITHM, String.valueOf(this.fAlgorithm));
        }

        public void load(Properties aProperties) {
            this.fDigestEntries = this.load(INDEX_CRC_ENTRY, aProperties);
            this.fFiles = this.load(INDEX_FILE, aProperties);
            String strDigest = aProperties.getProperty(PROPERTY_DIGEST);
            if (strDigest != null) {
                this.fDigest = LicenseUtils.toBytes(strDigest);
            }
            this.fAlgorithm = Integer.parseInt(aProperties.getProperty(PROPERTY_ALGORITHM));
        }
    }
}

